/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.validation;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentProperties;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.validation.JSPContentValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.validation.HTMLValidationReporter;
import org.eclipse.wst.html.core.internal.validate.HTMLValidationAdapterFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.validate.ValidationAdapter;
import org.eclipse.wst.sse.core.internal.validate.ValidationReporter;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Text;

public class JSPContentSourceValidator
extends JSPContentValidator
implements ISourceValidator {
    private IDocument fDocument;
    private boolean fEnableSourceValidation;
    private IContentType fJSPFContentType = null;

    public void connect(IDocument document) {
        this.fDocument = document;
        IFile file = null;
        IStructuredModel model = null;
        try {
            String baseLocation;
            Path basePath;
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model != null && (basePath = new Path(baseLocation = model.getBaseLocation())).segmentCount() > 1 && !(file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)basePath)).exists()) {
                file = null;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        this.fEnableSourceValidation = file != null && this.isBatchValidatorPreferenceEnabled(file) && this.shouldValidate(file) && this.fragmentCheck(file);
    }

    public void disconnect(IDocument document) {
        this.fDocument = null;
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        if (helper == null || this.fDocument == null || !this.fEnableSourceValidation) {
            return;
        }
        if (reporter != null && reporter.isCancelled()) {
            throw new OperationCanceledException();
        }
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
        if (model == null) {
            return;
        }
        try {
            IDOMDocument document = null;
            if (model instanceof IDOMModel) {
                document = ((IDOMModel)model).getDocument();
            }
            if (document == null || !this.hasHTMLFeature(document)) {
                return;
            }
            ITextFileBuffer fb = FileBufferModelManager.getInstance().getBuffer(this.fDocument);
            if (fb == null) {
                return;
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(fb.getLocation());
            if (file == null || !file.exists()) {
                return;
            }
            IndexedRegion ir = this.getCoveringNode(dirtyRegion);
            if (ir instanceof Text) {
                while (ir != null && ir instanceof Text) {
                    ir = model.getIndexedRegion(ir.getEndOffset());
                }
            }
            if (ir instanceof INodeNotifier) {
                HTMLValidationAdapterFactory factory = HTMLValidationAdapterFactory.getInstance();
                ValidationAdapter adapter = (ValidationAdapter)factory.adapt((INodeNotifier)ir);
                if (adapter == null) {
                    return;
                }
                if (reporter != null) {
                    HTMLValidationReporter rep = null;
                    rep = this.getReporter(reporter, file, (IDOMModel)model);
                    rep.clear();
                    adapter.setReporter((ValidationReporter)rep);
                    JSPValidator.LocalizedMessage mess = new JSPValidator.LocalizedMessage((JSPValidator)this, 4, file.getFullPath().toString().substring(1));
                    reporter.displaySubtask((IValidator)this, (IMessage)mess);
                }
                adapter.validate(ir);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private IndexedRegion getCoveringNode(IRegion dirtyRegion) {
        IndexedRegion largestRegion = null;
        if (this.fDocument instanceof IStructuredDocument) {
            IStructuredDocumentRegion[] regions = ((IStructuredDocument)this.fDocument).getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
            largestRegion = this.getLargest(regions);
        }
        return largestRegion;
    }

    private IndexedRegion getLargest(IStructuredDocumentRegion[] sdRegions) {
        if (sdRegions == null || sdRegions.length == 0) {
            return null;
        }
        IndexedRegion currentLargest = this.getCorrespondingNode(sdRegions[0]);
        int i = 0;
        while (i < sdRegions.length) {
            if (!sdRegions[i].isDeleted()) {
                IndexedRegion corresponding = this.getCorrespondingNode(sdRegions[i]);
                if (currentLargest instanceof Text) {
                    currentLargest = corresponding;
                }
                if (corresponding != null && !(corresponding instanceof Text) && corresponding.getStartOffset() <= currentLargest.getStartOffset() && corresponding.getEndOffset() >= currentLargest.getEndOffset()) {
                    currentLargest = corresponding;
                }
            }
            ++i;
        }
        return currentLargest;
    }

    protected IndexedRegion getCorrespondingNode(IStructuredDocumentRegion sdRegion) {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
        IndexedRegion indexedRegion = null;
        try {
            if (sModel != null) {
                indexedRegion = sModel.getIndexedRegion(sdRegion.getStart());
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return indexedRegion;
    }

    private boolean hasHTMLFeature(IDOMDocument document) {
        DocumentTypeAdapter adapter = (DocumentTypeAdapter)document.getAdapterFor(DocumentTypeAdapter.class);
        if (adapter == null) {
            return false;
        }
        return adapter.hasFeature("HTML");
    }

    private HTMLValidationReporter getReporter(IReporter reporter, IFile file, IDOMModel model) {
        return new HTMLValidationReporter((IValidator)this, reporter, file, (IStructuredModel)model);
    }

    private ValidationConfiguration getValidationConfiguration(IFile file) {
        IProject project;
        ProjectConfiguration configuration = null;
        if (file != null && (project = file.getProject()) != null) {
            try {
                ProjectConfiguration projectConfiguration;
                configuration = projectConfiguration = ConfigurationManager.getManager().getProjectConfiguration(project);
                if (projectConfiguration == null || projectConfiguration.useGlobalPreference()) {
                    configuration = ConfigurationManager.getManager().getGlobalConfiguration();
                }
            }
            catch (InvocationTargetException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
        return configuration;
    }

    private boolean isBatchValidatorPreferenceEnabled(IFile file) {
        ValidatorMetaData metadata;
        if (file == null) {
            return true;
        }
        boolean enabled = true;
        ValidationConfiguration configuration = this.getValidationConfiguration(file);
        if (configuration != null && (metadata = ValidationRegistryReader.getReader().getValidatorMetaData(JSPContentValidator.class.getName())) != null && !configuration.isBuildEnabled(metadata) && !configuration.isManualEnabled(metadata)) {
            enabled = false;
        }
        return enabled;
    }

    private boolean fragmentCheck(IFile file) {
        boolean shouldValidateFragments;
        boolean shouldValidate = true;
        if (this.getJSPFContentType().isAssociatedWith(file.getName()) && !(shouldValidateFragments = Boolean.valueOf(JSPFContentProperties.getProperty((String)"validateFragments", (IResource)file, (boolean)true)).booleanValue())) {
            boolean isFragment = this.isFragment(file);
            shouldValidate = !isFragment;
        }
        return shouldValidate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFragment(IFile file) {
        boolean isFragment = false;
        InputStream is = null;
        try {
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription == null) {
                is = file.getContents();
                contentDescription = Platform.getContentTypeManager().getDescriptionFor(is, file.getName(), new QualifiedName[]{IContentDescription.CHARSET});
            }
            if (contentDescription != null) {
                String fileCtId = contentDescription.getContentType().getId();
                isFragment = fileCtId != null && ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT.equals(fileCtId);
            }
        }
        catch (IOException iOException) {
            if (is == null) return isFragment;
            try {
                is.close();
                return isFragment;
            }
            catch (Exception exception) {}
            return isFragment;
        }
        catch (CoreException coreException) {
            try {
                if (is == null) return isFragment;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                is.close();
                return isFragment;
            }
            catch (Exception exception) {}
            return isFragment;
        }
        if (is == null) return isFragment;
        try {
            is.close();
            return isFragment;
        }
        catch (Exception exception) {}
        return isFragment;
    }

    private boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    private IContentType getJSPFContentType() {
        if (this.fJSPFContentType == null) {
            this.fJSPFContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT);
        }
        return this.fJSPFContentType;
    }
}

