/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.range;

import org.eclipse.gef.commands.Command;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.actions.range.DesignerToolBarAction;
import org.eclipse.jst.pagedesigner.commands.range.ApplyStyleCommand;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.DOMRangeHelper;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Node;

public class ChangeStyleAction
extends DesignerToolBarAction {
    private final String _expectedTag;

    public ChangeStyleAction(String text, String name, ImageDescriptor image, int style) {
        super(text, style);
        this._expectedTag = name;
        this.setImageDescriptor(image);
    }

    public ChangeStyleAction(String text, String name, ImageDescriptor enabled, ImageDescriptor disabled, int style) {
        super(text, style);
        this._expectedTag = name;
        this.setImageDescriptor(enabled);
        this.setDisabledImageDescriptor(disabled);
    }

    @Override
    protected boolean isApplied(DOMRange range) {
        if (range == null) {
            return false;
        }
        boolean ordered = range.isOrdered();
        IDOMPosition start = ordered ? range.getStartPosition() : range.getEndPosition();
        IDOMPosition end = ordered ? range.getEndPosition() : range.getStartPosition();
        Node startnode = start.getContainerNode();
        Node endnode = end.getContainerNode();
        if (!EditModelQuery.hasAncestor(startnode, this._expectedTag, true)) {
            return false;
        }
        Node node = startnode;
        while (node != endnode) {
            if (!EditModelQuery.hasAncestor(node, this._expectedTag, true)) {
                return false;
            }
            node = EditModelQuery.getInstance().getNextLeafNeighbor(node);
        }
        return EditModelQuery.hasAncestor(endnode, this._expectedTag, true);
    }

    protected String getExpectedTag() {
        return this._expectedTag;
    }

    @Override
    protected Command getCommand() {
        ApplyStyleCommand command;
        DesignRange range = this.getViewer().getRangeSelection();
        DOMRange dRange = DOMRangeHelper.toDOMRange(range);
        if (this.isApplied(dRange)) {
            command = null;
            this.setChecked(true);
        } else {
            command = new ApplyStyleCommand(this.getViewer(), this._expectedTag, null, null);
        }
        return command;
    }

    @Override
    public void update() {
        if (this.canRun(this.getViewer())) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
        this.updateStatus();
    }

    @Override
    public void updateStatus() {
        DesignRange range;
        IHTMLGraphicalViewer viewer = this.getViewer();
        if (viewer != null && viewer.isInRangeMode() && viewer.getModel().getDocument().hasChildNodes() && (range = this.getViewer().getRangeSelection()) != null && range.isValid()) {
            DOMRange domRange = null;
            domRange = new DOMRange(DOMPositionHelper.toDOMPosition(range.getStartPosition()), DOMPositionHelper.toDOMPosition(range.getEndPosition()));
            if (this.isApplied(domRange)) {
                this.setChecked(true);
            } else {
                this.setChecked(false);
            }
            return;
        }
        this.setChecked(false);
    }

    @Override
    protected boolean canRun(IHTMLGraphicalViewer viewer) {
        DesignPosition endPos;
        DesignPosition startPos;
        DesignRange range;
        return viewer != null && viewer.isInRangeMode() && viewer.getModel().getDocument().hasChildNodes() && (range = viewer.getRangeSelection()) != null && range.isValid() && (startPos = range.getStartPosition()) != (endPos = range.getEndPosition());
    }
}

