/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.PageDesignerTraceOptions;
import org.eclipse.jst.pagedesigner.converter.IConverterFactory;

public class ConverterFacRegistryReader {
    private static List<IConverterFactory> _handlers = null;

    public static synchronized List<IConverterFactory> getAllHandlers() {
        if (_handlers == null) {
            _handlers = ConverterFacRegistryReader.readAllHandlers();
        }
        return Collections.unmodifiableList(_handlers);
    }

    private static List<IConverterFactory> readAllHandlers() {
        ArrayList<IConverterFactory> result = new ArrayList<IConverterFactory>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "pageDesignerExtension");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] tagConverter = ext.getConfigurationElements();
            int j = 0;
            while (j < tagConverter.length) {
                IConfigurationElement element = tagConverter[j];
                if (element.getName().equals("tagConverterFactory")) {
                    element.getAttribute("class");
                    try {
                        Object obj = element.createExecutableExtension("class");
                        if (element.getContributor().getName().startsWith("org.eclipse.jst")) {
                            if (PageDesignerTraceOptions.TRACE_CONVERTERLOAD) {
                                PageDesignerTraceOptions.log("ConverterFacRegistryReader: Appending to list:" + obj.getClass().getName());
                            }
                            result.add((IConverterFactory)obj);
                        } else {
                            if (PageDesignerTraceOptions.TRACE_CONVERTERLOAD) {
                                PageDesignerTraceOptions.log("ConverterFacRegistryReader: Prepending to list:" + obj.getClass().getName());
                            }
                            result.add(0, (IConverterFactory)obj);
                        }
                    }
                    catch (CoreException e) {
                        PDPlugin.log("Problem loading tag converter extension for " + element.toString(), e);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (PageDesignerTraceOptions.TRACE_CONVERTERLOAD) {
            PageDesignerTraceOptions.log("\nFinal converterFactory list in order:");
            for (IConverterFactory factory : result) {
                PageDesignerTraceOptions.log(factory.getClass().getName());
            }
            PageDesignerTraceOptions.log("\n");
        }
        return result;
    }
}

