/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.property.CSSPropertyMeta;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class FontFamilyMeta
extends CSSPropertyMeta {
    public static final String DEFAULT_FONT = "Times New Roman";
    private static FontData[] _FontData;

    private static FontData[] getFontData() {
        if (_FontData == null) {
            ArrayList<FontData> list = new ArrayList<FontData>();
            list.addAll(Arrays.asList(Display.getCurrent().getFontList(null, false)));
            list.addAll(Arrays.asList(Display.getCurrent().getFontList(null, true)));
            _FontData = list.toArray(new FontData[list.size()]);
        }
        return _FontData;
    }

    public FontFamilyMeta() {
        super(true, DEFAULT_FONT);
    }

    @Override
    protected String[] getKeywordValues() {
        return null;
    }

    @Override
    public Object calculateCSSValueResult(CSSValue value, String propertyName, ICSSStyle style) {
        if (value.getCssValueType() == 2) {
            CSSValueList valueList = (CSSValueList)value;
            int i = 0;
            int count = valueList.getLength();
            while (i < count) {
                String name = valueList.item(i).getCssText();
                if (this.isSupportedFont(name = this.trimPadding(name))) {
                    return name;
                }
                ++i;
            }
        }
        return this.trimPadding(value.getCssText());
    }

    private String trimPadding(String name) {
        String value = name;
        if (value != null) {
            value = value.replaceAll("\"", "");
            value = value.replaceAll("'", "");
        }
        return value;
    }

    private boolean isSupportedFont(String name) {
        FontData[] fontData = FontFamilyMeta.getFontData();
        int i = 0;
        while (i < fontData.length) {
            if (fontData[i].getName().equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object calculateHTMLAttributeOverride(Element element, String htmltag, String propertyName, ICSSStyle style) {
        if ("FONT".equalsIgnoreCase(htmltag) || "BASEFONT".equalsIgnoreCase(htmltag)) {
            String face = DOMUtil.getAttributeIgnoreCase(element, "face");
            if (face != null) {
                String[] names = this.getFontNameList(face);
                int i = 0;
                while (i < names.length) {
                    if (this.isSupportedFont(names[i])) {
                        return names[i];
                    }
                    ++i;
                }
            } else {
                return null;
            }
        }
        return null;
    }

    private String[] getFontNameList(String face) {
        StringTokenizer tokenizer = new StringTokenizer(face, ",");
        String[] names = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < names.length) {
            names[i] = this.trimPadding(tokenizer.nextToken());
            ++i;
        }
        return names;
    }
}

