/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jst.pagedesigner.PDPlugin;

class OutlineTargetListenerReader {
    private static final String CLASS = "class";
    private static List<TransferDropTargetListener> _listeners;

    public static synchronized List<TransferDropTargetListener> getListeners() {
        if (_listeners == null) {
            _listeners = OutlineTargetListenerReader.readListeners();
        }
        return Collections.unmodifiableList(_listeners);
    }

    private static List<TransferDropTargetListener> readListeners() {
        ArrayList<TransferDropTargetListener> listeners = new ArrayList<TransferDropTargetListener>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "pageDesignerExtension");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] pageDesignerElements = ext.getConfigurationElements();
            int j = 0;
            while (j < pageDesignerElements.length) {
                IConfigurationElement pageDesignerElement = pageDesignerElements[j];
                if (pageDesignerElement.getName().equals("outlineTargetListener")) {
                    pageDesignerElement.getAttribute(CLASS);
                    try {
                        Object object = pageDesignerElement.createExecutableExtension(CLASS);
                        if (object instanceof TransferDropTargetListener) {
                            listeners.add((TransferDropTargetListener)object);
                        }
                    }
                    catch (CoreException e) {
                        PDPlugin.log("Problem loading transfer drop target listener for " + String.valueOf(pageDesignerElement), e);
                    }
                }
                ++j;
            }
            ++i;
        }
        return listeners;
    }

    private OutlineTargetListenerReader() {
        throw new IllegalStateException("Should not be instantiated!");
    }
}

