/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.jst.server.tomcat.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.PublisherDelegate;

public class ContextPublisherDelegate
extends PublisherDelegate {
    private static final QualifiedName QUALIFIED_NAME = new QualifiedName("org.eclipse.jst.server.tomcat.ui", "contextRoot");

    public IStatus execute(int kind, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        if (info == null) {
            return Status.OK_STATUS;
        }
        final Shell shell = (Shell)info.getAdapter(Shell.class);
        if (shell == null) {
            return Status.OK_STATUS;
        }
        IServer server = (IServer)this.getTaskModel().getObject("server");
        TomcatServer tomcatServer = (TomcatServer)server.loadAdapter(TomcatServer.class, monitor);
        final TomcatConfiguration configuration = tomcatServer.getTomcatConfiguration();
        final boolean[] save = new boolean[1];
        List modules = (List)this.getTaskModel().getObject("modules");
        int size = modules.size();
        int i = 0;
        while (i < size) {
            IModule[] module = (IModule[])modules.get(i);
            final IModule m = module[module.length - 1];
            IWebModule webModule = (IWebModule)m.loadAdapter(IWebModule.class, monitor);
            final WebModule webModule2 = configuration.getWebModule(m);
            if (webModule != null && webModule2 != null) {
                String contextRoot = webModule.getContextRoot();
                if (contextRoot != null && !contextRoot.startsWith("/") && contextRoot.length() > 0) {
                    contextRoot = "/" + contextRoot;
                }
                if (!contextRoot.equals(webModule2.getPath()) && this.shouldPrompt(m, contextRoot)) {
                    final String context = contextRoot;
                    shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (MessageDialog.openQuestion((Shell)shell, (String)Messages.wizardTitle, (String)NLS.bind((String)Messages.contextCleanup, (Object)m.getName()))) {
                                int index = configuration.getWebModules().indexOf(webModule2);
                                configuration.modifyWebModule(index, webModule2.getDocumentBase(), context, webModule2.isReloadable());
                                save[0] = true;
                            }
                        }
                    });
                    this.markProject(m, contextRoot);
                }
            }
            ++i;
        }
        if (save[0]) {
            tomcatServer.saveConfiguration(monitor);
        }
        return Status.OK_STATUS;
    }

    protected boolean shouldPrompt(IModule m, String contextRoot) {
        String s;
        block4: {
            IProject project = m.getProject();
            if (project == null) {
                return true;
            }
            try {
                s = project.getPersistentProperty(QUALIFIED_NAME);
                if (s != null) break block4;
                return true;
            }
            catch (CoreException coreException) {
                return true;
            }
        }
        return !contextRoot.equals(s);
    }

    protected void markProject(IModule m, String contextRoot) {
        IProject project = m.getProject();
        if (project == null) {
            return;
        }
        try {
            project.setPersistentProperty(QUALIFIED_NAME, contextRoot);
        }
        catch (CoreException coreException) {}
    }
}

