/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerHostConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerPortBinding;
import org.eclipse.linuxtools.internal.docker.ui.launch.BuildDockerImageUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.DataVolumeModel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class LaunchConfigurationUtils {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");

    private LaunchConfigurationUtils() {
    }

    public static ILaunchConfigurationType getLaunchConfigType(String configType) {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(configType);
    }

    public static ILaunchConfiguration createRunImageLaunchConfiguration(IDockerImage image, IDockerContainerConfig containerConfig, IDockerHostConfig hostConfig, List<String> unusedPorts, String containerName, boolean removeWhenExits) {
        try {
            DataVolumeModel volume;
            DockerContainerConfig config;
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.linuxtools.docker.ui.runDockerImageLaunchConfigurationType");
            String imageName = LaunchConfigurationUtils.createRunImageLaunchConfigurationName(image);
            ILaunchConfigurationWorkingCopy workingCopy = LaunchConfigurationUtils.getLaunchConfigurationWorkingCopy(type, imageName);
            workingCopy.setAttribute("creationDate", DATE_FORMAT.format(new Date()));
            workingCopy.setAttribute("connectionName", image.getConnection().getName());
            workingCopy.setAttribute("imageId", image.id());
            workingCopy.setAttribute("imageName", LaunchConfigurationUtils.createRunImageLaunchConfigurationName(image));
            if (containerName != null && !containerName.isEmpty()) {
                workingCopy.setAttribute("containerName", containerName);
            }
            if ((config = (DockerContainerConfig)containerConfig).rawcmd() != null) {
                workingCopy.setAttribute("command", config.rawcmd());
            } else {
                workingCopy.setAttribute("command", String.join((CharSequence)" ", containerConfig.cmd()));
            }
            workingCopy.setAttribute("entryPoint", String.join((CharSequence)" ", containerConfig.entrypoint()));
            workingCopy.setAttribute("publishAllPorts", hostConfig.publishAllPorts());
            if (hostConfig.publishAllPorts()) {
                IDockerImageInfo imageInfo = image.getConnection().getImageInfo(image.id());
                if (imageInfo != null) {
                    workingCopy.setAttribute("publishedPorts", LaunchConfigurationUtils.serializePortBindings(imageInfo.config().exposedPorts()));
                }
            } else {
                workingCopy.setAttribute("publishedPorts", LaunchConfigurationUtils.serializePortBindings(hostConfig.portBindings()));
                workingCopy.setAttribute("unusedPorts", unusedPorts);
            }
            workingCopy.setAttribute("links", hostConfig.links());
            workingCopy.setAttribute("envVariables", containerConfig.env());
            workingCopy.setAttribute("labels", containerConfig.labels());
            ArrayList<String> volumes = new ArrayList<String>();
            for (String volumeFrom : hostConfig.volumesFrom()) {
                volume = DataVolumeModel.parseVolumeFrom(volumeFrom);
                if (volume == null) continue;
                volumes.add(volume.toString());
            }
            for (String bind : hostConfig.binds()) {
                volume = DataVolumeModel.parseHostBinding(bind);
                if (volume == null) continue;
                volumes.add(volume.toString());
            }
            for (String volumePath : containerConfig.volumes().keySet()) {
                volume = new DataVolumeModel(volumePath);
                volumes.add(volume.toString());
            }
            workingCopy.setAttribute("volumes", volumes);
            workingCopy.setAttribute("autoRemove", removeWhenExits);
            workingCopy.setAttribute("allocatePseudoTTY", containerConfig.tty());
            workingCopy.setAttribute("interactive", containerConfig.openStdin());
            workingCopy.setAttribute("privileged", hostConfig.privileged());
            workingCopy.setAttribute("readonly", ((DockerHostConfig)hostConfig).readonlyRootfs());
            if (hostConfig.networkMode() != null) {
                workingCopy.setAttribute("networkMode", hostConfig.networkMode());
            }
            if (containerConfig.memory() != null) {
                workingCopy.setAttribute("enableLimits", true);
                workingCopy.setAttribute("memoryLimit", Long.toString(containerConfig.memory() / 0x100000L));
            }
            if (containerConfig.cpuShares() != null) {
                workingCopy.setAttribute("enableLimits", true);
                workingCopy.setAttribute("cpuPriority", containerConfig.cpuShares().toString());
            }
            return workingCopy.doSave();
        }
        catch (CoreException e) {
            Activator.log(Status.error((String)LaunchMessages.getString("RunDockerImageLaunchConfiguration.creation.failure"), (Throwable)e));
            return null;
        }
    }

    private static String createRunImageLaunchConfigurationName(IDockerImage image) {
        return (String)image.repoTags().get(0);
    }

    public static List<String> serializePortBindings(Map<String, List<IDockerPortBinding>> bindings) {
        ArrayList<String> serializedBindings = new ArrayList<String>();
        if (bindings != null) {
            for (Map.Entry<String, List<IDockerPortBinding>> entry : bindings.entrySet()) {
                for (IDockerPortBinding portBinding : entry.getValue()) {
                    StringBuilder portBindingBuilder = new StringBuilder();
                    portBindingBuilder.append(entry.getKey());
                    portBindingBuilder.append(':');
                    if (portBinding.hostIp() != null) {
                        portBindingBuilder.append(portBinding.hostIp());
                    }
                    portBindingBuilder.append(':');
                    portBindingBuilder.append(portBinding.hostPort());
                    serializedBindings.add(portBindingBuilder.toString());
                }
            }
        }
        return serializedBindings;
    }

    public static List<String> serializePortBindings(Set<String> bindings) {
        ArrayList<String> serializedBindings = new ArrayList<String>();
        if (bindings != null) {
            for (String portBinding : bindings) {
                StringBuilder portBindingBuilder = new StringBuilder();
                portBindingBuilder.append(portBinding);
                portBindingBuilder.append(':');
                portBindingBuilder.append(':');
                String[] containerPort = portBinding.split("/");
                portBindingBuilder.append(containerPort[0]);
                serializedBindings.add(portBindingBuilder.toString());
            }
        }
        return serializedBindings;
    }

    public static Map<String, List<IDockerPortBinding>> deserializePortBindings(List<String> bindings) {
        if (bindings == null) {
            return Collections.emptyMap();
        }
        return bindings.stream().map(b -> b.split(":")).collect(Collectors.toMap(split -> split[0], split -> Arrays.asList(new DockerPortBinding(split[1], split[2])), (e1, e2) -> {
            ArrayList merges = new ArrayList();
            merges.addAll(e1);
            merges.addAll(e2);
            return merges;
        }));
    }

    public static int getButtonWidthHint(Button button) {
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static ILaunchConfiguration getLaunchConfigurationByImageName(String type, String imageName) throws CoreException {
        return LaunchConfigurationUtils.getLaunchConfigurationByImageName(LaunchConfigurationUtils.getLaunchConfigType(type), imageName);
    }

    public static ILaunchConfiguration getLaunchConfigurationByImageName(ILaunchConfigurationType type, String imageName) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration lastLaunchConfiguration = null;
        String lastCreationDate = "";
        for (ILaunchConfiguration launchConfiguration : manager.getLaunchConfigurations(type)) {
            String launchConfigImageName = launchConfiguration.getAttribute("imageName", "");
            String launchConfigCreationDate = launchConfiguration.getAttribute("creationDate", "");
            if (!launchConfigImageName.equals(imageName) || launchConfigCreationDate.compareTo(lastCreationDate) <= 0) continue;
            lastCreationDate = launchConfigCreationDate;
            lastLaunchConfiguration = launchConfiguration;
        }
        return lastLaunchConfiguration;
    }

    private static ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy(ILaunchConfigurationType type, String imageName) throws CoreException {
        ILaunchConfiguration existingLaunchConfiguration = LaunchConfigurationUtils.getLaunchConfigurationByImageName(type, imageName);
        if (existingLaunchConfiguration != null) {
            return existingLaunchConfiguration.getWorkingCopy();
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        String configurationName = manager.generateLaunchConfigurationName(imageName);
        return type.newInstance(null, configurationName);
    }

    public static ILaunchConfiguration getLaunchConfigurationByName(String type, String name) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        for (ILaunchConfiguration launchConfiguration : manager.getLaunchConfigurations(LaunchConfigurationUtils.getLaunchConfigType(type))) {
            String launchConfigName = launchConfiguration.getName();
            if (!launchConfigName.equals(name)) continue;
            return launchConfiguration;
        }
        return null;
    }

    public static String convertToUnixPath(String path) {
        return LaunchConfigurationUtils.convertToUnixPath(Platform.getOS(), path);
    }

    public static String convertToUnixPath(String os, String path) {
        Matcher m;
        if (os != null && os.equals("win32") && (m = Pattern.compile("([a-zA-Z]):/").matcher(path.replaceAll("\\\\", "/"))).find()) {
            StringBuffer b = new StringBuffer();
            b.append('/');
            m.appendReplacement(b, m.group(1).toLowerCase());
            b.append('/');
            m.appendTail(b);
            return b.toString();
        }
        return path;
    }

    public static String convertToWin32Path(String path) {
        return LaunchConfigurationUtils.convertToWin32Path(Platform.getOS(), path);
    }

    public static String convertToWin32Path(String os, String path) {
        Matcher m;
        if (os != null && os.equals("win32") && (m = Pattern.compile("^/([a-zA-Z])/").matcher(path)).find()) {
            StringBuffer b = new StringBuffer();
            m.appendReplacement(b, m.group(1).toUpperCase());
            b.append(":\\");
            m.appendTail(b);
            return b.toString().replace('/', '\\');
        }
        return path;
    }

    public static String createBuildImageLaunchConfigurationName(String imageName, IResource resource) {
        if (imageName != null) {
            String repository = BuildDockerImageUtils.getRepository(imageName);
            String name = BuildDockerImageUtils.getName(imageName);
            String tag = BuildDockerImageUtils.getTag(imageName);
            StringBuilder configNameBuilder = new StringBuilder();
            if (name != null) {
                if (repository != null) {
                    configNameBuilder.append(repository).append('_');
                }
                configNameBuilder.append(name);
                if (tag != null) {
                    configNameBuilder.append(" [").append(tag).append("]");
                } else {
                    configNameBuilder.append(" [latest]");
                }
                return configNameBuilder.toString();
            }
        }
        return "Dockerfile [" + resource.getProject().getName() + "]";
    }

    public static ILaunchConfiguration createBuildImageLaunchConfiguration(IDockerConnection connection, String repoName, IResource dockerfile) throws CoreException {
        ILaunchConfigurationType configType = LaunchConfigurationUtils.getLaunchConfigType("org.eclipse.linuxtools.docker.ui.buildDockerImageLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy wc = LaunchConfigurationUtils.getLaunchConfigurationWorkingCopy(configType, LaunchConfigurationUtils.createBuildImageLaunchConfigurationName(repoName, dockerfile));
        wc.setAttribute("sourcePathLocation", dockerfile.getFullPath().removeLastSegments(1).toString());
        wc.setAttribute("dockerfileName", dockerfile.getFullPath().lastSegment());
        wc.setAttribute("sourcePathWorkspaceRelativeLocation", true);
        wc.setAttribute("dockerConnection", connection.getName());
        wc.setAttribute("repoName", repoName);
        return wc.doSave();
    }

    public static ILaunchConfiguration createDockerComposeUpLaunchConfiguration(IDockerConnection connection, IResource dockerComposeScript) throws CoreException {
        ILaunchConfigurationType configType = LaunchConfigurationUtils.getLaunchConfigType("org.eclipse.linuxtools.docker.ui.dockerComposeUpLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(LaunchConfigurationUtils.createDockerComposeLaunchConfigurationName(dockerComposeScript)));
        wc.setAttribute("workingDir", dockerComposeScript.getFullPath().removeLastSegments(1).toString());
        wc.setAttribute("workingDirWorkspaceRelativeLocation", true);
        wc.setAttribute("dockerConnection", connection.getName());
        return wc.doSave();
    }

    private static String createDockerComposeLaunchConfigurationName(IResource dockerComposeScript) {
        return "Docker Compose [" + dockerComposeScript.getProject().getName() + "]";
    }

    public static void updateLaunchConfigurations(String type, String attributeName, String oldValue, String newValue) {
        ILaunchConfigurationType configType = LaunchConfigurationUtils.getLaunchConfigType(type);
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        try {
            for (ILaunchConfiguration config : manager.getLaunchConfigurations(configType)) {
                try {
                    if (!config.getAttribute(attributeName, "").equals(oldValue)) continue;
                    ILaunchConfigurationWorkingCopy workingCopy = config.getWorkingCopy();
                    workingCopy.setAttribute(attributeName, newValue);
                    workingCopy.doSave();
                }
                catch (CoreException e) {
                    Activator.logErrorMessage(LaunchMessages.getFormattedString("UpdateLaunchConfiguration.named.error", config.getName()), e);
                }
            }
        }
        catch (CoreException e) {
            Activator.logErrorMessage(LaunchMessages.getString("UpdateLaunchConfiguration.error"), e);
            Activator.logErrorMessage("Failed to retrieve launch configurations after connection name changed", e);
        }
    }
}

