/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.profiling.launch.provider.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchConfigurationTabGroup;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ProviderFramework {
    public static ProfileLaunchShortcut getProfilingProvider(String type) {
        ArrayList<IConfigurationElement> configList = ProviderFramework.getOrderedConfigElements(type);
        for (IConfigurationElement config : configList) {
            try {
                Object obj = config.createExecutableExtension("shortcut");
                if (!(obj instanceof ProfileLaunchShortcut)) continue;
                return (ProfileLaunchShortcut)obj;
            }
            catch (CoreException coreException) {
            }
        }
        return null;
    }

    public static ProfileLaunchShortcut getLaunchShortcutProviderFromId(String id) {
        IConfigurationElement[] configs;
        for (IConfigurationElement config : configs = ProviderFramework.getConfigurationElements()) {
            if (!config.getName().equals("provider")) continue;
            String currentId = config.getAttribute("id");
            String shortcut = config.getAttribute("shortcut");
            if (currentId == null || shortcut == null || !currentId.equals(id)) continue;
            try {
                Object obj = config.createExecutableExtension("shortcut");
                if (!(obj instanceof ProfileLaunchShortcut)) continue;
                return (ProfileLaunchShortcut)obj;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public static AbstractCLaunchDelegate getConfigurationDelegateFromId(String id) {
        IConfigurationElement[] configs;
        for (IConfigurationElement config : configs = ProviderFramework.getConfigurationElements()) {
            if (!config.getName().equals("provider")) continue;
            String currentId = config.getAttribute("id");
            String tabgroup = config.getAttribute("delegate");
            if (currentId == null || tabgroup == null || !currentId.equals(id)) continue;
            try {
                Object obj = config.createExecutableExtension("delegate");
                if (!(obj instanceof AbstractCLaunchDelegate)) continue;
                return (AbstractCLaunchDelegate)obj;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getHighestProviderId(String type) {
        ArrayList<IConfigurationElement> list = ProviderFramework.getOrderedConfigElements(type);
        if (list.size() > 0) {
            return list.get(0).getAttribute("id");
        }
        return null;
    }

    public static HashMap<String, String> getProviderNamesForType(String type) {
        IConfigurationElement[] configs;
        HashMap<String, String> ret = new HashMap<String, String>();
        for (IConfigurationElement config : configs = ProviderFramework.getConfigurationElements()) {
            if (!config.getName().equals("provider")) continue;
            String currentId = config.getAttribute("id");
            String currentName = config.getAttribute("name");
            String currentType = config.getAttribute("type");
            if (currentType == null || type == null || !currentType.equals(type) || currentName == null) continue;
            ret.put(currentName, currentId);
        }
        return ret;
    }

    public static SortedMap<String, String> getAllProviderNames() {
        IConfigurationElement[] configs;
        TreeMap<String, String> ret = new TreeMap<String, String>();
        for (IConfigurationElement config : configs = ProviderFramework.getConfigurationElements()) {
            if (!config.getName().equals("provider")) continue;
            String currentId = config.getAttribute("id");
            String currentName = config.getAttribute("name");
            if (currentName == null || currentId == null) continue;
            ret.put(currentName, currentId);
        }
        return ret;
    }

    public static ArrayList<IConfigurationElement> getOrderedConfigElements(String type) {
        IConfigurationElement[] configs = ProviderFramework.getConfigurationElements();
        ArrayList<IConfigurationElement> configList = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement config : configs) {
            String priority;
            String currentType;
            if (!config.getName().equals("provider") || (currentType = config.getAttribute("type")) == null || !currentType.equals(type) || (priority = config.getAttribute("priority")) == null) continue;
            try {
                Integer.parseInt(priority);
                configList.add(config);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Collections.sort(configList, (c1, c2) -> {
            int p2;
            int p1;
            try {
                p1 = Integer.parseInt(c1.getAttribute("priority"));
                if (p1 <= 0) {
                    return 1;
                }
            }
            catch (NumberFormatException e1) {
                return 1;
            }
            try {
                p2 = Integer.parseInt(c2.getAttribute("priority"));
                if (p2 <= 0) {
                    return -1;
                }
            }
            catch (NumberFormatException e2) {
                return -1;
            }
            return p1 < p2 ? -1 : 1;
        });
        return configList;
    }

    private static IConfigurationElement[] getConfigurationElements() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.profiling.launch", "launchProvider");
        return extPoint.getConfigurationElements();
    }

    public static String getProviderToolNameFromId(String id) {
        IConfigurationElement[] configs;
        for (IConfigurationElement config : configs = ProviderFramework.getConfigurationElements()) {
            String currentId;
            if (!config.getName().equals("provider") || (currentId = config.getAttribute("id")) == null || !currentId.equals(id)) continue;
            return config.getAttribute("name");
        }
        return null;
    }

    public static String getToolInformationFromId(String toolId, String attribute) {
        IConfigurationElement[] configs;
        for (IConfigurationElement config : configs = ProviderFramework.getConfigurationElements()) {
            if (!config.getName().equals("provider")) continue;
            String currentId = config.getAttribute("id");
            String currentToolDescription = config.getAttribute(attribute);
            if (currentId == null || currentToolDescription == null || !currentId.equals(toolId)) continue;
            return currentToolDescription;
        }
        return null;
    }

    public static ProfileLaunchConfigurationTabGroup getTabGroupProvider(String type) {
        IConfigurationElement[] configs;
        for (IConfigurationElement config : configs = ProviderFramework.getConfigurationElements()) {
            if (!config.getName().equals("provider")) continue;
            String currentType = config.getAttribute("type");
            String shortcut = config.getAttribute("tabgroup");
            if (currentType == null || shortcut == null || !currentType.equals(type)) continue;
            try {
                Object obj = config.createExecutableExtension("tabgroup");
                if (!(obj instanceof ProfileLaunchConfigurationTabGroup)) continue;
                return (ProfileLaunchConfigurationTabGroup)((Object)obj);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ProfileLaunchConfigurationTabGroup getTabGroupProviderFromId(String id) {
        IConfigurationElement[] configs;
        for (IConfigurationElement config : configs = ProviderFramework.getConfigurationElements()) {
            if (!config.getName().equals("provider")) continue;
            String currentId = config.getAttribute("id");
            String tabgroup = config.getAttribute("tabgroup");
            if (currentId == null || tabgroup == null || !currentId.equals(id)) continue;
            try {
                Object obj = config.createExecutableExtension("tabgroup");
                if (!(obj instanceof ProfileLaunchConfigurationTabGroup)) continue;
                return (ProfileLaunchConfigurationTabGroup)((Object)obj);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String[] getProviderIdsForType(String type) {
        IConfigurationElement[] configs;
        ArrayList<String> ret = new ArrayList<String>();
        for (IConfigurationElement config : configs = ProviderFramework.getConfigurationElements()) {
            if (!config.getName().equals("provider")) continue;
            String currentId = config.getAttribute("id");
            String currentType = config.getAttribute("type");
            if (currentType == null || type == null || !currentType.equals(type)) continue;
            ret.add(currentId);
        }
        return ret.toArray(new String[0]);
    }

    public static String[] getProviderCategories() {
        IConfigurationElement[] configs;
        TreeSet<String> ret = new TreeSet<String>();
        for (IConfigurationElement config : configs = ProviderFramework.getConfigurationElements()) {
            String currentType;
            if (!config.getName().equals("provider") || (currentType = config.getAttribute("type")) == null) continue;
            ret.add(currentType);
        }
        return ret.toArray(new String[0]);
    }

    public static String getProviderIdToRun(ILaunchConfigurationWorkingCopy wc, String type) {
        String providerId = null;
        if (wc != null) {
            try {
                IResource[] resources = wc.getMappedResources();
                if (resources != null) {
                    for (int i = 0; i < resources.length; ++i) {
                        String provider;
                        IProject project;
                        ScopedPreferenceStore store;
                        boolean use_project_settings;
                        IResource resource = resources[i];
                        if (!(resource instanceof IProject) || !(use_project_settings = (store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project = (IProject)resource), "org.eclipse.linuxtools.profiling.launch")).getBoolean("use_project" + type)) || (provider = store.getString("provider" + type)).isEmpty()) continue;
                        providerId = provider;
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (providerId == null && ((providerId = ConfigurationScope.INSTANCE.getNode("org.eclipse.linuxtools.profiling.launch").get("provider" + type, "")).isEmpty() || ProviderFramework.getConfigurationDelegateFromId(providerId) == null)) {
            providerId = ProviderFramework.getHighestProviderId(type);
        }
        return providerId;
    }
}

