/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.IModuleSourceInfo;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.util.LineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;

public class UnitManager {
    private final CompiledUnit fMainUnit;
    private Map<URI, UnitEntry> fUri2UnitMap;

    UnitManager(CompiledUnit mainUnit) {
        if (mainUnit == null) {
            throw new IllegalArgumentException("null main unit");
        }
        this.fMainUnit = mainUnit;
        try {
            this.fUri2UnitMap = this.createURI2UnitMap(mainUnit);
        }
        catch (IOException e) {
            this.fUri2UnitMap = Collections.emptyMap();
            QVTODebugCore.log(e);
        }
    }

    public CompiledUnit getMainUnit() {
        return this.fMainUnit;
    }

    public CompiledUnit getCompiledModule(URI unitURI) {
        UnitEntry numberProvider = this.fUri2UnitMap.get(unitURI);
        if (numberProvider != null) {
            return numberProvider.getCompiledModule();
        }
        return null;
    }

    public LineNumberProvider getLineNumberProvider(URI unitURI) {
        return this.fUri2UnitMap.get(unitURI);
    }

    public CompiledUnit findUnitForModule(Module module) {
        return this.findCompiledModuleRec(this.fMainUnit, module);
    }

    private CompiledUnit findCompiledModuleRec(CompiledUnit rootModule, Module module) {
        if (rootModule.getModules().contains(module)) {
            return rootModule;
        }
        for (CompiledUnit impModule : rootModule.getCompiledImports()) {
            CompiledUnit findModule = this.findCompiledModuleRec(impModule, module);
            if (findModule == null) continue;
            return findModule;
        }
        return null;
    }

    private Map<URI, UnitEntry> createURI2UnitMap(CompiledUnit mainUnit) throws IOException {
        HashSet<CompiledUnit> allUnits = new HashSet<CompiledUnit>();
        allUnits.add(mainUnit);
        QvtOperationalParserUtil.collectAllImports((CompiledUnit)mainUnit, allUnits);
        HashMap<URI, UnitEntry> file2Unit = new HashMap<URI, UnitEntry>();
        for (CompiledUnit nextUnit : allUnits) {
            IModuleSourceInfo sourceBinding = ASTBindingHelper.getModuleSourceBinding((Module)((Module)nextUnit.getModules().get(0)));
            if (sourceBinding == null) continue;
            UnitEntry entry = new UnitEntry(nextUnit, sourceBinding.getLineNumberProvider());
            file2Unit.put(nextUnit.getURI(), entry);
        }
        return file2Unit;
    }

    private static class UnitEntry
    implements LineNumberProvider {
        private final CompiledUnit fModule;
        private LineNumberProvider fProvider;

        public UnitEntry(CompiledUnit unit, LineNumberProvider lineNumberProvider) {
            this.fModule = unit;
            this.fProvider = lineNumberProvider;
        }

        public CompiledUnit getCompiledModule() {
            return this.fModule;
        }

        public int getLineEnd(int lineNumber) {
            return this.fProvider.getLineEnd(lineNumber);
        }

        public int getLineCount() {
            return this.fProvider.getLineCount();
        }

        public int getLineNumber(int offset) {
            return this.fProvider.getLineNumber(offset);
        }
    }
}

