/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.acquire;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.query.registry.AnnotatedObjectDescriptor;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.snapshot.acquire.VmInfo;
import org.eclipse.mat.util.MessageUtil;

public class VmInfoDescriptor
extends AnnotatedObjectDescriptor {
    protected final VmInfo vmInfo;

    public VmInfoDescriptor(String identifier, String name, String usage, String help, String helpUrl, Locale helpLocale, VmInfo vmInfo) {
        super(identifier, name, usage, null, help, helpUrl, helpLocale);
        this.vmInfo = vmInfo;
    }

    public VmInfo getVmInfo() {
        return this.vmInfo;
    }

    public static final VmInfoDescriptor createDescriptor(VmInfo vmInfo) throws SnapshotException {
        Class<?> vmInfoClass = vmInfo.getClass();
        ResourceBundle i18n = VmInfoDescriptor.getBundle(vmInfoClass);
        Locale helpLoc = i18n.getLocale();
        Name n = vmInfoClass.getAnnotation(Name.class);
        String name = VmInfoDescriptor.translate(i18n, String.valueOf(vmInfoClass.getSimpleName()) + ".name", n != null ? n.value() : vmInfoClass.getSimpleName());
        Help h = vmInfoClass.getAnnotation(Help.class);
        String help = VmInfoDescriptor.translate(i18n, String.valueOf(vmInfoClass.getSimpleName()) + ".help", h != null ? h.value() : null);
        HelpUrl hu = vmInfoClass.getAnnotation(HelpUrl.class);
        String helpUrl = hu != null ? hu.value() : null;
        VmInfoDescriptor descriptor = new VmInfoDescriptor(vmInfoClass.getSimpleName(), name, null, help, helpUrl, helpLoc, vmInfo);
        Class<?> clazz = vmInfo.getClass();
        while (!clazz.equals(Object.class)) {
            VmInfoDescriptor.addArguments(vmInfo, clazz, descriptor, i18n);
            clazz = clazz.getSuperclass();
        }
        return descriptor;
    }

    private static ResourceBundle getBundle(Class<? extends VmInfo> providerClass) {
        try {
            return ResourceBundle.getBundle(String.valueOf(providerClass.getPackage().getName()) + ".annotations", Locale.getDefault(), providerClass.getClassLoader());
        }
        catch (MissingResourceException e) {
            return new ResourceBundle(){

                @Override
                protected Object handleGetObject(String key) {
                    return null;
                }

                @Override
                public Enumeration<String> getKeys() {
                    return null;
                }

                @Override
                public Locale getLocale() {
                    return Locale.getDefault();
                }
            };
        }
    }

    private static void addArguments(VmInfo provider, Class<?> clazz, VmInfoDescriptor descriptor, ResourceBundle i18n) throws SnapshotException {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                Argument argument = field.getAnnotation(Argument.class);
                if (argument != null) {
                    ArgumentDescriptor argDescriptor = VmInfoDescriptor.fromAnnotation(clazz, argument, field, field.get(provider));
                    Help h = field.getAnnotation(Help.class);
                    String help = VmInfoDescriptor.translate(i18n, String.valueOf(clazz.getSimpleName()) + "." + argDescriptor.getName() + ".help", h != null ? h.value() : null);
                    if (help != null) {
                        argDescriptor.setHelp(help);
                    }
                    descriptor.addParameter(argDescriptor);
                }
            }
            catch (SnapshotException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                String msg = Messages.VmInfoDescriptor_UnableToAccessArgumentErrorMsg;
                throw new SnapshotException(MessageUtil.format((String)msg, (Object[])new Object[]{field.getName(), clazz.getName()}), (Throwable)e);
            }
            catch (Exception e) {
                throw new SnapshotException(MessageUtil.format((String)Messages.VmInfoDescriptor_ErrorGettingArgumentErrorMsg, (Object[])new Object[]{field.getName(), clazz.getName()}), (Throwable)e);
            }
            ++n2;
        }
    }

    private static ArgumentDescriptor fromAnnotation(Class<?> clazz, Argument annotation, Field field, Object defaultValue) throws SnapshotException {
        ArgumentDescriptor d = new ArgumentDescriptor();
        d.setMandatory(annotation.isMandatory());
        d.setName(field.getName());
        String flag = annotation.flag();
        if (flag.equals("none")) {
            flag = null;
        } else if (flag.length() == 0) {
            flag = field.getName().toLowerCase(Locale.ENGLISH);
        }
        d.setFlag(flag);
        d.setField(field);
        d.setArray(field.getType().isArray());
        d.setList(List.class.isAssignableFrom(field.getType()));
        if (d.isArray()) {
            d.setType(field.getType().getComponentType());
        } else if (d.isList()) {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
                d.setType((Class)typeArguments[0]);
            }
        } else {
            d.setType(field.getType());
        }
        Argument.Advice advice = annotation.advice();
        if (advice == Argument.Advice.CLASS_NAME_PATTERN && !Pattern.class.isAssignableFrom(d.getType())) {
            String msg = MessageUtil.format((String)Messages.VmInfoDescriptor_WrongTypeErrorMsg, (Object[])new Object[]{field.getName(), clazz.getName(), Argument.Advice.CLASS_NAME_PATTERN, Pattern.class.getName()});
            throw new SnapshotException(msg);
        }
        if (advice != Argument.Advice.NONE) {
            d.setAdvice(advice);
        }
        if (d.isArray() && defaultValue != null) {
            int size = Array.getLength(defaultValue);
            ArrayList<Object> l = new ArrayList<Object>(size);
            int ii = 0;
            while (ii < size) {
                l.add(Array.get(defaultValue, ii));
                ++ii;
            }
            d.setDefaultValue(Collections.unmodifiableList(l));
        } else {
            d.setDefaultValue(defaultValue);
        }
        return d;
    }

    private static String translate(ResourceBundle i18n, String key, String defaultValue) {
        try {
            return i18n.getString(key);
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }
}

