/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core.service;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.xmlrpc.XmlRpcException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.bugzilla.core.BugHistory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttachmentMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaFlagMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.core.service.BugzillaXmlRpcOperation;
import org.eclipse.mylyn.internal.bugzilla.core.service.XmlRpcClassCastException;
import org.eclipse.mylyn.internal.commons.xmlrpc.CommonXmlRpcClient;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;

public class BugzillaXmlRpcClient
extends CommonXmlRpcClient {
    public static final String XML_BUGZILLA_VERSION = "Bugzilla.version";
    public static final String XML_BUGZILLA_TIME = "Bugzilla.time";
    public static final String XML_USER_LOGIN = "User.login";
    public static final String XML_USER_LOGOUT = "User.logout";
    public static final String XML_USER_GET = "User.get";
    public static final String XML_BUG_ATTACHMENTS = "Bug.attachments";
    public static final String XML_BUG_FIELDS = "Bug.fields";
    public static final String XML_BUG_GET = "Bug.get";
    public static final String XML_BUG_COMMENTS = "Bug.comments";
    public static final String XML_BUG_HISTORY = "Bug.history";
    public static final String XML_PRODUCT_GET_SELECTABLE = "Product.get_selectable_products";
    public static final String XML_PRODUCT_GET_ENTERABLE = "Product.get_enterable_products";
    public static final String XML_PRODUCT_GET_ACCESSIBLE = "Product.get_accessible_products";
    public static final String XML_PRODUCT_GET = "Product.get";
    public static final String XML_PARAMETER_LOGIN = "login";
    public static final String XML_PARAMETER_PASSWORD = "password";
    public static final String XML_PARAMETER_REMEMBER = "remember";
    public static final String XML_PARAMETER_IDS = "ids";
    public static final String XML_PARAMETER_NAMES = "names";
    public static final String XML_PARAMETER_MATCH = "match";
    public static final String XML_PARAMETER_EXCLUDE_FIELDS = "exclude_fields";
    public static final String XML_PARAMETER_TOKEN = "Bugzilla_token";
    public static final String XML_RESPONSE_DB_TIME = "db_time";
    public static final String XML_RESPONSE_WEB_TIME = "web_time";
    public static final String[] XML_BUGZILLA_TIME_RESPONSE_TO_REMOVE = new String[]{"tz_offset", "tz_short_name", "web_time_utc", "tz_name"};
    public static final String XML_RESPONSE_VERSION = "version";
    public static final String XML_RESPONSE_USERS = "users";
    public static final String XML_RESPONSE_ID = "id";
    public static final String XML_RESPONSE_IDS = "ids";
    public static final String XML_RESPONSE_FIELDS = "fields";
    public static final String XML_RESPONSE_PRODUCTS = "products";
    public static final String XML_RESPONSE_BUGS = "bugs";
    public static final String XML_RESPONSE_TOKEN = "token";
    private int userID = -1;
    private String token;
    private final BugzillaClient bugzillaClient;

    public BugzillaXmlRpcClient(AbstractWebLocation location, HttpClient client, BugzillaClient bugzillaClient) {
        super(location, client);
        this.bugzillaClient = bugzillaClient;
    }

    public BugzillaXmlRpcClient(AbstractWebLocation location, BugzillaClient bugzillaClient) {
        super(location);
        this.bugzillaClient = bugzillaClient;
    }

    public String getVersion(final IProgressMonitor monitor) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<String>(this){

            public String execute() throws XmlRpcException {
                String result = "";
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_BUGZILLA_VERSION, null);
                result = BugzillaXmlRpcClient.this.response2String(response, BugzillaXmlRpcClient.XML_RESPONSE_VERSION);
                return result;
            }
        }.execute();
    }

    public Date getDBTime(final IProgressMonitor monitor) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Date>(this){

            public Date execute() throws XmlRpcException {
                Date result = null;
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_BUGZILLA_TIME, null);
                result = BugzillaXmlRpcClient.this.response2Date(response, BugzillaXmlRpcClient.XML_RESPONSE_DB_TIME);
                return result;
            }
        }.execute();
    }

    public Date getWebTime(final IProgressMonitor monitor) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Date>(this){

            public Date execute() throws XmlRpcException {
                Date result = null;
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_BUGZILLA_TIME, null);
                result = BugzillaXmlRpcClient.this.response2Date(response, BugzillaXmlRpcClient.XML_RESPONSE_WEB_TIME);
                return result;
            }
        }.execute();
    }

    public HashMap<?, ?> getTime(final IProgressMonitor monitor) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<HashMap<?, ?>>(this){

            public HashMap<?, ?> execute() throws XmlRpcException {
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_BUGZILLA_TIME, null);
                if (response != null) {
                    String[] stringArray = XML_BUGZILLA_TIME_RESPONSE_TO_REMOVE;
                    int n = XML_BUGZILLA_TIME_RESPONSE_TO_REMOVE.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String exclude = stringArray[n2];
                        response.remove(exclude);
                        ++n2;
                    }
                }
                return response;
            }
        }.execute();
    }

    public int login(final IProgressMonitor monitor) throws XmlRpcException {
        this.userID = -1;
        final AuthenticationCredentials credentials = this.getLocation().getCredentials(AuthenticationType.REPOSITORY);
        if (credentials != null) {
            String user = credentials.getUserName();
            String password = credentials.getPassword();
            if ("".equals(user) || "".equals(password)) {
                return this.userID;
            }
            this.userID = new BugzillaXmlRpcOperation<Integer>(this){

                public Integer execute() throws XmlRpcException {
                    HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_USER_LOGIN, new Object[]{new HashMap<String, Object>(credentials){
                        {
                            this.put(BugzillaXmlRpcClient.XML_PARAMETER_LOGIN, authenticationCredentials.getUserName());
                            this.put(BugzillaXmlRpcClient.XML_PARAMETER_PASSWORD, authenticationCredentials.getPassword());
                            this.put(BugzillaXmlRpcClient.XML_PARAMETER_REMEMBER, true);
                        }
                    }});
                    if (response != null) {
                        Integer result = BugzillaXmlRpcClient.this.response2Integer(response, BugzillaXmlRpcClient.XML_RESPONSE_ID);
                        BugzillaXmlRpcClient.this.token = response.get(BugzillaXmlRpcClient.XML_RESPONSE_TOKEN) != null ? BugzillaXmlRpcClient.this.response2String(response, BugzillaXmlRpcClient.XML_RESPONSE_TOKEN) : null;
                        return result;
                    }
                    return null;
                }
            }.execute();
        }
        return this.userID;
    }

    public void logout(final IProgressMonitor monitor) throws XmlRpcException {
        try {
            new BugzillaXmlRpcOperation<Integer>(this){

                public Integer execute() throws XmlRpcException {
                    this.call(monitor, BugzillaXmlRpcClient.XML_USER_LOGOUT, new Object[0]);
                    return -1;
                }
            }.execute();
        }
        finally {
            this.userID = -1;
            this.token = null;
        }
    }

    private Object[] getUserInfoInternal(final IProgressMonitor monitor, final Object[] callParm) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>(this){

            public Object[] execute() throws XmlRpcException {
                Object[] result = null;
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_USER_GET, callParm);
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, BugzillaXmlRpcClient.XML_RESPONSE_USERS);
                return result;
            }
        }.execute();
    }

    public Object[] getUserInfoFromIDs(IProgressMonitor monitor, Integer[] ids) throws XmlRpcException {
        return this.getUserInfoInternal(monitor, new Object[]{new HashMap<String, Object>(ids){
            {
                this.put("ids", integerArray);
                if (BugzillaXmlRpcClient.this.token != null) {
                    this.put(BugzillaXmlRpcClient.XML_PARAMETER_TOKEN, BugzillaXmlRpcClient.this.token);
                }
            }
        }});
    }

    public Object[] getUserInfoFromNames(IProgressMonitor monitor, String[] names) throws XmlRpcException {
        return this.getUserInfoInternal(monitor, new Object[]{new HashMap<String, Object>(names){
            {
                this.put(BugzillaXmlRpcClient.XML_PARAMETER_NAMES, stringArray);
                if (BugzillaXmlRpcClient.this.token != null) {
                    this.put(BugzillaXmlRpcClient.XML_PARAMETER_TOKEN, BugzillaXmlRpcClient.this.token);
                }
            }
        }});
    }

    public Object[] getUserInfoWithMatch(IProgressMonitor monitor, String[] matchs) throws XmlRpcException {
        HashMap<String, String[]> parmArray = new HashMap<String, String[]>();
        Object[] callParm = new Object[]{parmArray};
        parmArray.put(XML_PARAMETER_MATCH, matchs);
        return this.getUserInfoInternal(monitor, callParm);
    }

    private Object[] getFieldsInternal(final IProgressMonitor monitor, final Object[] callParm) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>(this){

            public Object[] execute() throws XmlRpcException {
                Object[] result = null;
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_BUG_FIELDS, callParm);
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, BugzillaXmlRpcClient.XML_RESPONSE_FIELDS);
                return result;
            }
        }.execute();
    }

    public Object[] getAllFields(IProgressMonitor monitor) throws XmlRpcException {
        return this.getFieldsInternal(monitor, null);
    }

    public Object[] getFieldsWithNames(IProgressMonitor monitor, String[] names) throws XmlRpcException {
        return this.getFieldsInternal(monitor, new Object[]{new HashMap<String, Object>(names){
            {
                this.put(BugzillaXmlRpcClient.XML_PARAMETER_NAMES, stringArray);
                if (BugzillaXmlRpcClient.this.token != null) {
                    this.put(BugzillaXmlRpcClient.XML_PARAMETER_TOKEN, BugzillaXmlRpcClient.this.token);
                }
            }
        }});
    }

    public Object[] getFieldsWithIDs(IProgressMonitor monitor, Integer[] ids) throws XmlRpcException {
        return this.getFieldsInternal(monitor, new Object[]{new HashMap<String, Object>(ids){
            {
                this.put("ids", integerArray);
                if (BugzillaXmlRpcClient.this.token != null) {
                    this.put(BugzillaXmlRpcClient.XML_PARAMETER_TOKEN, BugzillaXmlRpcClient.this.token);
                }
            }
        }});
    }

    public Object[] getSelectableProducts(final IProgressMonitor monitor) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>(this){

            public Object[] execute() throws XmlRpcException {
                Object[] objectArray;
                Object[] result = null;
                if (BugzillaXmlRpcClient.this.token == null) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = Collections.singletonMap(BugzillaXmlRpcClient.XML_PARAMETER_TOKEN, BugzillaXmlRpcClient.this.token);
                }
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_PRODUCT_GET_SELECTABLE, objectArray);
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, "ids");
                return result;
            }
        }.execute();
    }

    public Object[] getEnterableProducts(final IProgressMonitor monitor) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>(this){

            public Object[] execute() throws XmlRpcException {
                Object[] objectArray;
                Object[] result = null;
                if (BugzillaXmlRpcClient.this.token == null) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = Collections.singletonMap(BugzillaXmlRpcClient.XML_PARAMETER_TOKEN, BugzillaXmlRpcClient.this.token);
                }
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_PRODUCT_GET_ENTERABLE, objectArray);
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, "ids");
                return result;
            }
        }.execute();
    }

    public Object[] getAccessibleProducts(final IProgressMonitor monitor) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>(this){

            public Object[] execute() throws XmlRpcException {
                Object[] objectArray;
                Object[] result = null;
                if (BugzillaXmlRpcClient.this.token == null) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = Collections.singletonMap(BugzillaXmlRpcClient.XML_PARAMETER_TOKEN, BugzillaXmlRpcClient.this.token);
                }
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_PRODUCT_GET_ACCESSIBLE, objectArray);
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, "ids");
                return result;
            }
        }.execute();
    }

    public Object[] getProducts(final IProgressMonitor monitor, final Object[] ids) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>(this){

            public Object[] execute() throws XmlRpcException {
                Object[] result = null;
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_PRODUCT_GET, new Object[]{new HashMap<String, Object>(ids){
                    {
                        this.put("ids", objectArray);
                        if ((this).BugzillaXmlRpcClient.this.token != null) {
                            this.put(BugzillaXmlRpcClient.XML_PARAMETER_TOKEN, (this).BugzillaXmlRpcClient.this.token);
                        }
                    }
                }});
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, BugzillaXmlRpcClient.XML_RESPONSE_PRODUCTS);
                return result;
            }
        }.execute();
    }

    private Object[] response2ObjectArray(HashMap<?, ?> response, String name) throws XmlRpcException {
        Object[] result;
        if (response == null) {
            return null;
        }
        try {
            result = (Object[])response.get(name);
        }
        catch (ClassCastException e) {
            Object result2 = null;
            throw new XmlRpcClassCastException(e);
        }
        return result;
    }

    private Integer response2Integer(HashMap<?, ?> response, String name) throws XmlRpcException {
        Integer result;
        if (response == null) {
            return null;
        }
        try {
            result = (Integer)response.get(name);
        }
        catch (ClassCastException e) {
            Object result2 = null;
            throw new XmlRpcClassCastException(e);
        }
        return result;
    }

    private String response2String(HashMap<?, ?> response, String name) throws XmlRpcException {
        String result;
        if (response == null) {
            return null;
        }
        try {
            result = (String)response.get(name);
        }
        catch (ClassCastException e) {
            Object result2 = null;
            throw new XmlRpcClassCastException(e);
        }
        return result;
    }

    private Date response2Date(HashMap<?, ?> response, String name) throws XmlRpcException {
        Date result;
        if (response == null) {
            return null;
        }
        try {
            result = (Date)response.get(name);
        }
        catch (ClassCastException e) {
            Object result2 = null;
            throw new XmlRpcClassCastException(e);
        }
        return result;
    }

    public void updateConfiguration(IProgressMonitor monitor, RepositoryConfiguration repositoryConfiguration, String fileName) throws CoreException {
        repositoryConfiguration.setValidTransitions(monitor, fileName, this);
        if (!repositoryConfiguration.getOptionValues(BugzillaAttribute.PRODUCT).isEmpty()) {
            this.updateProductInfo(monitor, repositoryConfiguration);
        }
    }

    public void updateProductInfo(IProgressMonitor monitor, RepositoryConfiguration repositoryConfiguration) throws CoreException {
        try {
            Object[] products;
            Object[] productIDs = this.getAccessibleProducts(monitor);
            Object[] objectArray = products = this.getProducts(monitor, productIDs);
            int n = products.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof HashMap) {
                    String defaultMilestone = null;
                    String product = (String)((HashMap)object).get("name");
                    HashMap values = (HashMap)((HashMap)object).get("internals");
                    Object defaultMilestoneObj = null;
                    if (values != null) {
                        if (values instanceof HashMap) {
                            defaultMilestoneObj = values.get("defaultmilestone");
                        }
                    } else {
                        defaultMilestoneObj = ((HashMap)object).get("default_milestone");
                    }
                    if (defaultMilestoneObj != null) {
                        if (defaultMilestoneObj instanceof String) {
                            defaultMilestone = defaultMilestoneObj;
                        } else if (defaultMilestoneObj instanceof Double) {
                            defaultMilestone = ((Double)defaultMilestoneObj).toString();
                        } else if (defaultMilestoneObj instanceof Integer) {
                            defaultMilestone = ((Integer)defaultMilestoneObj).toString();
                        }
                    }
                    if (product != null && !product.equals("") && defaultMilestone != null && !defaultMilestone.equals("")) {
                        repositoryConfiguration.setDefaultMilestone(product, defaultMilestone);
                    }
                }
                ++n2;
            }
        }
        catch (XmlRpcException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Can not get the Default Milestones using XMLRPC"));
        }
    }

    public int getUserID() {
        return this.userID;
    }

    public List<BugHistory> getHistory(final Integer[] ids, final IProgressMonitor monitor) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<List<BugHistory>>(this){

            public List<BugHistory> execute() throws XmlRpcException {
                HashMap<String, Integer[]> params = new HashMap<String, Integer[]>();
                params.put("ids", ids);
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_BUG_HISTORY, new Object[]{params});
                if (response != null) {
                    ArrayList<BugHistory> result = new ArrayList<BugHistory>(ids.length);
                    Object[] objectArray = (Object[])response.get(BugzillaXmlRpcClient.XML_RESPONSE_BUGS);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object[] historyItems;
                        Object item = objectArray[n2];
                        Map map = (Map)item;
                        Integer id = (Integer)map.get(BugzillaXmlRpcClient.XML_RESPONSE_ID);
                        BugHistory history = new BugHistory(id);
                        Object[] objectArray2 = historyItems = (Object[])map.get("history");
                        int n3 = historyItems.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object historyItem = objectArray2[n4];
                            Map historyItemMap = (Map)historyItem;
                            BugHistory.Revision revision = history.createRevision((Date)historyItemMap.get("when"), (String)historyItemMap.get("who"));
                            Object[] changeItems = (Object[])historyItemMap.get("changes");
                            if (changeItems != null) {
                                Object[] objectArray3 = changeItems;
                                int n5 = changeItems.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    Object changeItem = objectArray3[n6];
                                    Map changeItemMap = (Map)changeItem;
                                    Object attachmentID = changeItemMap.get("attachment_id");
                                    int attachmentId = -1;
                                    if (attachmentID instanceof Integer) {
                                        attachmentId = (Integer)attachmentID;
                                    } else if (attachmentID instanceof String) {
                                        Integer.parseInt((String)attachmentID);
                                    }
                                    revision.addChange((String)changeItemMap.get("field_name"), (String)changeItemMap.get("added"), (String)changeItemMap.get("removed"), attachmentId);
                                    ++n6;
                                }
                            }
                            ++n4;
                        }
                        result.add(history);
                        ++n2;
                    }
                    return result;
                }
                return null;
            }
        }.execute();
    }

    private HashMap<String, HashMap<String, Object[]>> response2HashMapHashMap(HashMap<?, ?> response, String name) throws XmlRpcException {
        HashMap result;
        if (response == null) {
            return null;
        }
        try {
            result = (HashMap)response.get(name);
        }
        catch (ClassCastException e) {
            Object result2 = null;
            throw new XmlRpcClassCastException(e);
        }
        return result;
    }

    private HashMap<String, Object[]> response2HashMap(HashMap<?, ?> response, String name) throws XmlRpcException {
        HashMap result;
        if (response == null) {
            return null;
        }
        try {
            result = (HashMap)response.get(name);
        }
        catch (ClassCastException e) {
            Object result2 = null;
            throw new XmlRpcClassCastException(e);
        }
        return result;
    }

    protected String getConnectorKind() {
        return "bugzilla";
    }

    public Object[] getBugs(final IProgressMonitor monitor, final Object[] ids) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<Object[]>(this){

            public Object[] execute() throws XmlRpcException {
                Object[] result = null;
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_BUG_GET, new Object[]{new HashMap<String, Object[]>(ids){
                    {
                        this.put("ids", objectArray);
                    }
                }});
                result = BugzillaXmlRpcClient.this.response2ObjectArray(response, BugzillaXmlRpcClient.XML_RESPONSE_BUGS);
                return result;
            }
        }.execute();
    }

    public HashMap<String, HashMap<String, Object[]>> getCommentsInternal(final IProgressMonitor monitor, final Object[] ids) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<HashMap<String, HashMap<String, Object[]>>>(this){

            public HashMap<String, HashMap<String, Object[]>> execute() throws XmlRpcException {
                HashMap<String, HashMap<String, Object[]>> result = null;
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_BUG_COMMENTS, new Object[]{new HashMap<String, Object[]>(ids){
                    {
                        this.put("ids", objectArray);
                    }
                }});
                result = BugzillaXmlRpcClient.this.response2HashMapHashMap(response, BugzillaXmlRpcClient.XML_RESPONSE_BUGS);
                return result;
            }
        }.execute();
    }

    public HashMap<String, Object[]> getAttachmentsInternal(final IProgressMonitor monitor, final Object[] ids) throws XmlRpcException {
        return new BugzillaXmlRpcOperation<HashMap<String, Object[]>>(this){

            public HashMap<String, Object[]> execute() throws XmlRpcException {
                HashMap<String, Object[]> result = null;
                HashMap response = (HashMap)this.call(monitor, BugzillaXmlRpcClient.XML_BUG_ATTACHMENTS, new Object[]{new HashMap<String, Object[]>(ids){
                    {
                        this.put("ids", objectArray);
                        this.put(BugzillaXmlRpcClient.XML_PARAMETER_EXCLUDE_FIELDS, new String[]{"data"});
                    }
                }});
                result = BugzillaXmlRpcClient.this.response2HashMap(response, BugzillaXmlRpcClient.XML_RESPONSE_BUGS);
                return result;
            }
        }.execute();
    }

    private String getMappedBugzillaAttribute(String xmlrpcName) {
        if (xmlrpcName != null) {
            if (xmlrpcName.equals("target_milestone") || xmlrpcName.equals("see_also") || xmlrpcName.equals("resolution") || xmlrpcName.equals(XML_RESPONSE_VERSION) || xmlrpcName.equals("op_sys") || xmlrpcName.equals("component") || xmlrpcName.equals("priority") || xmlrpcName.equals("qa_contact") || xmlrpcName.equals("keywords") || xmlrpcName.equals("product") || xmlrpcName.equals("assigned_to") || xmlrpcName.equals("classification") || xmlrpcName.equals("cc") || xmlrpcName.equals("remaining_time") || xmlrpcName.equals("estimated_time") || xmlrpcName.equals("deadline") || xmlrpcName.equals("alias")) {
                return xmlrpcName;
            }
            if (xmlrpcName.equals("last_change_time")) {
                return "delta_ts";
            }
            if (xmlrpcName.equals("summary")) {
                return "short_desc";
            }
            if (xmlrpcName.equals("is_confirmed")) {
                return "everconfirmed";
            }
            if (xmlrpcName.equals("is_open")) {
                return "status_open";
            }
            if (xmlrpcName.equals("depends_on")) {
                return "dependson";
            }
            if (xmlrpcName.equals("creator")) {
                return "reporter";
            }
            if (xmlrpcName.equals(XML_RESPONSE_ID)) {
                return "bug_id";
            }
            if (xmlrpcName.equals("creation_time")) {
                return "creation_ts";
            }
            if (xmlrpcName.equals("groups")) {
                return "group";
            }
            if (xmlrpcName.equals("platform")) {
                return "rep_platform";
            }
            if (xmlrpcName.equals("is_creator_accessible")) {
                return "reporter_accessible";
            }
            if (xmlrpcName.equals("status")) {
                return "bug_status";
            }
            if (xmlrpcName.equals("is_cc_accessible")) {
                return "cclist_accessible";
            }
            if (xmlrpcName.equals("severity")) {
                return "bug_severity";
            }
            if (xmlrpcName.equals("blocks")) {
                return "blocked";
            }
            if (xmlrpcName.equals("url")) {
                return "bug_file_loc";
            }
            if (xmlrpcName.equals("whiteboard")) {
                return "status_whiteboard";
            }
            if (xmlrpcName.equals("update_token")) {
                return XML_RESPONSE_TOKEN;
            }
            if (xmlrpcName.equals("dupe_of")) {
                return "dup_id";
            }
        }
        return "UNKNOWN";
    }

    public void getTaskData(Set<String> taskIds, TaskDataCollector collector, TaskAttributeMapper mapper, IProgressMonitor monitor) throws IOException, CoreException {
        HashMap<String, TaskData> taskDataMap = new HashMap<String, TaskData>();
        taskIds = new HashSet<String>(taskIds);
        while (taskIds.size() > 0) {
            HashSet<String> idsToRetrieve = new HashSet<String>();
            Iterator<String> itr = taskIds.iterator();
            int x = 0;
            while (itr.hasNext() && x < 50) {
                String taskId;
                String taskIdOrg = taskId = itr.next();
                boolean changed = false;
                while (taskId.startsWith("0")) {
                    taskId = taskId.substring(1);
                    changed = true;
                }
                idsToRetrieve.add(taskId);
                if (changed) {
                    taskIds.remove(taskIdOrg);
                    taskIds.add(taskId);
                }
                ++x;
            }
            Object[] formData = new Integer[idsToRetrieve.size()];
            if (idsToRetrieve.size() == 0) {
                return;
            }
            RepositoryConfiguration repositoryConfiguration = this.bugzillaClient.getRepositoryConfiguration();
            if (repositoryConfiguration == null) {
                repositoryConfiguration = this.bugzillaClient.getRepositoryConfiguration((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1), null);
            }
            ArrayList<BugzillaCustomField> customFields = new ArrayList();
            if (repositoryConfiguration != null) {
                customFields = repositoryConfiguration.getCustomFields();
            }
            itr = idsToRetrieve.iterator();
            int x2 = 0;
            while (itr.hasNext()) {
                String taskId = itr.next();
                formData[x2] = Integer.valueOf(taskId);
                TaskData taskData = new TaskData(mapper, this.getConnectorKind(), this.getLocation().getUrl(), taskId);
                this.bugzillaClient.setupExistingBugAttributes(this.getLocation().getUrl(), taskData);
                taskDataMap.put(taskId, taskData);
                ++x2;
            }
            try {
                if (this.getUserID() == -1) {
                    this.login(monitor);
                }
                Object[] result = this.getBugs(monitor, formData);
                HashMap<String, Object[]> resultAttachments = this.getAttachmentsInternal(monitor, formData);
                HashMap<String, HashMap<String, Object[]>> resultComments = this.getCommentsInternal(monitor, formData);
                Object[] objectArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object resultMap = objectArray[n2];
                    if (resultMap instanceof Map) {
                        Map taskDataResultMap = (Map)resultMap;
                        Integer id = (Integer)taskDataResultMap.get(XML_RESPONSE_ID);
                        TaskData taskData = (TaskData)taskDataMap.get(id.toString());
                        HashMap<String, Object[]> comments = resultComments.get(id.toString());
                        Object[] attachments = resultAttachments.get(id.toString());
                        this.updateTaskDataFromMap(mapper, customFields, taskDataResultMap, taskData);
                        this.addCommentsFromHashToTaskData(mapper, taskData, comments);
                        this.addAttachmentsFromHashToTaskData(mapper, taskData, attachments);
                        this.updateCustomFields(taskData);
                        this.updateAttachmentMetaData(taskData);
                        collector.accept(taskData);
                    }
                    ++n2;
                }
                taskIds.removeAll(idsToRetrieve);
                taskDataMap.clear();
            }
            catch (XmlRpcException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "XmlRpcException: ", (Throwable)e));
            }
        }
    }

    private void updateTaskDataFromMap(TaskAttributeMapper mapper, List<BugzillaCustomField> customFields, Map<?, ?> taskDataResultMap, TaskData taskData) {
        for (String attrib : taskDataResultMap.keySet()) {
            Object value = taskDataResultMap.get(attrib);
            if (attrib.compareTo("flags") == 0) {
                this.addFlags(taskData, value, taskData.getRoot());
            } else if (attrib.startsWith("cf_")) {
                TaskAttribute endAttribute = taskData.getRoot().getAttribute(attrib);
                if (endAttribute == null) {
                    endAttribute = taskData.getRoot().createAttribute(attrib);
                }
                if (value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Date) {
                    endAttribute.addValue(this.getValueStringFromObject(value, false));
                    continue;
                }
                if (!(value instanceof Object[])) continue;
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object1 = objectArray[n2];
                    if (object1 instanceof String || object1 instanceof Boolean || object1 instanceof Integer || object1 instanceof Date) {
                        endAttribute.addValue(this.getValueStringFromObject(object1, true));
                    }
                    ++n2;
                }
                continue;
            }
            BugzillaAttribute tag = BugzillaAttribute.UNKNOWN;
            try {
                String key = this.getMappedBugzillaAttribute(attrib);
                tag = BugzillaAttribute.valueOf(key.toUpperCase(Locale.ENGLISH));
            }
            catch (RuntimeException e) {
                if (e instanceof IllegalArgumentException) continue;
                throw e;
            }
            switch (tag) {
                case UNKNOWN: {
                    break;
                }
                default: {
                    this.createAttrribute(taskData, mapper, value, tag, true);
                }
            }
        }
    }

    private void addFlags(TaskData taskData, Object value, TaskAttribute rootAttribute) {
        if (value instanceof Object[]) {
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object valueTemp = objectArray[n2];
                HashMap flag = (HashMap)valueTemp;
                Integer id = (Integer)flag.get(XML_RESPONSE_ID);
                String name = (String)flag.get("name");
                String status = (String)flag.get("status");
                String setter = (String)flag.get("setter");
                Object requestee = flag.get("requestee");
                TaskAttribute attribute = rootAttribute.createAttribute("task.common.kind.flag" + String.valueOf(id));
                BugzillaFlagMapper flagMapper = new BugzillaFlagMapper(this.bugzillaClient.getConnector());
                flagMapper.setRequestee((String)requestee);
                flagMapper.setSetter(setter);
                flagMapper.setState(status);
                flagMapper.setFlagId(name);
                flagMapper.setNumber(id);
                flagMapper.applyTo(attribute);
                ++n2;
            }
        }
    }

    private void addAttachmentsFromHashToTaskData(TaskAttributeMapper mapper, TaskData taskData, Object[] attachments) {
        if (attachments != null) {
            Object[] objectArray = attachments;
            int n = attachments.length;
            int n2 = 0;
            while (n2 < n) {
                Object attachmentTemp = objectArray[n2];
                HashMap attachment = (HashMap)attachmentTemp;
                Date creation_time = (Date)attachment.get("creation_time");
                Integer id = (Integer)attachment.get(XML_RESPONSE_ID);
                String file_name = (String)attachment.get("file_name");
                String summary = (String)attachment.get("summary");
                String content_type = (String)attachment.get("content_type");
                Integer size = (Integer)attachment.get("size");
                Integer is_obsolete = (Integer)attachment.get("is_obsolete");
                Integer is_patch = (Integer)attachment.get("is_patch");
                String creator = (String)attachment.get("creator");
                Date lastChangeTime = (Date)attachment.get("last_change_time");
                try {
                    SimpleDateFormat x0 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                    SimpleDateFormat x1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZZ");
                    String dateString = x0.format(creation_time);
                    creation_time = x1.parse(dateString + " GMT");
                    dateString = x0.format(lastChangeTime);
                    lastChangeTime = x1.parse(dateString + " GMT");
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                TaskAttribute attachmentAttribute = taskData.getRoot().createAttribute("task.common.attachment-" + String.valueOf(id));
                BugzillaAttachmentMapper attachmentMapper = BugzillaAttachmentMapper.createFrom(attachmentAttribute);
                attachmentMapper.setAttachmentId(id.toString());
                IRepositoryPerson author = taskData.getAttributeMapper().getTaskRepository().createPerson(creator);
                author.setName(creator);
                attachmentMapper.setAuthor(author);
                attachmentMapper.setDeltaDate(lastChangeTime);
                attachmentMapper.setContentType(content_type);
                attachmentMapper.setCreationDate(creation_time);
                attachmentMapper.setDeprecated(is_obsolete.equals(1));
                attachmentMapper.setDescription(summary);
                attachmentMapper.setFileName(file_name);
                attachmentMapper.setLength(size != null ? (long)size.intValue() : -1L);
                attachmentMapper.setPatch(is_patch.equals(1));
                attachmentMapper.applyTo(attachmentAttribute);
                this.addFlags(taskData, attachment.get("flags"), attachmentAttribute);
                ++n2;
            }
        }
    }

    private void addCommentsFromHashToTaskData(TaskAttributeMapper mapper, TaskData taskData, HashMap<String, Object[]> comments) {
        if (comments != null) {
            TaskRepository taskRepository = mapper.getTaskRepository();
            String useParam = taskRepository.getProperty("bugzilla.insider.group");
            boolean useIsPrivate = useParam == null || useParam != null && useParam.equals("true");
            Object[] commentArray = comments.get("comments");
            if (commentArray != null) {
                int commentNum = 0;
                Object[] objectArray = commentArray;
                int n = commentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object2 = objectArray[n2];
                    HashMap commentHash = (HashMap)object2;
                    String text = (String)commentHash.get("text");
                    if (commentNum == 0) {
                        TaskAttribute description = this.createAttrribute(taskData, mapper, text, BugzillaAttribute.LONG_DESC, true);
                        if (useIsPrivate) {
                            Boolean is_private = (Boolean)commentHash.get("is_private");
                            commentID = (Integer)commentHash.get(XML_RESPONSE_ID);
                            TaskAttribute idAttribute = description.createAttribute(XML_RESPONSE_ID);
                            idAttribute.setValue(commentID.toString());
                            if (useIsPrivate) {
                                TaskAttribute isprivateAttribute = description.createAttribute("isprivate");
                                isprivateAttribute.setValue(is_private != false ? "1" : "0");
                            }
                        }
                        ++commentNum;
                    } else {
                        TaskAttribute attribute = taskData.getRoot().createAttribute("task.common.comment-" + commentNum);
                        TaskCommentMapper taskComment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
                        commentID = (Integer)commentHash.get(XML_RESPONSE_ID);
                        Date time = (Date)commentHash.get("time");
                        String creator = (String)commentHash.get("creator");
                        Boolean is_private = (Boolean)commentHash.get("is_private");
                        Integer attachment_id = (Integer)commentHash.get("attachment_id");
                        taskComment.setCommentId(commentID.toString());
                        taskComment.setNumber(Integer.valueOf(commentNum));
                        if (creator != null) {
                            IRepositoryPerson author = taskData.getAttributeMapper().getTaskRepository().createPerson(creator);
                            author.setName(creator);
                            taskComment.setAuthor(author);
                        }
                        taskComment.setIsPrivate(is_private);
                        TaskAttribute attrTimestamp = attribute.createAttribute(BugzillaAttribute.BUG_WHEN.getKey());
                        attrTimestamp.setValue(this.getValueStringFromObject(time, false));
                        try {
                            SimpleDateFormat x0 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                            String dateString = x0.format(time);
                            SimpleDateFormat x1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZZ");
                            Date x2 = x1.parse(dateString + " GMT");
                            taskComment.setCreationDate(x2);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        taskComment.setText(text.trim());
                        taskComment.applyTo(attribute);
                        ++commentNum;
                    }
                    ++n2;
                }
                TaskAttribute numCommentsAttribute = taskData.getRoot().getMappedAttribute(BugzillaAttribute.LONGDESCLENGTH.getKey());
                if (numCommentsAttribute == null) {
                    numCommentsAttribute = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.LONGDESCLENGTH);
                }
                numCommentsAttribute.setValue("" + commentNum);
            }
        }
    }

    private String getValueStringFromObject(Object value, boolean dateWithTimezone) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "1" : "0";
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value instanceof Double) {
            NumberFormat numberInstance = NumberFormat.getInstance(Locale.US);
            numberInstance.setMaximumFractionDigits(2);
            numberInstance.setMinimumFractionDigits(2);
            return numberInstance.format(value);
        }
        if (value instanceof Date) {
            try {
                Date y = (Date)value;
                SimpleDateFormat x0 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                String dateString = x0.format(y);
                SimpleDateFormat x1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZZ");
                Date x2 = x1.parse(dateString + " GMT");
                return dateWithTimezone ? x1.format(x2) : x1.format(x2).substring(0, 10) + " 00:00:00";
            }
            catch (ParseException e) {
                return "";
            }
        }
        return null;
    }

    private TaskAttribute createAttrribute(TaskData taskData, TaskAttributeMapper mapper, Object value, BugzillaAttribute tag, boolean clearValueFirst) {
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute(tag.getKey());
        if (value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Date || value instanceof Double) {
            if (attribute == null) {
                attribute = BugzillaTaskDataHandler.createAttribute(taskData, tag);
                attribute.setValue(this.getValueStringFromObject(value, true));
            } else {
                if (clearValueFirst) {
                    attribute.clearValues();
                }
                attribute.addValue(this.getValueStringFromObject(value, true));
            }
        } else if (value instanceof Object[]) {
            if (attribute == null) {
                attribute = BugzillaTaskDataHandler.createAttribute(taskData, tag);
            } else if (clearValueFirst) {
                attribute.clearValues();
            }
            Object valueList = "";
            if (tag.equals((Object)BugzillaAttribute.DEPENDSON) || tag.equals((Object)BugzillaAttribute.BLOCKED) || tag.equals((Object)BugzillaAttribute.KEYWORDS)) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (((String)valueList).equals("")) {
                        if (object instanceof String || object instanceof Boolean || object instanceof Integer || object instanceof Date) {
                            valueList = this.getValueStringFromObject(object, true);
                        }
                    } else if (object instanceof String || object instanceof Boolean || object instanceof Integer || object instanceof Date) {
                        valueList = (String)valueList + ", " + this.getValueStringFromObject(object, true);
                    }
                    ++n2;
                }
                attribute.setValue((String)valueList);
            } else {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Object object = objectArray[n3];
                    if (object instanceof String || object instanceof Boolean || object instanceof Integer || object instanceof Date) {
                        attribute.addValue(this.getValueStringFromObject(object, true));
                    }
                    ++n3;
                }
            }
        }
        return attribute;
    }

    private void updateCustomFields(TaskData taskData) {
        String repURL = taskData.getRepositoryUrl();
        if (repURL.indexOf("/xmlrpc.cgi") == -1) {
            return;
        }
        RepositoryConfiguration config = this.bugzillaClient.getConnector().getRepositoryConfiguration(repURL.substring(0, repURL.indexOf("/xmlrpc.cgi")));
        if (config != null) {
            for (BugzillaCustomField bugzillaCustomField : config.getCustomFields()) {
                TaskAttribute atr = taskData.getRoot().getAttribute(bugzillaCustomField.getName());
                if (atr == null) {
                    atr = taskData.getRoot().createAttribute(bugzillaCustomField.getName());
                }
                if (atr == null) continue;
                atr.getMetaData().defaults().setLabel(bugzillaCustomField.getDescription());
                atr.getMetaData().setKind("task.common.kind.default");
                switch (bugzillaCustomField.getFieldType()) {
                    case FreeText: {
                        atr.getMetaData().setType("shortText");
                        break;
                    }
                    case DropDown: {
                        atr.getMetaData().setType("singleSelect");
                        break;
                    }
                    case MultipleSelection: {
                        atr.getMetaData().setType("multiSelect");
                        break;
                    }
                    case LargeText: {
                        atr.getMetaData().setType("longText");
                        break;
                    }
                    case DateTime: {
                        atr.getMetaData().setType("dateTime");
                        break;
                    }
                    default: {
                        List<String> options = bugzillaCustomField.getOptions();
                        if (options.size() > 0) {
                            atr.getMetaData().setType("singleSelect");
                            break;
                        }
                        atr.getMetaData().setType("shortText");
                    }
                }
                atr.getMetaData().setReadOnly(false);
            }
        }
    }

    private void updateAttachmentMetaData(TaskData taskData) {
        List taskAttachments = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment");
        String repURL = taskData.getRepositoryUrl();
        if (repURL.indexOf("/xmlrpc.cgi") == -1) {
            return;
        }
        for (TaskAttribute attachment : taskAttachments) {
            BugzillaAttachmentMapper attachmentMapper = BugzillaAttachmentMapper.createFrom(attachment);
            attachmentMapper.setUrl(repURL.substring(0, repURL.indexOf("/xmlrpc.cgi")) + "/attachment.cgi?id=" + attachmentMapper.getAttachmentId());
            attachmentMapper.applyTo(attachment);
        }
    }
}

