/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupEditor;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.eclipse.mylyn.wikitext.ui.commands.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractMarkupResourceHandler
extends AbstractHandler {
    protected MarkupLanguage markupLanguage;
    private IStructuredSelection selection;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection currentSelection = this.selection;
        if (currentSelection == null) {
            try {
                currentSelection = this.computeSelection(event);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = currentSelection;
            for (Object o : structuredSelection) {
                IFile file = null;
                if (o instanceof IAdaptable) {
                    IAdaptable adapt = (IAdaptable)o;
                    file = (IFile)adapt.getAdapter(IFile.class);
                }
                if (file == null) continue;
                String name = file.getName();
                int idxOfDot = name.lastIndexOf(46);
                if (idxOfDot != -1) {
                    name = name.substring(0, idxOfDot);
                }
                MarkupLanguage prev = this.markupLanguage;
                try {
                    if (this.markupLanguage == null) {
                        this.markupLanguage = MarkupEditor.loadMarkupLanguagePreference(file);
                        if (this.markupLanguage == null) {
                            this.markupLanguage = WikiText.getMarkupLanguageForFilename(file.getName());
                        }
                        if (this.markupLanguage == null) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.AbstractMarkupResourceHandler_unexpectedError, (String)NLS.bind((String)Messages.AbstractMarkupResourceHandler_markupLanguageMappingFailed, (Object[])new Object[]{file.getName()}));
                            return null;
                        }
                    }
                    this.handleFile(event, file, name);
                }
                finally {
                    this.markupLanguage = prev;
                }
            }
        }
        return null;
    }

    protected void handleFile(ExecutionEvent event, IFile file, String name) throws ExecutionException {
        this.handleFile(file, name);
    }

    protected ISelection computeSelection(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            selection = HandlerUtil.getActiveMenuEditorInput((ExecutionEvent)event);
        }
        if (!(selection instanceof IStructuredSelection)) {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        }
        if (!(selection instanceof IStructuredSelection)) {
            selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        }
        return selection;
    }

    protected abstract void handleFile(IFile var1, String var2) throws ExecutionException;

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }
}

