/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.provider;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.predicates.provider.PredicateItemProvider;
import org.eclipse.oomph.projectconfig.ExclusionPredicate;
import org.eclipse.oomph.projectconfig.PreferenceProfile;
import org.eclipse.oomph.projectconfig.ProjectConfigPackage;
import org.eclipse.oomph.projectconfig.provider.ProjectConfigEditPlugin;

public class ExclusionPredicateItemProvider
extends PredicateItemProvider {
    public static void filterCircularPreferenceProfiles(EObject root, Collection<?> objects) {
        EObject eObject = root.eContainer();
        while (eObject != null) {
            if (eObject instanceof PreferenceProfile) {
                Iterator<?> it = objects.iterator();
                while (it.hasNext()) {
                    Object value = it.next();
                    if (value instanceof PreferenceProfile) {
                        PreferenceProfile preferenceProfile = (PreferenceProfile)value;
                        if (preferenceProfile != eObject && !ExclusionPredicateItemProvider.getReachablePreferenceProfiles(preferenceProfile).contains(eObject)) continue;
                        it.remove();
                        continue;
                    }
                    it.remove();
                }
            }
            eObject = eObject.eContainer();
        }
    }

    public static Set<PreferenceProfile> getReachablePreferenceProfiles(PreferenceProfile preferenceProfile) {
        HashSet<PreferenceProfile> workingSets = new HashSet<PreferenceProfile>();
        ExclusionPredicateItemProvider.collectReachablePreferenceProfiles(preferenceProfile, workingSets);
        return workingSets;
    }

    private static void collectReachablePreferenceProfiles(PreferenceProfile preferenceProfile, Set<PreferenceProfile> preferenceProfiles) {
        TreeIterator it = preferenceProfile.eAllContents();
        while (it.hasNext()) {
            EObject child = (EObject)it.next();
            for (EObject reference : child.eCrossReferences()) {
                PreferenceProfile referecedPreferenceProfile;
                if (!(reference instanceof PreferenceProfile) || !preferenceProfiles.add(referecedPreferenceProfile = (PreferenceProfile)reference)) continue;
                ExclusionPredicateItemProvider.collectReachablePreferenceProfiles(referecedPreferenceProfile, preferenceProfiles);
            }
        }
    }

    public ExclusionPredicateItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addExcludedPreferenceProfilesPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addExcludedPreferenceProfilesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ExclusionPredicate_excludedPreferenceProfiles_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ExclusionPredicate_excludedPreferenceProfiles_feature", "_UI_ExclusionPredicate_type"), (EStructuralFeature)ProjectConfigPackage.Literals.EXCLUSION_PREDICATE__EXCLUDED_PREFERENCE_PROFILES, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                Collection result = super.getChoiceOfValues(object);
                ExclusionPredicateItemProvider.filterCircularPreferenceProfiles((EObject)object, result);
                return result;
            }
        });
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/ExclusionPredicate"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        ExclusionPredicate exclusionPredicate = (ExclusionPredicate)object;
        StringBuilder result = new StringBuilder();
        for (PreferenceProfile preferenceProfile : exclusionPredicate.getExcludedPreferenceProfiles()) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(preferenceProfile.getName());
        }
        return result.toString();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ExclusionPredicate.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return ProjectConfigEditPlugin.INSTANCE;
    }
}

