/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.base.util.EAnnotations;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.presentation.EnablementDialog;
import org.eclipse.oomph.setup.presentation.Messages;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public final class EnablementAction
extends Action {
    private final Shell shell;
    private final EClass eClass;
    private final String typeText;
    private final EList<SetupTask> enablementTasks;
    private final String defaultImageKey;

    public EnablementAction(Shell shell, EClass eClass, String typeText, EList<SetupTask> enablementTasks) {
        this.shell = shell;
        this.eClass = eClass;
        this.typeText = typeText;
        this.enablementTasks = enablementTasks;
        this.defaultImageKey = SetupPackage.Literals.SETUP_TASK.isSuperTypeOf(eClass) ? "full/obj16/SetupTask" : "full/obj16/EObject";
        this.setText(typeText + "...");
        this.setToolTipText(NLS.bind((String)Messages.EnablementAction_tooltip, (Object)typeText));
        this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor(this.defaultImageKey));
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public void loadImage() {
        URI imageURI = EAnnotations.getImageURI((EClass)this.eClass);
        if (imageURI != null) {
            Image image = ExtendedImageRegistry.INSTANCE.getImage(BaseEditUtil.getImage((URI)imageURI));
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
        }
    }

    public void run() {
        EnablementDialog dialog = new EnablementDialog(this.shell, this.eClass, this.typeText, this.enablementTasks, this.defaultImageKey);
        if (dialog.open() == 0) {
            ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
            SetupContext self = SetupContext.create((ResourceSet)resourceSet);
            Installation installation = self.getInstallation();
            installation.getSetupTasks().addAll(this.enablementTasks);
            SetupWizard.Updater updater = new SetupWizard.Updater(self);
            updater.setTriggerName("ENABLEMENT");
            updater.openDialog(UIUtil.getShell());
        }
    }
}

