/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.AbstractDebuggerConfigurationDialog;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class XDebugConfigurationDialog
extends AbstractDebuggerConfigurationDialog {
    private Text portTextBox;
    private Button showGlobals;
    private Spinner variableDepth;
    private Spinner maxChildren;
    private Spinner maxData;
    private Button useMultiSession;
    private Combo acceptRemoteSession;
    private Button useExtendedProperties;
    private Combo captureStdout;
    private Combo captureStderr;
    private Button useProxy;
    private Text idekeyTextBox;
    private Text proxyTextBox;
    private Image titleImage;
    private XDebugDebuggerConfiguration xdebugDebuggerConfiguration;

    public XDebugConfigurationDialog(XDebugDebuggerConfiguration xdebugDebuggerConfiguration, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.xdebugDebuggerConfiguration = xdebugDebuggerConfiguration;
    }

    private void toggleProxyFields(boolean selection) {
        this.idekeyTextBox.setEnabled(selection);
        this.proxyTextBox.setEnabled(selection);
    }

    private Image getDialogImage() {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.php.debug.ui");
        URL url = null;
        if (bundle != null) {
            url = FileLocator.find((Bundle)bundle, (IPath)new Path("$nl$/icon/full/wizban/xdebug_conf_wiz.png"), null);
            desc = ImageDescriptor.createFromURL((URL)url);
            return desc.createImage();
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        GridData ptGridData = (GridData)parent.getLayoutData();
        ptGridData.widthHint = this.convertWidthInCharsToPixels(120);
        this.getShell().setText(PHPDebugCoreMessages.XDebugConfigurationDialog_Dialog_title);
        this.setTitle(PHPDebugCoreMessages.XDebugConfigurationDialog_mainTitle);
        this.setMessage(PHPDebugCoreMessages.XDebugConfigurationDialog_Dialog_description);
        this.titleImage = this.getDialogImage();
        if (this.titleImage != null) {
            this.setTitleImage(this.titleImage);
        }
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (XDebugConfigurationDialog.this.titleImage != null) {
                    XDebugConfigurationDialog.this.titleImage.dispose();
                }
            }
        });
        Composite[] subsections = this.createSubsections(parent, PHPDebugCoreMessages.XDebugConfigurationDialog_Connection_settings_group, PHPDebugCoreMessages.XDebugConfigurationDialog_General_settings_group);
        Composite connectionSettingsGroup = subsections[0];
        this.addLabelControl(connectionSettingsGroup, PHPDebugCoreMessages.DebuggerConfigurationDialog_debugPort, "org.eclipse.php.debug.core.xdebug_port");
        this.portTextBox = this.addNumTextField(connectionSettingsGroup, "org.eclipse.php.debug.core.xdebug_port", 5, 2, false);
        Group proxyGroup = new Group(connectionSettingsGroup, 32);
        proxyGroup.setText(PHPDebugCoreMessages.XDebugConfigurationDialog_proxyGroup);
        GridData pgGridata = new GridData(4, 4, true, true);
        pgGridata.horizontalSpan = 2;
        proxyGroup.setLayoutData((Object)pgGridata);
        GridLayout pgLayout = new GridLayout();
        pgLayout.numColumns = 2;
        proxyGroup.setLayout((Layout)pgLayout);
        this.useProxy = this.addCheckBox((Composite)proxyGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_useProxy, "org.eclipse.php.debug.core.xdebug_useproxy", 0);
        this.useProxy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XDebugConfigurationDialog.this.toggleProxyFields(XDebugConfigurationDialog.this.useProxy.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                XDebugConfigurationDialog.this.toggleProxyFields(XDebugConfigurationDialog.this.useProxy.getSelection());
            }
        });
        this.addLabelControl((Composite)proxyGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_idekey, "org.eclipse.php.debug.core.xdebug_idekey");
        this.idekeyTextBox = this.addATextField((Composite)proxyGroup, "org.eclipse.php.debug.core.xdebug_idekey", 100, 2);
        this.addLabelControl((Composite)proxyGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_proxy, "org.eclipse.php.debug.core.xdebug_proxy");
        this.proxyTextBox = this.addATextField((Composite)proxyGroup, "org.eclipse.php.debug.core.xdebug_proxy", 100, 2);
        this.createNoteComposite(connectionSettingsGroup.getFont(), connectionSettingsGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_Note_label, PHPDebugCoreMessages.XDebugConfigurationDialog_Note_text, 3);
        Composite generalSettingsGroup = subsections[1];
        this.acceptRemoteSession = this.addComboField(generalSettingsGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSession, XDebugPreferenceMgr.remoteSessionOptions);
        this.useMultiSession = this.addCheckBox(generalSettingsGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_useMultisession, "org.eclipse.php.debug.core.xdebug_multisession", 0);
        this.showGlobals = this.addCheckBox(generalSettingsGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_showSuperGlobals, "org.eclipse.php.debug.core.xdebug_showSuperGlobals", 0);
        this.useExtendedProperties = this.addCheckBox(generalSettingsGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_useExtendedProperties, "org.eclipse.php.debug.core.xdebug_useExtendedProperties", 0);
        this.addLabelControl(generalSettingsGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_maxArrayDepth, "org.eclipse.php.debug.core.xdebug_arrayDepth");
        this.variableDepth = this.addVariableLevel(generalSettingsGroup, "org.eclipse.php.debug.core.xdebug_arrayDepth", 1, 150, 2);
        this.addLabelControl(generalSettingsGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_maxChildren, "org.eclipse.php.debug.core.xdebug_children");
        this.maxChildren = this.addVariableLevel(generalSettingsGroup, "org.eclipse.php.debug.core.xdebug_children", 1, 500, 2);
        this.addLabelControl(generalSettingsGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_MaxData, "org.eclipse.php.debug.core.xdebug_data");
        this.maxData = this.addVariableLevel(generalSettingsGroup, "org.eclipse.php.debug.core.xdebug_data", 1, Integer.MAX_VALUE, 2);
        Group captureGroup = new Group(generalSettingsGroup, 32);
        captureGroup.setText(PHPDebugCoreMessages.XDebugConfigurationDialog_captureGroup);
        GridData cGridData = new GridData(4, 4, true, true);
        cGridData.horizontalSpan = 2;
        captureGroup.setLayoutData((Object)cGridData);
        GridLayout cLayout = new GridLayout();
        cLayout.numColumns = 3;
        captureGroup.setLayout((Layout)cLayout);
        this.captureStdout = this.addComboField((Composite)captureGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_captureStdout, XDebugPreferenceMgr.captureOutputOptions);
        this.captureStderr = this.addComboField((Composite)captureGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_captureStderr, XDebugPreferenceMgr.captureOutputOptions);
        this.internalInitializeValues();
        return parent;
    }

    private Text addNumTextField(Composite parent, String key, int textLimit, int horizontalIndent, boolean isTimeout) {
        Text text = super.addTextField(parent, key, textLimit, horizontalIndent);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XDebugConfigurationDialog.this.validate();
            }
        });
        return text;
    }

    private Text addATextField(Composite parent, String key, int minWidth, int horizontalIndent) {
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        GridData data = new GridData(768);
        data.horizontalIndent = horizontalIndent;
        data.grabExcessHorizontalSpace = true;
        data.minimumWidth = minWidth;
        textBox.setLayoutData((Object)data);
        return textBox;
    }

    private Combo addComboField(Composite parent, String text, String[] options) {
        this.addLabelControl(parent, text, null);
        Combo comboBox = new Combo(parent, 12);
        GridData data = new GridData(768);
        data.horizontalIndent = 10;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        comboBox.setLayoutData((Object)data);
        comboBox.setItems(options);
        return comboBox;
    }

    protected Composite[] createSubsections(Composite parent, String label, String label2) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(4, 4, true, true);
        parent.setLayoutData((Object)data);
        Group group = new Group(parent, 32);
        group.setText(label);
        data = new GridData(4, 4, true, true);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        Group group2 = new Group(parent, 32);
        group2.setText(label2);
        data = new GridData(4, 4, true, true);
        group2.setLayoutData((Object)data);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 3;
        group2.setLayout((Layout)layout2);
        return new Group[]{group, group2};
    }

    protected void okPressed() {
        IEclipsePreferences prefs = PHPDebugPlugin.getInstancePreferences();
        prefs.put("org.eclipse.php.debug.core.xdebug_port", this.portTextBox.getText());
        prefs.putBoolean("org.eclipse.php.debug.core.xdebug_showSuperGlobals", this.showGlobals.getSelection());
        prefs.putBoolean("org.eclipse.php.debug.core.xdebug_useExtendedProperties", this.useExtendedProperties.getSelection());
        prefs.putInt("org.eclipse.php.debug.core.xdebug_arrayDepth", this.variableDepth.getSelection());
        prefs.putInt("org.eclipse.php.debug.core.xdebug_children", this.maxChildren.getSelection());
        prefs.putInt("org.eclipse.php.debug.core.xdebug_data", this.maxData.getSelection());
        prefs.putBoolean("org.eclipse.php.debug.core.xdebug_multisession", this.useMultiSession.getSelection());
        prefs.putInt("org.eclipse.php.debug.core.xdebug_remotesession", this.acceptRemoteSession.getSelectionIndex());
        prefs.putInt("org.eclipse.php.debug.core.xdebug_capturestdout", this.captureStdout.getSelectionIndex());
        prefs.putInt("org.eclipse.php.debug.core.xdebug_capturestderr", this.captureStderr.getSelectionIndex());
        prefs.putBoolean("org.eclipse.php.debug.core.xdebug_useproxy", this.useProxy.getSelection());
        prefs.put("org.eclipse.php.debug.core.xdebug_idekey", this.idekeyTextBox.getText());
        prefs.put("org.eclipse.php.debug.core.xdebug_proxy", this.proxyTextBox.getText());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
        super.okPressed();
    }

    private void internalInitializeValues() {
        IPreferencesService service = Platform.getPreferencesService();
        this.portTextBox.setText(Integer.toString(service.getInt("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_port", 9000, null)));
        this.showGlobals.setSelection(service.getBoolean("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_showSuperGlobals", false, null));
        this.useMultiSession.setSelection(service.getBoolean("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_multisession", false, null));
        this.useExtendedProperties.setSelection(service.getBoolean("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_useExtendedProperties", false, null));
        this.variableDepth.setSelection(service.getInt("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_arrayDepth", 0, null));
        this.maxChildren.setSelection(service.getInt("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_children", 0, null));
        this.maxData.setSelection(service.getInt("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_data", 0, null));
        this.acceptRemoteSession.select(service.getInt("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_remotesession", 0, null));
        this.captureStdout.select(service.getInt("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_capturestdout", 0, null));
        this.captureStderr.select(service.getInt("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_capturestderr", 0, null));
        boolean useProxyState = service.getBoolean("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_useproxy", false, null);
        this.useProxy.setSelection(useProxyState);
        String ideKey = service.getString("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_idekey", "", null);
        if (ideKey == null || ideKey.length() == 0) {
            ideKey = "";
        }
        this.idekeyTextBox.setText(ideKey);
        this.proxyTextBox.setText(service.getString("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.xdebug_proxy", "", null));
        this.toggleProxyFields(useProxyState);
    }

    private Spinner addVariableLevel(Composite parent, String key, int min, int max, int horizontalIndent) {
        Spinner spin = new Spinner(parent, 512);
        spin.setData((Object)key);
        spin.setMinimum(min);
        spin.setMaximum(max);
        GridData data = new GridData(768);
        data.horizontalIndent = horizontalIndent;
        data.horizontalSpan = 2;
        spin.setLayoutData((Object)data);
        spin.setIncrement(1);
        spin.setPageIncrement(3);
        return spin;
    }

    protected void validate() {
        this.setMessage(PHPDebugCoreMessages.XDebugConfigurationDialog_Dialog_description);
        String debugPort = this.portTextBox.getText();
        Integer portNumber = null;
        try {
            portNumber = Integer.valueOf(debugPort);
            int i = portNumber;
            if (i < 1 || i > 65535) {
                this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPortRange, 3);
                return;
            }
        }
        catch (NumberFormatException ex) {
            this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPort, 3);
            return;
        }
        catch (Exception e) {
            this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPort, 3);
            return;
        }
        if (!PHPLaunchUtilities.isPortAvailable(portNumber) && !PHPLaunchUtilities.isDebugDaemonActive(portNumber, "org.eclipse.php.debug.core.xdebugDebugger")) {
            this.setMessage(NLS.bind((String)PHPDebugCoreMessages.DebugConfigurationDialog_PortInUse, (Object)debugPort), 2);
        }
    }
}

