/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class ProcessCrashDetector
implements Runnable,
IConsoleListener {
    private ILaunch launch;
    private Process process;
    private ProcessConsole console;

    public ProcessCrashDetector(ILaunch launch, Process p) {
        this.launch = launch;
        this.process = p;
    }

    @Override
    public void run() {
        try {
            try {
                IProcess p;
                boolean streamerReqd = false;
                try {
                    ILaunchConfiguration config = this.launch.getLaunchConfiguration();
                    if (config.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, "").equals("org.eclipse.php.debug.core.zendDebugger")) {
                        streamerReqd = config.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true) || this.launch.getLaunchMode().equals("debug");
                    }
                }
                catch (CoreException config) {
                    // empty catch block
                }
                if (streamerReqd) {
                    StreamGobbler errorGobbler = new StreamGobbler(this.process.getErrorStream(), true);
                    StreamGobbler inputGobbler = new StreamGobbler(this.process.getInputStream(), false);
                    ConsolePlugin.getDefault().getConsoleManager().addConsoleListener((IConsoleListener)this);
                    errorGobbler.start();
                    inputGobbler.start();
                }
                int exitValue = this.process.waitFor();
                IDebugTarget debugTarget = this.launch.getDebugTarget();
                if (debugTarget != null && (p = debugTarget.getProcess()) instanceof PHPProcess) {
                    ((PHPProcess)p).setExitValue(exitValue);
                }
            }
            catch (Throwable throwable) {
                ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
            }
        }
        finally {
            ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
        }
    }

    public void consolesAdded(IConsole[] consoles) {
        IConsole[] iConsoleArray = consoles;
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console instanceof ProcessConsole) {
                this.console = (ProcessConsole)console;
            }
            ++n2;
        }
    }

    public void consolesRemoved(IConsole[] consoles) {
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        StringBuilder buf;
        boolean isError;
        private IOConsoleOutputStream os;

        StreamGobbler(InputStream is, boolean isError) {
            this.is = is;
            this.buf = new StringBuilder();
            this.isError = isError;
        }

        @Override
        public void run() {
            block16: {
                try {
                    try {
                        String line;
                        InputStreamReader isr = new InputStreamReader(this.is);
                        BufferedReader br = new BufferedReader(isr);
                        while ((line = br.readLine()) != null) {
                            if (!this.isError) continue;
                            if (ProcessCrashDetector.this.console != null) {
                                if (this.os == null) {
                                    this.os = ProcessCrashDetector.this.console.newOutputStream();
                                    if (this.isError) {
                                        Display.getDefault().syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                StreamGobbler.this.os.setColor(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.errorColor"));
                                            }
                                        });
                                    }
                                }
                                this.os.write(this.buf.toString());
                                this.os.write(line + "\n");
                                this.buf.delete(0, this.buf.length());
                                continue;
                            }
                            this.buf.append(line).append('\n');
                        }
                    }
                    catch (IOException iOException) {
                        if (this.os == null) break block16;
                        try {
                            this.os.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                finally {
                    if (this.os != null) {
                        try {
                            this.os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }
}

