/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.stepFilter;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.StepFilterManager;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.internal.debug.core.preferences.stepFilters.DebugStepFilter;
import org.eclipse.php.internal.debug.core.preferences.stepFilters.DebugStepFilterController;
import org.eclipse.php.internal.debug.core.preferences.stepFilters.DebugStepFilterEvent;
import org.eclipse.php.internal.debug.core.preferences.stepFilters.IDebugStepFilterPrefListener;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.preferences.stepFilter.CreateStepFilterDialog;
import org.eclipse.php.internal.debug.ui.preferences.stepFilter.FilterLabelProvider;
import org.eclipse.php.internal.debug.ui.preferences.stepFilter.FilterViewerComparator;
import org.eclipse.php.internal.debug.ui.preferences.stepFilter.IncPathFile;
import org.eclipse.php.internal.debug.ui.preferences.stepFilter.PHPResourceSelectionDialog;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionValidator;

public class PHPDebugStepFilterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREFIX = "org.eclipse.php.debug.core.";
    public static final String PAGE_ID = "org.eclipse.php.debug.ui.PHPStepFilterPreferencePage";
    private ArrayList<IDebugStepFilterPrefListener> debugStepFilterPrefListeners = new ArrayList();
    private CheckboxTableViewer fTableViewer;
    private Button fUseStepFiltersButton;
    private Button fAddResourceButton;
    private Button fRemoveFilterButton;
    private Button fAddFilterButton;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;

    public PHPDebugStepFilterPreferencePage() {
        this.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.setTitle(PHPDebugUIMessages.PHPDebugStepFilterPreferencePage_stepFiltering);
        this.setDescription(PHPDebugUIMessages.PHPDebugStepFilterPreferencePage_stepFiltersAreApplied);
        this.addPreferenceListener((IDebugStepFilterPrefListener)DebugStepFilterController.getInstance());
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.step_filtering_preferences");
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808, (int)0, (int)0);
        this.createStepFilterPreferences(composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private void handleFilterViewerKeyPress(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            this.removeFilters();
        }
    }

    private void createStepFilterPreferences(Composite parent) {
        Composite container = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)1, (int)1808, (int)0, (int)0);
        this.fUseStepFiltersButton = SWTFactory.createCheckButton((Composite)container, (String)PHPDebugUIMessages.PHPDebugStepFilterPreferencePage_useStepFilters, null, (boolean)DebugUITools.isUseStepFilters(), (int)2);
        this.fUseStepFiltersButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PHPDebugStepFilterPreferencePage.this.setPageEnablement(PHPDebugStepFilterPreferencePage.this.fUseStepFiltersButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        SWTFactory.createLabel((Composite)container, (String)PHPDebugUIMessages.PHPDebugStepFilterPreferencePage_definedStepFilters, (int)2);
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)68354);
        this.fTableViewer.getTable().setFont(container.getFont());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fTableViewer.setComparator((ViewerComparator)new FilterViewerComparator());
        this.fTableViewer.setContentProvider((IContentProvider)new StepFilterContentProvider());
        this.fTableViewer.setInput((Object)this.getAllPersistedFilters(false));
        this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((DebugStepFilter)event.getElement()).setEnabled(event.getChecked());
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    PHPDebugStepFilterPreferencePage.this.fRemoveFilterButton.setEnabled(false);
                } else {
                    DebugStepFilter filter = (DebugStepFilter)((StructuredSelection)selection).getFirstElement();
                    if (filter.isReadOnly()) {
                        PHPDebugStepFilterPreferencePage.this.fRemoveFilterButton.setEnabled(false);
                    } else {
                        PHPDebugStepFilterPreferencePage.this.fRemoveFilterButton.setEnabled(true);
                    }
                }
            }
        });
        this.fTableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                PHPDebugStepFilterPreferencePage.this.handleFilterViewerKeyPress(event);
            }
        });
        this.createStepFilterButtons(container);
        this.fUseStepFiltersButton.setSelection(DebugPlugin.isUseStepFilters());
        this.setPageEnablement(this.fUseStepFiltersButton.getSelection());
    }

    private void initTableState(boolean defaults) {
        DebugStepFilter[] filters = this.getAllPersistedFilters(defaults);
        if (filters == null) {
            return;
        }
        int i = 0;
        while (i < filters.length) {
            this.fTableViewer.add((Object)filters[i]);
            this.fTableViewer.setChecked((Object)filters[i], filters[i].isEnabled());
            ++i;
        }
    }

    protected void setPageEnablement(boolean enabled) {
        this.fAddFilterButton.setEnabled(enabled);
        this.fAddResourceButton.setEnabled(enabled);
        this.fDeselectAllButton.setEnabled(enabled);
        this.fSelectAllButton.setEnabled(enabled);
        this.fTableViewer.getTable().setEnabled(enabled);
        this.fRemoveFilterButton.setEnabled(enabled & !this.fTableViewer.getSelection().isEmpty());
    }

    private void createStepFilterButtons(Composite container) {
        this.initializeDialogUnits((Control)container);
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddFilterButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)PHPDebugUIMessages.PHPDebugStepFilterPreferencePage_addFilter, null);
        this.fAddFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PHPDebugStepFilterPreferencePage.this.addFilter();
            }
        });
        this.fAddResourceButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)PHPDebugUIMessages.PHPDebugStepFilterPreferencePage_addResource, null);
        this.fAddResourceButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PHPDebugStepFilterPreferencePage.this.addResource();
            }
        });
        this.fRemoveFilterButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)PHPDebugUIMessages.PHPDebugStepFilterPreferencePage_remove, null);
        this.fRemoveFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PHPDebugStepFilterPreferencePage.this.removeFilters();
            }
        });
        this.fRemoveFilterButton.setEnabled(false);
        Label separator = new Label(buttonContainer, 0);
        separator.setVisible(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.fSelectAllButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)PHPDebugUIMessages.PHPDebugStepFilterPreferencePage_selectAll, null);
        this.fSelectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PHPDebugStepFilterPreferencePage.this.fTableViewer.setAllChecked(true);
            }
        });
        this.fDeselectAllButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)PHPDebugUIMessages.PHPDebugStepFilterPreferencePage_deselectAll, null);
        this.fDeselectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PHPDebugStepFilterPreferencePage.this.fTableViewer.setAllChecked(false);
            }
        });
    }

    private void addFilter() {
        DebugStepFilter newfilter = CreateStepFilterDialog.showCreateStepFilterDialog(this.getShell(), this.getAllFiltersFromTable());
        if (newfilter == null) {
            return;
        }
        this.fTableViewer.add((Object)newfilter);
        this.fTableViewer.setChecked((Object)newfilter, true);
        this.fTableViewer.refresh((Object)newfilter);
    }

    private void addResource() {
        PHPResourceSelectionDialog dialog = new PHPResourceSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, PHPDebugUIMessages.PHPDebugStepFilterPreferencePage_selectResourceToFilter);
        dialog.setValidator(new FilterSelectionValidator(this.getAllFiltersFromTable()));
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length > 0) {
            Object resourceToFilter = result[0];
            String filteredPath = "";
            if (resourceToFilter instanceof IResource) {
                filteredPath = ((IResource)resourceToFilter).getFullPath().toString();
                if (resourceToFilter instanceof IProject) {
                    this.addFilter(filteredPath, true, 9002);
                } else if (resourceToFilter instanceof IFolder) {
                    this.addFilter(filteredPath, true, 9004);
                } else if (resourceToFilter instanceof IFile) {
                    this.addFilter(filteredPath, true, 9003);
                }
            } else if (resourceToFilter instanceof IBuildpathEntry) {
                IBuildpathEntry entry = (IBuildpathEntry)resourceToFilter;
                filteredPath = EnvironmentPathUtils.getLocalPath((IPath)entry.getPath()).toOSString();
                if (entry.getEntryKind() == 4) {
                    this.addFilter(filteredPath, true, 9005);
                } else if (entry.getEntryKind() == 1) {
                    this.addFilter(filteredPath, true, 9008);
                }
            } else if (resourceToFilter instanceof IncPathFile) {
                IBuildpathEntry entry = ((IncPathFile)resourceToFilter).getBuildpathEntry();
                File file = ((IncPathFile)resourceToFilter).file;
                filteredPath = file.getAbsolutePath();
                if (file.isDirectory()) {
                    if (entry.getEntryKind() == 4) {
                        this.addFilter(filteredPath, true, 9007);
                    } else if (entry.getEntryKind() == 1) {
                        this.addFilter(filteredPath, true, 9009);
                    }
                } else if (entry.getEntryKind() == 4) {
                    this.addFilter(filteredPath, true, 9006);
                } else if (entry.getEntryKind() == 1) {
                    this.addFilter(filteredPath, true, 9010);
                }
            }
        }
    }

    protected void removeFilters() {
        this.fTableViewer.remove(((IStructuredSelection)this.fTableViewer.getSelection()).toArray());
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        ArrayList<CallSite> filtersPersistenceList = new ArrayList<CallSite>();
        DebugStepFilter[] filters = this.getAllFiltersFromTable();
        int i = 0;
        while (i < filters.length) {
            filtersPersistenceList.add((CallSite)((Object)(filters[i].getType() + "?" + filters[i].isEnabled() + "?" + filters[i].isReadOnly() + "?" + filters[i].getPath())));
            ++i;
        }
        String pref = this.serializeList(filtersPersistenceList.toArray(new String[filtersPersistenceList.size()]));
        store.setValue("org.eclipse.php.debug.core.pref_step_filters_list", pref);
        DebugPlugin.setUseStepFilters((boolean)this.fUseStepFiltersButton.getSelection());
        this.notifyPrefListeners();
        return super.performOk();
    }

    private void notifyPrefListeners() {
        DebugStepFilterEvent event = new DebugStepFilterEvent(this.getAllFiltersFromTable(), this.fUseStepFiltersButton.getSelection());
        Iterator<IDebugStepFilterPrefListener> iter = this.debugStepFilterPrefListeners.iterator();
        while (iter.hasNext()) {
            iter.next().debugStepFilterModified(event);
        }
    }

    protected void performDefaults() {
        DebugStepFilter[] filters;
        boolean stepenabled = DefaultScope.INSTANCE.getNode(DebugPlugin.getUniqueIdentifier()).getBoolean(StepFilterManager.PREF_USE_STEP_FILTERS, false);
        this.fUseStepFiltersButton.setSelection(stepenabled);
        this.setPageEnablement(stepenabled);
        DebugStepFilter[] debugStepFilterArray = filters = this.getAllFiltersFromTable();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            DebugStepFilter filter = debugStepFilterArray[n2];
            if (!filter.isReadOnly()) {
                this.fTableViewer.remove((Object)filter);
            }
            ++n2;
        }
        super.performDefaults();
    }

    protected void addFilter(String path, boolean checked, int type) {
        if (path != null) {
            DebugStepFilter f = new DebugStepFilter(type, checked, false, path);
            this.fTableViewer.add((Object)f);
            this.fTableViewer.setChecked((Object)f, checked);
        }
    }

    protected DebugStepFilter[] getAllFiltersFromTable() {
        TableItem[] items = this.fTableViewer.getTable().getItems();
        DebugStepFilter[] filters = new DebugStepFilter[items.length];
        int i = 0;
        while (i < items.length) {
            filters[i] = (DebugStepFilter)items[i].getData();
            filters[i].setEnabled(items[i].getChecked());
            ++i;
        }
        return filters;
    }

    protected DebugStepFilter[] getAllPersistedFilters(boolean defaults) {
        DebugStepFilter[] extendedList;
        ArrayList<DebugStepFilter> filtersToAdd = new ArrayList<DebugStepFilter>();
        IPreferenceStore store = this.getPreferenceStore();
        String[] parsedFilters = this.parseList(store.getString("org.eclipse.php.debug.core.pref_step_filters_list"));
        int i = 0;
        while (i < parsedFilters.length) {
            String[] tokens = parsedFilters[i].split("\\?");
            if (tokens.length < 3) {
                return new DebugStepFilter[0];
            }
            DebugStepFilter filter = new DebugStepFilter(Integer.parseInt(tokens[0]), Boolean.parseBoolean(tokens[1]), Boolean.parseBoolean(tokens[2]), tokens[3]);
            filtersToAdd.add(filter);
            ++i;
        }
        DebugStepFilter[] debugStepFilterArray = extendedList = DebugStepFilterController.getInstance().getExtendedFiltersList();
        int n = extendedList.length;
        int n2 = 0;
        while (n2 < n) {
            DebugStepFilter extendedFilter = debugStepFilterArray[n2];
            if (!filtersToAdd.contains(extendedFilter)) {
                filtersToAdd.add(extendedFilter);
            }
            ++n2;
        }
        DebugStepFilter[] result = new DebugStepFilter[filtersToAdd.size()];
        filtersToAdd.toArray(result);
        return result;
    }

    private String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(listString, "<>");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    private String serializeList(String[] list) {
        if (list == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                buffer.append("<>");
            }
            buffer.append(list[i]);
            ++i;
        }
        return buffer.toString();
    }

    public void addPreferenceListener(IDebugStepFilterPrefListener listener) {
        this.debugStepFilterPrefListeners.add(listener);
    }

    public void removePreferenceListener(IDebugStepFilterPrefListener listener) {
        this.debugStepFilterPrefListeners.remove(listener);
    }

    class FilterSelectionValidator
    implements ISelectionValidator {
        private DebugStepFilter[] existingFilters;

        public FilterSelectionValidator(DebugStepFilter[] existingFilters) {
            this.existingFilters = existingFilters;
        }

        public String isValid(Object selection) {
            if (selection != null) {
                Path selectedPath = (Path)selection;
                DebugStepFilter[] debugStepFilterArray = this.existingFilters;
                int n = this.existingFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugStepFilter filter = debugStepFilterArray[n2];
                    if (selectedPath.equals((Object)new Path(filter.getPath()))) {
                        return PHPDebugUIMessages.PHPDebugStepFilterPreferencePage_filterColon + String.valueOf(selectedPath) + PHPDebugUIMessages.PHPDebugStepFilterPreferencePage_alreadyExists;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }

    class StepFilterContentProvider
    implements IStructuredContentProvider {
        public StepFilterContentProvider() {
            PHPDebugStepFilterPreferencePage.this.initTableState(false);
        }

        public Object[] getElements(Object inputElement) {
            return PHPDebugStepFilterPreferencePage.this.getAllFiltersFromTable();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

