/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.StatusUtil;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.StringButtonDialogField;
import org.eclipse.php.internal.ui.wizards.fields.StringDialogField;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.model.PHPUnitSearchEngine;
import org.eclipse.php.phpunit.model.PHPUnitValidator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;

public abstract class PHPUnitWizardPage
extends WizardPage {
    private static final String DEFAULT_EXTENSION = ".php";
    protected boolean fClassNameManual;
    protected String fClassNameProposal;
    protected IStatus fElementToTestStatus;
    protected IStatus fClassNameStatus;
    protected IStatus fContainerStatus;
    protected IStatus fFileNameStatus;
    protected StringButtonDialogField fSuperClassDialogField;
    protected IStatus fSuperClassStatus;
    protected StringDialogField fClassNameDialogField;
    private IContainer fContainer;
    private IScriptProject fScriptProject;
    private PHPUnitSearchEngine fSearchEngine;
    private StringButtonDialogField fContainerDialogField;
    private StringDialogField fFileNameDialogField;
    private boolean fFileNameManual;
    private String fFileNameProposal;
    private boolean fPageVisible = false;
    private IType fSuperClass;
    private Label fSuperClassFileNameLabel;

    public PHPUnitWizardPage(String pageName) {
        super(pageName);
        ContainerFieldAdapter containerAdapter = new ContainerFieldAdapter();
        this.fContainerDialogField = new StringButtonDialogField((IStringButtonAdapter)containerAdapter);
        this.fContainerDialogField.setDialogFieldListener((IDialogFieldListener)containerAdapter);
        this.fContainerDialogField.setLabelText(this.getContainerLabel());
        this.fContainerDialogField.setButtonLabel(PHPUnitMessages.PHPUnitWizardPage_0);
        this.fContainerStatus = new StatusInfo();
        SuperClassFieldAdapter superClassAdapter = new SuperClassFieldAdapter();
        this.fSuperClassDialogField = new StringButtonDialogField((IStringButtonAdapter)superClassAdapter);
        this.fSuperClassDialogField.setDialogFieldListener((IDialogFieldListener)superClassAdapter);
        this.fSuperClassDialogField.setLabelText(PHPUnitMessages.PHPUnitWizardPage_1);
        this.fSuperClassDialogField.setButtonLabel(PHPUnitMessages.PHPUnitWizardPage_2);
        this.fSuperClassStatus = new StatusInfo();
        this.fClassNameDialogField = new StringDialogField();
        this.fClassNameDialogField.setDialogFieldListener((IDialogFieldListener)new ClassNameFieldAdapter());
        this.fClassNameStatus = new StatusInfo();
        this.fClassNameDialogField.setLabelText(PHPUnitMessages.PHPUnitWizardPage_3);
        this.fFileNameDialogField = new StringDialogField();
        this.fFileNameDialogField.setDialogFieldListener((IDialogFieldListener)new FileNameFieldAdapter());
        this.fFileNameStatus = new StatusInfo();
        this.fFileNameDialogField.setLabelText(PHPUnitMessages.PHPUnitWizardPage_4);
        this.fElementToTestStatus = new StatusInfo();
    }

    protected IContainer chooseContainer() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select New Source Folder");
        dialog.setHelpAvailable(false);
        dialog.setTitle(PHPUnitMessages.PHPUnitWizardPage_10);
        dialog.setMessage(PHPUnitMessages.PHPUnitWizardPage_11);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            IPath path = (IPath)result[0];
            IResource foundMemder = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (foundMemder instanceof IContainer) {
                IContainer container = (IContainer)foundMemder;
                this.fContainerDialogField.setText(container.getFullPath().toOSString());
                if (container.getType() == 2) {
                    return PHPUnitValidator.validateContainer(container);
                }
                if (container.getType() == 4) {
                    return PHPUnitValidator.validateProject(container);
                }
            }
        }
        return null;
    }

    protected abstract IType chooseSuperClass();

    protected void classNameChanged() {
        StatusInfo status = new StatusInfo();
        String updatedClassName = PHPUnitValidator.validateClassName(this.getClassName(), this.fContainer != null ? this.fContainer.getProject() : null, status);
        this.fClassNameManual = !"".equals(updatedClassName) && !updatedClassName.equalsIgnoreCase(this.fClassNameProposal);
        this.fClassNameStatus = status;
        String string = this.fFileNameProposal = this.getClassName() != null ? this.getClassName() + DEFAULT_EXTENSION : "";
        if (!this.fFileNameManual && this.fFileNameDialogField != null) {
            this.fFileNameDialogField.setText(this.fFileNameProposal);
        }
        this.updateStatus(this.getStatusList());
    }

    private void classNameFieldChanged(DialogField field) {
        if (field == this.fClassNameDialogField) {
            this.classNameChanged();
        }
        this.updateStatus(this.getStatusList());
    }

    private void containerChangeControlPressed(DialogField field) {
        IContainer root = this.chooseContainer();
        if (root != null) {
            this.setContainer(root);
        }
    }

    protected void containerChanged() {
        IScriptProject scriptProject;
        IProject project;
        StatusInfo status = new StatusInfo();
        IContainer newContainer = PHPUnitValidator.validateContainer(this.fContainerDialogField.getText(), true, status);
        if (this.fContainer != newContainer) {
            this.invalidatCachedElements();
        }
        this.fContainer = newContainer;
        this.fContainerStatus = status;
        if (this.fContainer != null && (project = this.fContainer.getProject()) != null && this.fScriptProject != (scriptProject = DLTKCore.create((IProject)project))) {
            this.fScriptProject = scriptProject;
            this.fSearchEngine = new PHPUnitSearchEngine(this.fScriptProject);
        }
        this.updateStatus(this.getStatusList());
    }

    protected abstract void invalidatCachedElements();

    private void containerDialogFieldChanged(DialogField field) {
        if (field == this.fContainerDialogField) {
            this.containerChanged();
        }
        this.updateStatus(this.getStatusList());
    }

    protected void createClassNameControls(Composite composite, int nColumns) {
        this.fClassNameDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fClassNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
    }

    protected void createContainerControls(Composite parent, int nColumns) {
        this.fContainerDialogField.doFillIntoGrid(parent, nColumns);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 3;
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, 3);
        this.createSuperClassControls(composite, 3);
        this.createElementToTestControls(composite, 3);
        this.createSeparator(composite, 3);
        this.createClassNameControls(composite, 3);
        this.createFileNameControls(composite, 3);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.setFocus();
        this.updateStatus(this.getStatusList());
    }

    protected abstract void createElementToTestControls(Composite var1, int var2);

    protected void createFileNameControls(Composite composite, int nColumns) {
        this.fFileNameDialogField.doFillIntoGrid(composite, nColumns);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Label(composite, 258).setLayoutData((Object)new GridData(4, 1, true, false, nColumns, 1));
    }

    protected void createSuperClassControls(Composite composite, int nColumns) {
        this.fSuperClassDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fSuperClassDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        new Label(composite, 0);
        this.fSuperClassFileNameLabel = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.fSuperClassFileNameLabel.setLayoutData((Object)gridData);
        LayoutUtil.setWidthHint((Control)this.fSuperClassFileNameLabel, (int)this.getMaxFieldWidth());
        new Label(composite, 0);
        this.superClassChanged();
    }

    protected abstract String defaultSuperClass();

    public void dispose() {
        this.fContainerDialogField.setDialogFieldListener(null);
        this.fSuperClassDialogField.setDialogFieldListener(null);
        this.fClassNameDialogField.setDialogFieldListener(null);
        this.fFileNameDialogField.setDialogFieldListener(null);
        super.dispose();
    }

    protected void fileNameChanged() {
        StatusInfo status = new StatusInfo();
        String updatedFileName = PHPUnitValidator.validateFileName(this.getFileName(), this.fContainer != null ? this.fContainer : null, status);
        this.fFileNameManual = !updatedFileName.equals("") && !updatedFileName.equalsIgnoreCase(this.fFileNameProposal);
        this.fFileNameStatus = status;
        this.updateStatus(this.getStatusList());
    }

    private void fileNameFieldChanged(DialogField field) {
        if (field == this.fFileNameDialogField) {
            this.fileNameChanged();
        }
        this.updateStatus(this.getStatusList());
    }

    public String getClassName() {
        return this.fClassNameDialogField.getText().trim();
    }

    protected String getContainerLabel() {
        return PHPUnitMessages.PHPUnitWizardPage_15;
    }

    public String getFileName() {
        return this.fFileNameDialogField.getText().trim();
    }

    protected IContainer getInitialContainer(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            Object obj = selection.getFirstElement();
            if (obj instanceof IModelElement) {
                IResource resource = ((IModelElement)obj).getResource();
                if (resource != null && !(resource instanceof IContainer)) {
                    resource = resource.getParent();
                }
                return (IContainer)resource;
            }
            if (obj instanceof IResource) {
                IResource resource = (IResource)obj;
                if (resource != null && !(resource instanceof IContainer)) {
                    resource = resource.getParent();
                }
                return (IContainer)resource;
            }
        }
        return null;
    }

    protected IModelElement getInitialPHPElement(IStructuredSelection selection) {
        IType modelElement = null;
        int offset = -1;
        if (selection != null && !selection.isEmpty()) {
            IFile file;
            boolean isPhpFile;
            Object obj = selection.getFirstElement();
            if (obj instanceof NodeImpl) {
                if (obj instanceof IAdaptable) {
                    obj = ((IAdaptable)obj).getAdapter(IModelElement.class);
                }
            } else if (obj != null && obj instanceof ISourceModule) {
                if (selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    offset = textSelection.getOffset();
                }
                IType selectedType = null;
                ISourceModule sourceModule = (ISourceModule)obj;
                if (offset > -1) {
                    selectedType = PHPModelUtils.getCurrentType((ISourceModule)sourceModule, (int)offset);
                } else {
                    IType[] types = null;
                    try {
                        types = sourceModule.getTypes();
                    }
                    catch (ModelException e) {
                        PHPUnitPlugin.log(e);
                    }
                    if (types != null && types.length >= 1) {
                        selectedType = types[0];
                    }
                }
                if (selectedType != null) {
                    try {
                        int flags = selectedType.getFlags();
                        if (!(PHPFlags.isInterface((int)flags) || PHPFlags.isAbstract((int)flags) || this.fSearchEngine == null || this.fSearchEngine.isCase(selectedType))) {
                            modelElement = selectedType;
                        }
                    }
                    catch (ModelException e) {
                        PHPUnitPlugin.log(e);
                    }
                }
                if (modelElement == null) {
                    modelElement = sourceModule;
                }
            } else if (obj instanceof IType) {
                modelElement = (IType)obj;
            } else if (obj instanceof IFile && (isPhpFile = PHPToolkitUtil.isPHPFile((IFile)(file = (IFile)obj)))) {
                modelElement = DLTKCore.create((IFile)((IFile)obj));
            }
        }
        return modelElement;
    }

    public Object init(IStructuredSelection selection) {
        IModelElement result;
        IModelElement element = this.getInitialPHPElement(selection);
        if (element != null) {
            this.initContainerPage(element);
            if (element instanceof IType) {
                this.setClassName(((IType)element).getElementName());
            }
            result = element;
        } else {
            IContainer container = this.getInitialContainer(selection);
            if (container != null) {
                this.setContainer(container);
                this.setSuperClass(null);
                result = container;
            } else {
                result = null;
                this.fContainerDialogField.setText("");
            }
        }
        this.updateStatus(this.getStatusList());
        return result;
    }

    protected void initContainerPage(IModelElement modelElement) {
        IModelElement tempElement = modelElement;
        if (modelElement != null) {
            while (!(tempElement instanceof IScriptFolder) && !(tempElement instanceof IScriptProject)) {
                tempElement = tempElement.getParent();
            }
        }
        IProject container = null;
        if (tempElement instanceof IScriptFolder) {
            IResource resource = tempElement.getResource();
            if (resource instanceof IFolder) {
                container = (IFolder)resource;
            }
            if (resource instanceof IProject) {
                container = (IProject)resource;
            }
        }
        if (tempElement instanceof IScriptProject) {
            container = ((IScriptProject)tempElement).getProject();
        }
        this.setContainer((IContainer)container);
    }

    public void setClassName(String name) {
        this.fClassNameDialogField.setText(name);
    }

    public void setContainer(IContainer root) {
        IScriptProject scriptProject;
        IProject project;
        this.fContainer = root;
        if (this.fContainer != null && (project = this.fContainer.getProject()) != null && this.fScriptProject != (scriptProject = DLTKCore.create((IProject)project))) {
            this.fScriptProject = scriptProject;
            this.fSearchEngine = new PHPUnitSearchEngine(this.fScriptProject);
        }
        String str = root == null ? "" : root.getFullPath().toOSString();
        this.fContainerDialogField.setText(str);
    }

    protected void setFocus() {
        this.fClassNameDialogField.setFocus();
    }

    public void setSuperClass(IType classData) {
        this.fSuperClassDialogField.setText(classData != null ? classData.getElementName() : this.defaultSuperClass());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fPageVisible = visible;
        this.updateStatus(this.getStatusList());
    }

    private void superClassButtonPressed(DialogField field) {
        IType classData = this.chooseSuperClass();
        if (classData != null) {
            this.setSuperClass(classData);
        }
    }

    protected void superClassChanged() {
        String superClassName;
        StatusInfo status = new StatusInfo();
        Object element = this.fSuperClass;
        if (this.fSuperClass == null || !this.fSuperClass.getElementName().equals(this.getSuperClassName())) {
            this.fSuperClass = null;
            element = this.getSuperClassName();
        }
        this.fSuperClass = (IType)PHPUnitValidator.validateElement(element, this.fContainer != null ? this.fContainer.getProject() : null, false, 7, status);
        String string = superClassName = this.fSuperClass != null ? this.fSuperClass.getElementName() : "";
        if (this.fSuperClassFileNameLabel != null && !this.fSuperClassFileNameLabel.isDisposed()) {
            this.fSuperClassFileNameLabel.setText(superClassName);
        }
        this.fSuperClassStatus = status;
        if ("".equals(this.getSuperClassName())) {
            status.setError(PHPUnitMessages.PHPUnitWizardPage_20);
        }
        this.updateStatus(this.getStatusList());
    }

    private void superClassFieldChanged(DialogField field) {
        this.superClassChanged();
    }

    protected abstract String testSuffix();

    protected void updateStatus(IStatus status) {
        this.setPageComplete(!status.matches(4));
        if (this.fPageVisible) {
            StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
        }
    }

    protected void updateStatus(IStatus[] statuses) {
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])statuses));
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected IStatus[] getStatusList() {
        return new IStatus[]{this.fContainerStatus, this.fClassNameStatus, this.fFileNameStatus, this.fElementToTestStatus, this.fSuperClassStatus};
    }

    public IType getSuperClass() {
        return this.fSuperClass;
    }

    public String getSuperClassName() {
        return this.fSuperClassDialogField.getText().trim();
    }

    public IContainer getTestContainer() {
        return this.fContainer;
    }

    class ClassNameFieldAdapter
    implements IDialogFieldListener {
        ClassNameFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            PHPUnitWizardPage.this.classNameFieldChanged(field);
        }
    }

    class ContainerFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        ContainerFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            PHPUnitWizardPage.this.containerChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            PHPUnitWizardPage.this.containerDialogFieldChanged(field);
        }
    }

    class FileNameFieldAdapter
    implements IDialogFieldListener {
        FileNameFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            PHPUnitWizardPage.this.fileNameFieldChanged(field);
        }
    }

    class SuperClassFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        SuperClassFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            PHPUnitWizardPage.this.superClassButtonPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            PHPUnitWizardPage.this.superClassFieldChanged(field);
        }
    }
}

