/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.launcher;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.php.debug.ui.IDebugServerConnectionTest;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.ui.launching.AbstractPHPLaunchConfigurationTab;
import org.eclipse.php.profile.ui.ProfilerUIImages;
import org.eclipse.php.profile.ui.launcher.IProfilerLaunchSettingsSection;
import org.eclipse.php.profile.ui.launcher.Messages;
import org.eclipse.php.profile.ui.launcher.ProfilerLaunchSettingsSectionAdapter;
import org.eclipse.php.profile.ui.launcher.ProfilerLaunchSettingsSectionRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractPHPLaunchConfigurationProfilerTab
extends AbstractPHPLaunchConfigurationTab {
    protected Button validateProfilerBtn;
    protected IDebugServerConnectionTest[] profileTesters;
    private Label profilerName;
    private Button configureProfiler;
    private Composite mainComposite;
    private Composite settingsComposite;
    private Map<String, IProfilerLaunchSettingsSection> currentSection = new HashMap<String, IProfilerLaunchSettingsSection>();

    public String getName() {
        return Messages.AbstractPHPLaunchConfigurationProfilerTab_Profiler_group_name;
    }

    public Image getImage() {
        return ProfilerUIImages.get("IMG_OBJ_PROFILE_CONF");
    }

    public void createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)mainLayout);
        this.createProfilerSelectionControl(this.mainComposite);
        this.settingsComposite = new Composite(this.mainComposite, 0);
        Dialog.applyDialogFont((Control)this.mainComposite);
        this.setControl((Control)this.mainComposite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        this.getSection().setDefaults(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, this.getCurrentProfilerId());
        this.getSection().performApply(configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setMessage(null);
        this.setWarningMessage(null);
        this.setErrorMessage(null);
        StatusMessage status = this.getSection().isValid(launchConfig);
        switch (status.getMessageType()) {
            case 3: {
                this.setErrorMessage(status.getMessage());
                return false;
            }
            case 2: {
                this.setWarningMessage(status.getMessage());
                return true;
            }
        }
        return true;
    }

    protected void initialize(ILaunchConfiguration configuration) {
        this.getSection().initialize(configuration);
    }

    protected abstract void handleConfigureProfiler();

    protected abstract String getCurrentProfilerId();

    protected abstract String getNoProfilerMessage();

    protected abstract void updateProfileTest();

    protected abstract void performProfileTest();

    private void createProfilerSelectionControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout mcLayout = new GridLayout(1, false);
        mcLayout.marginHeight = 0;
        mcLayout.marginWidth = 0;
        mainComposite.setLayout((Layout)mcLayout);
        mainComposite.setLayoutData((Object)new GridData(768));
        Composite profilerChoiceComposite = new Composite(mainComposite, 0);
        GridLayout layout = new GridLayout(5, false);
        profilerChoiceComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        profilerChoiceComposite.setLayoutData((Object)data);
        Font font = parent.getFont();
        profilerChoiceComposite.setFont(font);
        Label label = new Label(profilerChoiceComposite, 64);
        data = new GridData(1);
        label.setLayoutData((Object)data);
        label.setFont(font);
        label.setText(Messages.AbstractPHPLaunchConfigurationProfilerTab_Profiler_label);
        this.profilerName = new Label(profilerChoiceComposite, 0);
        Label separator = new Label(profilerChoiceComposite, 0);
        data = new GridData(1);
        data.widthHint = 20;
        separator.setLayoutData((Object)data);
        this.configureProfiler = this.createPushButton(profilerChoiceComposite, Messages.AbstractPHPLaunchConfigurationProfilerTab_Configure, null);
        this.configureProfiler.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPHPLaunchConfigurationProfilerTab.this.handleConfigureProfiler();
            }
        });
        this.configureProfiler.addSelectionListener((SelectionListener)new WidgetListener());
        this.validateProfilerBtn = this.createPushButton(profilerChoiceComposite, Messages.AbstractPHPLaunchConfigurationProfilerTab_Test, null);
        this.validateProfilerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractPHPLaunchConfigurationProfilerTab.this.performProfileTest();
            }
        });
        Label lineSeparator = new Label(mainComposite, 258);
        lineSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private IProfilerLaunchSettingsSection getSection() {
        try {
            String launchTypeId = this.getConfiguration().getType().getIdentifier();
            String profilerId = this.getCurrentProfilerId();
            IProfilerLaunchSettingsSection section = this.currentSection.get(profilerId);
            if (section == null) {
                if ("org.eclipse.php.debug.core.noneDebugger".equals(profilerId)) {
                    section = new NoneProfilerSection();
                } else {
                    section = ProfilerLaunchSettingsSectionRegistry.getSection(profilerId, launchTypeId);
                    if (section == null) {
                        section = new UnsupportedProfilerSection();
                    }
                }
                if (this.settingsComposite != null) {
                    this.buildSection(profilerId, section);
                }
            }
            return section;
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
            return null;
        }
    }

    private void buildSection(String debuggerId, IProfilerLaunchSettingsSection section) {
        this.updateProfiler(debuggerId);
        this.currentSection.clear();
        this.currentSection.put(debuggerId, section);
        this.settingsComposite.dispose();
        this.settingsComposite = new Composite(this.mainComposite, 0);
        this.settingsComposite.setLayout((Layout)new GridLayout());
        GridData dscData = new GridData(4, 4, true, true);
        this.settingsComposite.setLayoutData((Object)dscData);
        section.createSection(this.settingsComposite, new WidgetListener());
        this.mainComposite.layout();
        section.initialize(this.getConfiguration());
    }

    private void updateProfiler(String profilerId) {
        this.profilerName.setText(PHPDebuggersRegistry.getDebuggerName((String)profilerId));
        try {
            if (this.getOriginalConfiguration().contentsEqual(this.getConfiguration())) {
                ILaunchConfigurationWorkingCopy wc = this.getOriginalConfiguration().getWorkingCopy();
                wc.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, profilerId);
                wc.doSave();
            }
            if (this.getConfiguration() instanceof ILaunchConfigurationWorkingCopy) {
                ((ILaunchConfigurationWorkingCopy)this.getConfiguration()).setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, profilerId);
            }
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        this.updateProfileTest();
    }

    private final class NoneProfilerSection
    extends ProfilerLaunchSettingsSectionAdapter {
        private NoneProfilerSection() {
        }

        @Override
        public StatusMessage isValid(ILaunchConfiguration configuration) {
            return new StatusMessage(3, AbstractPHPLaunchConfigurationProfilerTab.this.getNoProfilerMessage());
        }
    }

    public static final class StatusMessage
    implements IMessageProvider {
        private int type;
        private String message;

        public StatusMessage(int type, String message) {
            this.type = type;
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public int getMessageType() {
            return this.type;
        }
    }

    private final class UnsupportedProfilerSection
    extends ProfilerLaunchSettingsSectionAdapter {
        private UnsupportedProfilerSection() {
        }

        @Override
        public void createSection(Composite parent, WidgetListener widgetListener) {
            Label info = new Label(parent, 0);
            info.setText(Messages.AbstractPHPLaunchConfigurationProfilerTab_Unsupported_profiler_type);
        }

        @Override
        public StatusMessage isValid(ILaunchConfiguration configuration) {
            return new StatusMessage(3, Messages.AbstractPHPLaunchConfigurationProfilerTab_Unsupported_profiler_type);
        }
    }

    public final class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            AbstractPHPLaunchConfigurationProfilerTab.this.setDirty(true);
            AbstractPHPLaunchConfigurationProfilerTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractPHPLaunchConfigurationProfilerTab.this.setDirty(true);
            AbstractPHPLaunchConfigurationProfilerTab.this.updateLaunchConfigurationDialog();
        }
    }
}

