/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.zend.communication.IRemoteFileContentRequestor;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.ui.editor.OpenRemoteFileContentRequestor;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.profile.core.data.ProfilerClassData;
import org.eclipse.php.profile.core.data.ProfilerFileData;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.core.data.ProfilerGlobalData;
import org.eclipse.php.profile.core.engine.IProfileSessionListener;
import org.eclipse.php.profile.core.engine.ProfileSessionsManager;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUIConstants;
import org.eclipse.php.profile.ui.ProfilerUIImages;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.php.profile.ui.actions.ExecutionStatisticsActionGroup;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFilter;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFiltersRegistry;
import org.eclipse.php.profile.ui.views.AbstractProfilerFunctionsView;
import org.eclipse.php.profile.ui.views.ExecutionStatisticsContentProvider;
import org.eclipse.php.profile.ui.views.ExecutionStatisticsLabelProvider;
import org.eclipse.php.profile.ui.views.ExecutionStatisticsSorter;
import org.eclipse.php.profile.ui.views.SimpleHTMLPresentableTreeElement;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;

public class ExecutionStatisticsView
extends AbstractProfilerFunctionsView
implements IDoubleClickListener,
ITreeViewerListener,
IMenuListener,
IProfileSessionListener {
    private Tree fTree;
    private TreeViewer fTreeViewer;
    private String[] fColumnHeaders = new String[]{PHPProfileUIMessages.getString("ExecutionStatisticsView_1"), PHPProfileUIMessages.getString("ExecutionStatisticsView_2"), PHPProfileUIMessages.getString("ExecutionStatisticsView_3"), PHPProfileUIMessages.getString("ExecutionStatisticsView_4"), PHPProfileUIMessages.getString("ExecutionStatisticsView_5"), PHPProfileUIMessages.getString("ExecutionStatisticsView_6")};
    private int[] fColumnWidths = new int[]{200, 130, 150, 130, 130, 130};
    private int[] fNumericColumns = new int[]{1, 2, 3, 4, 5};
    private ExecutionStatisticsActionGroup fActionSet;
    private ExecutionStatisticsSorter fSorter;
    private Menu fContextMenu;
    private ProfilerDB fProfilerDB;
    private IPreferenceStore fPreferenceStore = ProfilerUiPlugin.getDefault().getPreferenceStore();

    private void createTable(Composite parent) {
        ExecutionStatisticsFilter filter;
        this.fTree = new Tree(parent, 66306);
        this.fTree.setLinesVisible(true);
        this.fTree.setHeaderVisible(true);
        this.fSorter = new ExecutionStatisticsSorter();
        int i = 0;
        while (i < this.fColumnHeaders.length) {
            TreeColumn tableColumn = new TreeColumn(this.fTree, 16384, i);
            tableColumn.setText(this.fColumnHeaders[i]);
            tableColumn.setWidth(this.fColumnWidths[i]);
            int c = 0;
            while (c < this.fNumericColumns.length) {
                if (this.fNumericColumns[c] == i) {
                    tableColumn.setAlignment(131072);
                    break;
                }
                ++c;
            }
            final int field = i++;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExecutionStatisticsView.this.fSorter.setColumn(field);
                    TreeColumn[] tableColumns = ExecutionStatisticsView.this.fTree.getColumns();
                    int i = 0;
                    while (i < ExecutionStatisticsView.this.fColumnHeaders.length) {
                        tableColumns[i].setImage(null);
                        ++i;
                    }
                    if (ExecutionStatisticsView.this.fSorter.getOrder() == ProfilerUIConstants.SORT_ASCENDING) {
                        tableColumns[field].setImage(ProfilerUIImages.get("IMG_OBJ_SORT_ASCENDING"));
                    } else if (ExecutionStatisticsView.this.fSorter.getOrder() == ProfilerUIConstants.SORT_DESCENDING) {
                        tableColumns[field].setImage(ProfilerUIImages.get("IMG_OBJ_SORT_DESCENDING"));
                    }
                    BusyIndicator.showWhile((Display)ExecutionStatisticsView.this.fTree.getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).ExecutionStatisticsView.this.fTreeViewer.getControl().setRedraw(false);
                            (this).ExecutionStatisticsView.this.fTreeViewer.refresh();
                            (this).ExecutionStatisticsView.this.fTreeViewer.getControl().setRedraw(true);
                            ExecutionStatisticsView.this.restoreExpandedElements();
                        }
                    });
                }
            });
        }
        this.fTreeViewer = new TreeViewer(this.fTree);
        this.fTreeViewer.setContentProvider((IContentProvider)new ExecutionStatisticsContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ExecutionStatisticsLabelProvider());
        this.fTreeViewer.setSorter((ViewerSorter)this.fSorter);
        String selectedFilter = this.fPreferenceStore.getString("executionStatisticsSelectedFilter");
        if (selectedFilter.length() > 0 && (filter = ExecutionStatisticsFiltersRegistry.getFilterByName(selectedFilter)) != null) {
            this.fTreeViewer.addFilter((ViewerFilter)filter);
        }
        this.fTreeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.fTreeViewer.addTreeListener((ITreeViewerListener)this);
        this.fActionSet = new ExecutionStatisticsActionGroup(this);
        this.fActionSet.fillActionBars(this.getViewSite().getActionBars());
        this.hookContextMenu();
    }

    public void createPartControl(Composite parent) {
        this.createTable(parent);
        ProfileSessionsManager.addProfileSessionListener((IProfileSessionListener)this);
        this.setInput(ProfileSessionsManager.getCurrent());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.execution_statistics_view");
    }

    public void dispose() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.removeDoubleClickListener((IDoubleClickListener)this);
        }
        ProfileSessionsManager.removeProfileSessionListener((IProfileSessionListener)this);
        super.dispose();
    }

    public void setFocus() {
    }

    @Override
    public ProfilerDB getInput() {
        return this.fProfilerDB;
    }

    @Override
    public void setInput(ProfilerDB profilerDB) {
        if (this.fTreeViewer == null || this.fTreeViewer.getContentProvider() == null) {
            return;
        }
        if (this.fProfilerDB != profilerDB) {
            if (profilerDB != null) {
                ProfilerFileData[] files = profilerDB.getFiles();
                SimpleHTMLPresentableTreeElement root = new SimpleHTMLPresentableTreeElement();
                int i = 0;
                while (i < files.length) {
                    SimpleHTMLPresentableTreeElement fileItem = new SimpleHTMLPresentableTreeElement(root, files[i]);
                    fileItem.setExpanded(true);
                    root.addChild(fileItem);
                    ProfilerClassData[] classes = files[i].getClasses();
                    int j = 0;
                    while (j < classes.length) {
                        SimpleHTMLPresentableTreeElement classItem = new SimpleHTMLPresentableTreeElement(fileItem, classes[j]);
                        classItem.setExpanded(true);
                        fileItem.addChild(classItem);
                        ProfilerFunctionData[] methods = classes[j].getMethods();
                        int k = 0;
                        while (k < methods.length) {
                            SimpleHTMLPresentableTreeElement element = new SimpleHTMLPresentableTreeElement(classItem, methods[k]);
                            classItem.addChild(element);
                            ++k;
                        }
                        ++j;
                    }
                    ProfilerFunctionData[] functions = files[i].getFunctions();
                    int j2 = 0;
                    while (j2 < functions.length) {
                        if (functions[j2].getClassName() == null) {
                            SimpleHTMLPresentableTreeElement element = new SimpleHTMLPresentableTreeElement(fileItem, functions[j2]);
                            element.setExpanded(false);
                            fileItem.addChild(element);
                        }
                        ++j2;
                    }
                    ++i;
                }
                this.fTreeViewer.setInput((Object)root);
            } else {
                this.fTreeViewer.setInput(null);
            }
            BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ExecutionStatisticsView.this.fTreeViewer.getControl().setRedraw(false);
                    ExecutionStatisticsView.this.fTreeViewer.refresh();
                    ExecutionStatisticsView.this.fTreeViewer.getControl().setRedraw(true);
                    ExecutionStatisticsView.this.storeExpandedElements();
                }
            });
            this.fProfilerDB = profilerDB;
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            SimpleHTMLPresentableTreeElement ExecutionStatisticsTreeElement = (SimpleHTMLPresentableTreeElement)sSelection.getFirstElement();
            Object element = ExecutionStatisticsTreeElement.getData();
            if (element instanceof ProfilerFunctionData) {
                ProfilerFunctionData data = (ProfilerFunctionData)element;
                try {
                    String url;
                    if (!(data.getLocalFileName() != null && EditorUtility.openLocalFile((String)data.getLocalFileName(), (int)data.getLineNumber()) != null || ProfilerGlobalData.URL_NOT_AVAILABLE_MSG.equals(url = this.fProfilerDB.getGlobalData().getOriginalURL()))) {
                        RemoteDebugger.requestRemoteFile((IRemoteFileContentRequestor)new OpenRemoteFileContentRequestor(), (String)data.getAbsoluteFileName(), (int)data.getLineNumber(), (String)url);
                    }
                }
                catch (CoreException coreException) {
                    MessageDialog.openError((Shell)this.fTreeViewer.getControl().getShell(), (String)PHPProfileUIMessages.getString("ExecutionStatisticsView.0"), (String)NLS.bind((String)PHPProfileUIMessages.getString("ExecutionStatisticsView.1"), (Object)data.getLocalFileName()));
                }
            } else {
                boolean expanded = !this.fTreeViewer.getExpandedState((Object)ExecutionStatisticsTreeElement);
                this.fTreeViewer.setExpandedState((Object)ExecutionStatisticsTreeElement, expanded);
                this.fTreeViewer.getControl().setRedraw(true);
            }
        }
    }

    @Override
    public TreeViewer getViewer() {
        return this.fTreeViewer;
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        SimpleHTMLPresentableTreeElement element = (SimpleHTMLPresentableTreeElement)event.getElement();
        element.setExpanded(false);
    }

    public void treeExpanded(TreeExpansionEvent event) {
        SimpleHTMLPresentableTreeElement element = (SimpleHTMLPresentableTreeElement)event.getElement();
        element.setExpanded(true);
    }

    public void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuManager.createContextMenu((Control)this.fTree);
        this.fTree.setMenu(this.fContextMenu);
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.fActionSet.fillContextMenu(manager);
    }

    public void currentSessionChanged(final ProfilerDB current) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExecutionStatisticsView.this.setInput(current);
            }
        });
    }

    public void profileSessionAdded(ProfilerDB db) {
    }

    public void profileSessionRemoved(ProfilerDB db) {
    }
}

