/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.doubleclick;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPPairMatcher;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.w3c.dom.Node;

public class PHPDoubleClickStrategy
extends DefaultTextDoubleClickStrategy {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    protected PHPPairMatcher fPairMatcher = new PHPPairMatcher(BRACKETS);

    public void doubleClicked(ITextViewer textViewer) {
        if (textViewer instanceof StructuredTextViewer) {
            StructuredTextViewer structuredTextViewer = (StructuredTextViewer)textViewer;
            IStructuredModel structuredModel = null;
            try {
                IStructuredDocumentRegion sdRegion;
                Node node;
                int caretPosition;
                structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(structuredTextViewer.getDocument());
                if (structuredModel != null && (caretPosition = textViewer.getSelectedRange().x) > 0 && (node = (Node)structuredModel.getIndexedRegion(caretPosition)) != null && (sdRegion = structuredModel.getStructuredDocument().getRegionAtCharacterOffset(caretPosition)) != null) {
                    ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(caretPosition);
                    IStructuredDocumentRegion container = sdRegion;
                    if (tRegion instanceof ITextRegionContainer) {
                        container = (ITextRegionContainer)tRegion;
                        tRegion = container.getRegionAtCharacterOffset(caretPosition);
                    }
                    if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
                        IPHPScriptRegion phpScriptRegion = (IPHPScriptRegion)tRegion;
                        int offset = caretPosition - container.getStartOffset() - phpScriptRegion.getStart();
                        if ((tRegion = phpScriptRegion.getPHPToken(offset)).getType() == "PHP_VARIABLE" || tRegion.getType() == "PHP_THIS" || PHPPartitionTypes.isPHPDocTagState((String)tRegion.getType())) {
                            int regionStart = container.getStartOffset() + phpScriptRegion.getStart();
                            if (caretPosition == regionStart + tRegion.getTextEnd()) {
                                IDocument document = textViewer.getDocument();
                                IRegion region = this.findWord(document, caretPosition - 1);
                                if (region != null) {
                                    textViewer.setSelectedRange(region.getOffset(), region.getLength());
                                }
                            } else {
                                textViewer.setSelectedRange(regionStart + tRegion.getStart(), tRegion.getTextLength());
                            }
                            return;
                        }
                        if (PHPPartitionTypes.isPHPCommentState((String)tRegion.getType()) && offset > 0 && PHPPartitionTypes.isPHPCommentState((String)phpScriptRegion.getPHPToken(offset - 1).getType())) {
                            this.resetVariableSelectionRangeInComments(textViewer, structuredTextViewer);
                            return;
                        }
                    }
                }
            }
            catch (BadLocationException e) {
                PHPUiPlugin.log(e);
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        super.doubleClicked(textViewer);
    }

    protected IRegion findExtendedDoubleClickSelection(IDocument document, int offset) {
        IRegion match = this.fPairMatcher.match(document, offset);
        if (match != null && match.getLength() >= 2) {
            return new Region(match.getOffset() + 1, match.getLength() - 2);
        }
        return this.findWord(document, offset);
    }

    private void resetVariableSelectionRangeInComments(ITextViewer textViewer, StructuredTextViewer structuredTextViewer) throws BadLocationException {
        super.doubleClicked(textViewer);
        Point selectedRange = structuredTextViewer.getSelectedRange();
        int offset = selectedRange.x;
        if (offset > 0) {
            IDocument document = structuredTextViewer.getDocument();
            char previousChar = document.getChar(offset - 1);
            if (previousChar == '$') {
                structuredTextViewer.setSelectedRange(offset - 1, selectedRange.y + 1);
            } else if (selectedRange.y == 1 && document.getChar(offset) == '$') {
                structuredTextViewer.setSelectedRange(offset, selectedRange.y + 1);
            }
        }
    }
}

