/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hyperlink;

import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.Region;
import org.eclipse.php.core.compiler.ast.nodes.Include;
import org.eclipse.php.core.compiler.ast.nodes.InfixExpression;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;

public class IncludeHyperlinkVisitor
extends ASTVisitor {
    private static final String DIRNAME_METHOD = "dirname";
    private static final String DIR_CONST = "__DIR__";
    private static final String FILE_CONST = "__FILE__";
    private boolean found = false;
    private int offset;
    private ISourceModule sourceModule;
    private StringBuilder filePath;
    private Region selectRegion;

    public IncludeHyperlinkVisitor(int offset, ISourceModule sourceModule) {
        this.offset = offset;
        this.sourceModule = sourceModule;
        this.filePath = new StringBuilder();
    }

    public boolean visit(Expression expr) throws ModelException {
        if (expr.sourceStart() < this.offset && expr.sourceEnd() > this.offset && expr instanceof Include) {
            Expression fileExpr = ((Include)expr).getExpr();
            if (fileExpr instanceof InfixExpression) {
                this.processInfixExpression((InfixExpression)fileExpr);
            } else if (fileExpr instanceof Scalar) {
                this.processScalar((Scalar)fileExpr);
            }
            this.selectRegion = new Region(fileExpr.sourceStart(), fileExpr.sourceEnd() - fileExpr.sourceStart());
            this.found = true;
            return false;
        }
        return !this.found;
    }

    private void processInfixExpression(InfixExpression infixExpression) {
        if (!infixExpression.getOperator().equals(".")) {
            return;
        }
        for (ASTNode child : infixExpression.getChilds()) {
            String tmpPath;
            if (child instanceof InfixExpression) {
                this.processInfixExpression((InfixExpression)child);
                continue;
            }
            if (child instanceof Scalar) {
                this.processScalar((Scalar)child);
                continue;
            }
            if (!(child instanceof PHPCallExpression) || (tmpPath = this.resolvePHPCallExpression((PHPCallExpression)child)) == null) continue;
            this.filePath = this.filePath.append(tmpPath);
        }
    }

    private void processScalar(Scalar scalar) {
        String resolvedValue = this.resolveScalarValue(scalar);
        if (resolvedValue == null) {
            return;
        }
        this.filePath = this.filePath.append(resolvedValue);
    }

    private String resolvePHPCallExpression(PHPCallExpression callExpression) {
        if (callExpression.getCallName().getName().equals(DIRNAME_METHOD)) {
            CallArgumentsList argsList = callExpression.getArgs();
            for (ASTNode astNode : argsList.getChilds()) {
                if (astNode instanceof Scalar) {
                    return this.resolveDirname(this.resolveScalarValue((Scalar)astNode));
                }
                if (!(astNode instanceof PHPCallExpression)) continue;
                return this.resolveDirname(this.resolvePHPCallExpression((PHPCallExpression)astNode));
            }
        }
        return null;
    }

    private String resolveScalarValue(Scalar scalar) {
        if (scalar.getValue() == DIR_CONST) {
            return this.sourceModule.getResource().getLocation().removeLastSegments(1).toOSString();
        }
        if (scalar.getValue() == FILE_CONST) {
            return this.sourceModule.getResource().getLocation().toOSString();
        }
        String value = scalar.getValue();
        return ASTUtils.stripQuotes((String)value).trim();
    }

    private String resolveDirname(String path) {
        if (path == null) {
            return null;
        }
        return new Path(path).removeLastSegments(1).toOSString();
    }

    public boolean visitGeneral(ASTNode n) {
        return !this.found;
    }

    public String getFile() {
        return this.filePath.toString();
    }

    public Region getSelectRegion() {
        return this.selectRegion;
    }
}

