/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.php.internal.ui.preferences.sourcepath.SourcePathBlock;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class PHPSourcePathsPreferencePage
extends PropertyAndPreferencePage {
    private static final String PROPERTY_ID = "org.eclipse.php.ui.propertyPages.PHPSourcePathsPreferencePage";
    private SourcePathBlock fSourceBlock = null;

    @Override
    protected Control createPreferenceContent(Composite composite) {
        Control result;
        this.noDefaultAndApplyButton();
        IProject project = this.getProject();
        try {
            result = project == null || !project.isAccessible() || !PHPToolkitUtil.isPHPProject((IProject)project) ? this.createInvalid(composite) : this.createWith(composite);
        }
        catch (CoreException e) {
            result = this.createInvalid(composite);
            Logger.logException(e);
        }
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private Control createWith(Composite composite) {
        this.fSourceBlock = new SourcePathBlock(composite, this.getProject());
        return null;
    }

    private Control createInvalid(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(PreferencesMessages.BuildPathsPropertyPage_no_script_project_message);
        this.fSourceBlock = null;
        this.setValid(true);
        return label;
    }

    @Override
    protected boolean hasProjectSpecificOptions(IProject project) {
        return false;
    }

    @Override
    protected String getPreferencePageID() {
        return null;
    }

    @Override
    protected String getPropertyPageID() {
        return PROPERTY_ID;
    }
}

