/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedConditionVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;

public class MultipleEdgeCheckedCondition
extends CheckedCondition {
    protected final @NonNull Node node;
    protected final @NonNull List<@NonNull Edge> edges = new ArrayList<Edge>();

    public MultipleEdgeCheckedCondition(@NonNull Node node, @NonNull Edge firstEdge, @NonNull Edge secondEdge) {
        this.node = node;
        this.addEdge(firstEdge);
        this.addEdge(secondEdge);
    }

    @Override
    public <R> R accept(@NonNull CheckedConditionVisitor<R> visitor) {
        return visitor.visitMultipleEdgeCheckedCondition(this);
    }

    public boolean addEdge(@NonNull Edge edge) {
        return this.edges.add(edge);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultipleEdgeCheckedCondition)) {
            return false;
        }
        MultipleEdgeCheckedCondition that = (MultipleEdgeCheckedCondition)obj;
        if (this.node != that.node) {
            return false;
        }
        int size = this.edges.size();
        if (size != that.edges.size()) {
            return false;
        }
        int[] these = new int[size];
        int[] those = new int[size];
        int i = 0;
        while (i < size) {
            these[i] = System.identityHashCode(this.edges.get(i));
            those[i] = System.identityHashCode(that.edges.get(i));
            ++i;
        }
        Arrays.sort(these);
        Arrays.sort(those);
        return these.equals(those);
    }

    @Override
    public @NonNull Iterable<@NonNull Edge> getEdges() {
        return this.edges;
    }

    @Override
    public @NonNull Node getNode() {
        return this.node;
    }

    @Override
    public int hashCode() {
        int hash = this.getClass().hashCode() + System.identityHashCode(this.node);
        for (Edge edge : this.edges) {
            hash += System.identityHashCode(edge);
        }
        return hash;
    }
}

