/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.validators;

import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.ValidatorLongInput;

public class ValidatorLongRangeInput
extends ValidatorLongInput {
    private long minRange;
    private long maxRange;
    private long orgMinRange;
    private long orgMaxRange;
    private Long minRangeLong;
    private Long maxRangeLong;
    private SystemMessage msg_InvalidRange = RSEUIPlugin.getPluginMessage("RSEG1172");

    public ValidatorLongRangeInput(long minRange, long maxRange) {
        this(minRange, maxRange, false);
    }

    public ValidatorLongRangeInput(long minRange, long maxRange, boolean allowBlank) {
        super(RSEUIPlugin.getPluginMessage("RSEG1170"), RSEUIPlugin.getPluginMessage("RSEG1171"));
        this.orgMinRange = minRange;
        this.orgMaxRange = maxRange;
        super.setBlankAllowed(allowBlank);
        this.setRange(minRange, maxRange);
    }

    public void setRange(long minRange, long maxRange) {
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.minRangeLong = new Long(minRange);
        this.maxRangeLong = new Long(maxRange);
    }

    public void restoreRange() {
        this.setRange(this.orgMinRange, this.orgMaxRange);
    }

    public void setErrorMessages(SystemMessage emptyMsg, SystemMessage invalidMsg, SystemMessage outOfRangeMsg) {
        super.setErrorMessages(emptyMsg, invalidMsg);
        this.msg_InvalidRange = outOfRangeMsg;
    }

    public int getMaximumNameLength() {
        int maxlen = Long.toString(Math.abs(this.maxRange)).length();
        if (this.maxRange < 0L) {
            ++maxlen;
        }
        return maxlen;
    }

    public String isValid(String input) {
        String msg = super.isValid(input);
        if (msg == null && input != null && input.length() > 0 && (this.number < this.minRange || this.number > this.maxRange)) {
            this.currentMessage = this.msg_InvalidRange;
            this.currentMessage.makeSubstitution((Object)input, (Object)this.minRangeLong, (Object)this.maxRangeLong);
            msg = this.currentMessage.getLevelOneText();
        }
        return msg;
    }
}

