/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui;

import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemPromptCommandDialog
extends SystemPromptDialog {
    protected Text cmdText;
    protected Label newNamePrompt;
    protected String cmd;
    protected String newCmdString;
    protected SystemMessage errorMessage;

    public SystemPromptCommandDialog(Shell shell, String command) {
        this(shell, command, SystemUDAResources.RESID_UDA_PROMPTCMD_TITLE);
    }

    public SystemPromptCommandDialog(Shell shell, String command, String title) {
        super(shell, title);
        this.cmd = command;
        super.setOkButtonLabel(this.getOKButtonLabel());
        super.setOkButtonToolTipText(this.getOKButtonToolTipText());
        super.setCancelButtonToolTipText(this.getCancelButtonToolTipText());
    }

    protected String getOKButtonLabel() {
        return SystemUDAResources.RESID_UDA_PROMPTCMD_OKBUTTON_LABEL;
    }

    protected String getOKButtonToolTipText() {
        return SystemUDAResources.RESID_UDA_PROMPTCMD_OKBUTTON_TOOLTIP;
    }

    protected String getCancelButtonToolTipText() {
        return SystemUDAResources.RESID_UDA_PROMPTCMD_CANCELBUTTON_TOOLTIP;
    }

    protected String getVerbage() {
        return SystemUDAResources.RESID_UDA_PROMPTCMD_VERBAGE_LABEL;
    }

    protected String getPromptLabel() {
        return SystemUDAResources.RESID_UDA_PROMPTCMD_PROMPT_LABEL;
    }

    protected String getPromptToolTipText() {
        return SystemUDAResources.RESID_UDA_PROMPTCMD_PROMPT_TOOLTIP;
    }

    protected Control createInner(Composite parent) {
        int nbrColumns = 1;
        Composite composite_prompts = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        SystemWidgetHelpers.createVerbiage((Composite)composite_prompts, (String)this.getVerbage(), (int)nbrColumns, (boolean)false, (int)250);
        this.addFillerLine(composite_prompts, nbrColumns);
        SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)this.getPromptLabel());
        this.cmdText = SystemWidgetHelpers.createMultiLineTextField((Composite)composite_prompts, null, (int)65);
        ((GridData)this.cmdText.getLayoutData()).widthHint = 350;
        this.cmdText.setToolTipText(this.getPromptToolTipText());
        this.cmdText.setTextLimit(2000);
        this.cmdText.setText(this.cmd);
        this.cmdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemPromptCommandDialog.this.validateInput();
            }
        });
        return composite_prompts;
    }

    protected Control getInitialFocusControl() {
        return this.cmdText;
    }

    protected boolean processOK() {
        this.newCmdString = this.cmdText.getText().trim();
        boolean closeDialog = this.verify();
        if (closeDialog) {
            this.setOutputObject(this.newCmdString);
        }
        return closeDialog;
    }

    public boolean verify() {
        return this.errorMessage == null;
    }

    protected SystemMessage validateInput() {
        this.setPageComplete();
        return this.errorMessage;
    }

    public boolean isPageComplete() {
        boolean pageComplete = false;
        if (this.errorMessage == null) {
            String theNewCmd = this.cmdText.getText().trim();
            pageComplete = theNewCmd.length() > 0;
        }
        return pageComplete;
    }

    public void setPageComplete() {
        this.setPageComplete(this.isPageComplete());
    }

    public String getCommand() {
        return this.newCmdString;
    }
}

