/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.ISystemMassager;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ISystemValidatorUniqueString;
import org.eclipse.rse.ui.validators.ValidatorSourceType;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemNewCompileSrcTypeDialog
extends SystemPromptDialog {
    protected Text srcTypeText;
    protected SystemCompileManager manager;
    protected ISystemValidator srcTypeValidator;
    protected ISystemMassager srcTypeMassager;
    protected boolean caseSensitive;
    protected String[] existingTypes;
    protected String newSrcType;
    protected SystemMessage errorMessage;
    protected boolean ignoreEvents;
    protected String mriVerbageLabel;
    protected String mriPromptLabel;
    protected String mriPromptTooltip;

    public SystemNewCompileSrcTypeDialog(Shell shell, SystemCompileManager compileManager, boolean caseSensitive) {
        this(shell, compileManager, caseSensitive, SystemUDAResources.RESID_COMPILE_NEWSRCTYPE_TITLE);
    }

    public SystemNewCompileSrcTypeDialog(Shell shell, SystemCompileManager compileManager, boolean caseSensitive, String title) {
        super(shell, title);
        this.manager = compileManager;
        this.caseSensitive = caseSensitive;
        this.setMRI(SystemUDAResources.RESID_COMPILE_NEWSRCTYPE_VERBAGE_LABEL, SystemUDAResources.RESID_COMPILE_NEWSRCTYPE_PROMPT_LABEL, SystemUDAResources.RESID_COMPILE_NEWSRCTYPE_PROMPT_TOOLTIP);
    }

    public void setMRI(String verbageMRILabel, String promptMRILabel, String promptMRITooltip) {
        if (verbageMRILabel != null) {
            this.mriVerbageLabel = verbageMRILabel;
        }
        if (promptMRILabel != null) {
            this.mriPromptLabel = promptMRILabel;
        }
        if (promptMRITooltip != null) {
            this.mriPromptTooltip = promptMRITooltip;
        }
    }

    public void setSrcTypeValidator(ISystemValidator validator) {
        this.srcTypeValidator = validator;
        if (this.existingTypes != null && this.srcTypeValidator instanceof ISystemValidatorUniqueString) {
            ((ISystemValidatorUniqueString)this.srcTypeValidator).setExistingNamesList(this.existingTypes);
        }
    }

    public void setExistingSrcTypes(String[] srcTypes) {
        this.existingTypes = srcTypes;
        if (this.srcTypeValidator != null && this.srcTypeValidator instanceof ISystemValidatorUniqueString) {
            ((ISystemValidatorUniqueString)this.srcTypeValidator).setExistingNamesList(this.existingTypes);
        }
    }

    public void setSrcTypeMassager(ISystemMassager massager) {
        this.srcTypeMassager = massager;
    }

    protected Control createInner(Composite parent) {
        if (this.srcTypeValidator == null) {
            this.setSrcTypeValidator((ISystemValidator)new ValidatorSourceType(this.caseSensitive));
        }
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        SystemWidgetHelpers.createVerbiage((Composite)composite_prompts, (String)this.mriVerbageLabel, (int)nbrColumns, (boolean)false, (int)250);
        this.srcTypeText = SystemWidgetHelpers.createLabeledTextField((Composite)composite_prompts, null, (String)this.mriPromptLabel, (String)this.mriPromptTooltip);
        this.srcTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemNewCompileSrcTypeDialog.this.validateInput();
            }
        });
        this.setPageComplete(false);
        return composite_prompts;
    }

    protected Control getInitialFocusControl() {
        return this.srcTypeText;
    }

    protected boolean processOK() {
        boolean closeDialog;
        this.newSrcType = this.srcTypeText.getText().trim();
        if (this.srcTypeMassager != null) {
            this.newSrcType = this.srcTypeMassager.massage(this.newSrcType);
            this.ignoreEvents = true;
            this.srcTypeText.setText(this.newSrcType);
            this.ignoreEvents = false;
        }
        if (closeDialog = this.verify()) {
            this.setOutputObject(this.newSrcType);
        }
        return closeDialog;
    }

    public boolean verify() {
        this.errorMessage = this.validateInput();
        if (this.errorMessage == null) {
            this.clearErrorMessage();
        } else {
            this.srcTypeText.setFocus();
            this.setErrorMessage(this.errorMessage);
        }
        return this.errorMessage == null;
    }

    protected SystemMessage validateInput() {
        if (this.ignoreEvents) {
            return this.errorMessage;
        }
        this.errorMessage = null;
        if (this.srcTypeValidator != null) {
            this.errorMessage = this.srcTypeValidator.validate(this.srcTypeText.getText().trim());
        }
        if (this.errorMessage != null) {
            this.setErrorMessage(this.errorMessage);
        } else {
            this.clearErrorMessage();
        }
        this.setPageComplete();
        return this.errorMessage;
    }

    public boolean isPageComplete() {
        boolean pageComplete = false;
        if (this.errorMessage == null) {
            pageComplete = this.srcTypeText.getText().trim().length() > 0;
        }
        return pageComplete;
    }

    public void setPageComplete() {
        this.setPageComplete(this.isPageComplete());
    }

    public String getNewSrcType() {
        return this.newSrcType;
    }
}

