/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDAEditPaneHoster;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDWorkWithDialog;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionEditPane;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionSubsystem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionTreeView;
import org.eclipse.rse.internal.useractions.ui.uda.SystemXMLElementWrapper;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.widgets.SystemEditPaneStateMachine;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SystemWorkWithUDAsDialog
extends SystemPromptDialog
implements ISystemUDWorkWithDialog,
ISystemUDAEditPaneHoster,
Listener,
SelectionListener,
Runnable {
    protected Shell shell;
    protected Label labelProfile;
    protected Label labelProfileValue;
    protected Combo profileCombo;
    protected SystemUDActionTreeView treeView;
    protected int prevProfileComboSelection = 0;
    protected ISubSystem subsystem;
    protected ISubSystemConfiguration subsystemFactory;
    protected SystemUDActionSubsystem udaActionSubsystem;
    protected ISystemProfile[] systemProfiles;
    protected ISystemProfile currentProfile;
    protected SystemUDActionEditPane editpane;
    protected Button applyButton;
    protected Button revertButton;
    protected SystemEditPaneStateMachine sm;

    public SystemWorkWithUDAsDialog(Shell shell, ISubSystem ss, SystemUDActionSubsystem udaActionSubsystem) {
        super(shell, SystemUDAResources.RESID_WORKWITH_UDAS_TITLE);
        this.setCancelButtonLabel(SystemUDAResources.BUTTON_CLOSE);
        this.setShowOkButton(false);
        this.shell = shell;
        this.subsystem = ss;
        this.subsystemFactory = ss.getSubSystemConfiguration();
        this.udaActionSubsystem = udaActionSubsystem;
        this.setProfiles(RSECorePlugin.getTheSystemProfileManager().getActiveSystemProfiles(), this.subsystem.getSystemProfile());
        this.setHelp();
    }

    public SystemWorkWithUDAsDialog(Shell shell, ISubSystemConfiguration ssFactory, ISystemProfile profile, SystemUDActionSubsystem udaActionSubsystem) {
        super(shell, SystemUDAResources.RESID_WORKWITH_UDAS_TITLE);
        this.setCancelButtonLabel(SystemUDAResources.BUTTON_CLOSE);
        this.setShowOkButton(false);
        this.shell = shell;
        this.subsystemFactory = ssFactory;
        this.udaActionSubsystem = udaActionSubsystem;
        this.setProfiles(RSECorePlugin.getTheSystemProfileManager().getActiveSystemProfiles(), profile);
        this.setHelp();
    }

    protected void setHelp() {
        this.setHelp("org.eclipse.rse.ui.wwua0000");
    }

    public void setProfiles(ISystemProfile[] profiles, ISystemProfile profile) {
        if (profiles == null) {
            profiles = new ISystemProfile[]{};
        }
        this.systemProfiles = profiles;
        this.currentProfile = profile;
        this.initProfileCombo();
    }

    protected Control getInitialFocusControl() {
        return null;
    }

    protected SystemUDActionSubsystem getUDActionSubsystem() {
        return this.udaActionSubsystem;
    }

    protected Control createInner(Composite parent) {
        Control c;
        GridData data;
        int nbrColumns = 2;
        Composite composite = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        Composite profileComposite = SystemWidgetHelpers.createFlushComposite((Composite)composite, (int)2);
        ((GridData)profileComposite.getLayoutData()).horizontalSpan = nbrColumns;
        String temp = SystemWidgetHelpers.appendColon((String)SystemUDAResources.RESID_UDA_PROFILE_LABEL);
        this.labelProfile = SystemWidgetHelpers.createLabel((Composite)profileComposite, (String)temp);
        this.labelProfile.setToolTipText(SystemUDAResources.RESID_UDA_PROFILE_TOOLTIP);
        this.profileCombo = SystemWidgetHelpers.createReadonlyCombo((Composite)profileComposite, null, (String)SystemUDAResources.RESID_UDA_PROFILE_TOOLTIP);
        if (this.currentProfile != null) {
            this.getUDActionSubsystem().getUDActionManager().setCurrentProfile(this.currentProfile);
        }
        if (this.subsystem != null) {
            this.treeView = new SystemUDActionTreeView(composite, (ISystemUDWorkWithDialog)this, this.subsystem, this.udaActionSubsystem);
        }
        if ((data = (GridData)(c = this.treeView.getControl()).getLayoutData()) == null) {
            data = new GridData();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        data.widthHint = 140;
        data.heightHint = this.publicConvertHeightInCharsToPixels(12);
        c.setLayoutData((Object)data);
        Composite rightSideComposite = SystemWidgetHelpers.createFlushComposite((Composite)composite, (int)1);
        this.editpane = this.subsystem != null ? this.getUDActionSubsystem().getCustomUDActionEditPane(this.subsystem, this, this.treeView) : this.getUDActionSubsystem().getCustomUDActionEditPane(this.subsystemFactory, this.currentProfile, this, this.treeView);
        this.editpane.createContents(rightSideComposite);
        this.addSeparatorLine(rightSideComposite, 1);
        int nbrColumns_buttonComposite = 4;
        Composite applyResetButtonComposite = SystemWidgetHelpers.createFlushComposite((Composite)rightSideComposite, (int)nbrColumns_buttonComposite);
        Label filler = SystemWidgetHelpers.createLabel((Composite)applyResetButtonComposite, (String)"");
        ((GridData)filler.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)filler.getLayoutData()).horizontalAlignment = 4;
        this.applyButton = SystemWidgetHelpers.createPushButton((Composite)applyResetButtonComposite, (Listener)this, (String)SystemUDAResources.RESID_UDA_APPLY_BUTTON_LABEL, (String)SystemUDAResources.RESID_UDA_APPLY_BUTTON_TOOLTIP);
        this.revertButton = SystemWidgetHelpers.createPushButton((Composite)applyResetButtonComposite, (Listener)this, (String)SystemUDAResources.RESID_UDA_REVERT_BUTTON_LABEL, (String)SystemUDAResources.RESID_UDA_REVERT_BUTTON_TOOLTIP);
        this.addGrowableFillerLine(rightSideComposite, 1);
        this.initProfileCombo();
        this.sm = new SystemEditPaneStateMachine(rightSideComposite, this.applyButton, this.revertButton);
        this.editpane.setStateMachine(this.sm);
        this.profileCombo.addSelectionListener((SelectionListener)this);
        this.treeView.addSelectionChangedListener(this.editpane);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SystemWorkWithUDAsDialog.this.getUDActionSubsystem().getUDActionManager().setCurrentProfile(null);
            }
        });
        this.treeView.getControl().addMouseListener((MouseListener)this.editpane);
        this.treeView.getControl().addKeyListener((KeyListener)this.editpane);
        composite.layout(true);
        rightSideComposite.setVisible(false);
        this.treeView.expandDomainNodes();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getShell().setDefaultButton(this.applyButton);
    }

    private void initProfileCombo() {
        if (this.profileCombo != null && this.systemProfiles != null && this.systemProfiles.length > 0) {
            String[] names = new String[this.systemProfiles.length];
            int selIdx = 0;
            int idx = 0;
            while (idx < names.length) {
                names[idx] = this.systemProfiles[idx].getName();
                if (this.currentProfile != null && this.currentProfile == this.systemProfiles[idx]) {
                    selIdx = idx;
                }
                ++idx;
            }
            this.profileCombo.setItems(names);
            this.profileCombo.setText(names[selIdx]);
            this.prevProfileComboSelection = selIdx;
        }
    }

    public void setPageComplete(boolean complete) {
        if (this.applyButton != null && !complete) {
            this.applyButton.setEnabled(false);
        }
    }

    protected boolean processCancel() {
        if (this.sm.isSaveRequired()) {
            if (!this.editpane.validateInput(true, null)) {
                this.sm.setChangesMade();
                return false;
            }
            this.editpane.saveData();
        }
        return super.processCancel();
    }

    public void handleEvent(Event e) {
        this.clearMessage();
        Widget source = e.widget;
        if (source == this.applyButton) {
            this.processApply();
        } else if (source == this.revertButton) {
            this.processRevert();
        }
    }

    public void processApply() {
        this.editpane.applyPressed();
    }

    public void processRevert() {
        this.editpane.revertPressed();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        Object src = event.getSource();
        if (src == this.profileCombo) {
            if (this.editpane.areErrorsPending()) {
                this.profileCombo.getDisplay().asyncExec((Runnable)this);
                return;
            }
            if (this.sm.isSaveRequired()) {
                if (!this.editpane.validateInput(true, null)) {
                    this.sm.setChangesMade();
                    this.profileCombo.getDisplay().asyncExec((Runnable)this);
                    return;
                }
                this.editpane.saveData();
            }
            this.sm.applyPressed();
            int idx = this.profileCombo.getSelectionIndex();
            if (idx < 0) {
                idx = 0;
            }
            this.prevProfileComboSelection = idx;
            this.currentProfile = this.systemProfiles[idx];
            this.getUDActionSubsystem().getUDActionManager().setCurrentProfile(this.currentProfile);
            this.treeView.clearClipboard();
            this.treeView.setInput("0");
            this.treeView.expandDomainNodes();
        }
    }

    public void run() {
        this.profileCombo.select(this.prevProfileComboSelection);
        super.run();
    }

    public boolean canDelete(Object selectedObject) {
        return this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isSelectionVendorSupplied();
    }

    public boolean canMoveUp(Object selectedObject) {
        boolean can;
        boolean bl = can = this.sm.getMode() == 8 && !this.sm.areChangesPending();
        if (can) {
            TreeItem selectedItem = this.treeView.getSelectedTreeItem();
            TreeItem parentItem = selectedItem.getParentItem();
            if (parentItem != null) {
                can = parentItem.getItems()[0] != selectedItem;
            } else {
                TreeItem[] roots = this.treeView.getTree().getItems();
                int idx = 0;
                while (idx < roots.length) {
                    if (roots[idx].getData() instanceof SystemXMLElementWrapper) {
                        can = roots[idx] != selectedItem;
                        break;
                    }
                    ++idx;
                }
            }
        }
        return can;
    }

    public boolean canMoveDown(Object selectedObject) {
        boolean can;
        boolean bl = can = this.sm.getMode() == 8 && !this.sm.areChangesPending();
        if (can) {
            TreeItem[] roots;
            TreeItem selectedItem = this.treeView.getSelectedTreeItem();
            TreeItem parentItem = selectedItem.getParentItem();
            can = parentItem != null ? parentItem.getItems()[parentItem.getItemCount() - 1] != selectedItem : (roots = this.treeView.getTree().getItems())[roots.length - 1] != selectedItem;
        }
        return can;
    }

    public boolean canCopy(Object selectedObject) {
        boolean can = this.sm.getMode() == 8 && !this.sm.areChangesPending();
        return can;
    }

    protected boolean isSelectionVendorSupplied() {
        SystemXMLElementWrapper selectedElement = this.treeView.getSelectedElement();
        if (selectedElement != null) {
            String vendor = selectedElement.getVendor();
            return vendor != null && vendor.length() > 0;
        }
        return false;
    }

    protected String getVendorOfSelection() {
        String vendor;
        SystemXMLElementWrapper selectedElement = this.treeView.getSelectedElement();
        if (selectedElement != null && (vendor = selectedElement.getVendor()) != null && vendor.length() > 0) {
            return vendor;
        }
        return null;
    }

    public boolean areChangesPending() {
        return this.sm.areChangesPending();
    }
}

