/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.command;

import java.util.Optional;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.util.GMFNotationUtilities;

public class TreeLayoutSetConnectionAnchorsCommand
extends SetConnectionAnchorsCommand {
    Point sourceRefPoint;
    Point targetRefPoint;
    PointList connectionPointList;

    public TreeLayoutSetConnectionAnchorsCommand(TransactionalEditingDomain editingDomain, String label) {
        super(editingDomain, label);
    }

    protected void setComplementaryData(boolean sourceAnchorChanged, boolean targetAnchorChanged) {
        if (this.getEdgeAdaptor() instanceof ConnectionEditPart) {
            EditPart editPart;
            Connection connection = ((ConnectionEditPart)this.getEdgeAdaptor()).getConnectionFigure();
            Edge edge = (Edge)this.getEdgeAdaptor().getAdapter(Edge.class);
            if (sourceAnchorChanged || connection.getSourceAnchor() == null) {
                editPart = ((ConnectionEditPart)this.getEdgeAdaptor()).getSource();
                Rectangle sourceBounds = null;
                if (editPart instanceof GraphicalEditPart) {
                    sourceBounds = ((GraphicalEditPart)editPart).getFigure().getBounds();
                } else {
                    Optional<Rectangle> optionalSourceBounds = GMFHelper.getAbsoluteBounds(edge.getSource());
                    if (optionalSourceBounds.isPresent()) {
                        sourceBounds = optionalSourceBounds.get();
                    }
                }
                if (sourceBounds != null) {
                    PrecisionPoint sourceAnchorReference = edge.getSourceAnchor() instanceof IdentityAnchor ? BaseSlidableAnchor.parseTerminalString((String)((IdentityAnchor)edge.getSourceAnchor()).getId()) : new PrecisionPoint(0.5, 0.5);
                    this.sourceRefPoint = new PrecisionPoint((double)sourceBounds.x + (double)sourceBounds.width * sourceAnchorReference.preciseX(), (double)sourceBounds.y + (double)sourceBounds.height * sourceAnchorReference.preciseY());
                }
            } else {
                this.sourceRefPoint = connection.getSourceAnchor().getReferencePoint();
                connection.translateToRelative((Translatable)this.sourceRefPoint);
            }
            if (targetAnchorChanged || connection.getTargetAnchor() == null) {
                editPart = ((ConnectionEditPart)this.getEdgeAdaptor()).getTarget();
                Rectangle targetBounds = null;
                if (editPart instanceof GraphicalEditPart) {
                    targetBounds = ((GraphicalEditPart)editPart).getFigure().getBounds();
                } else {
                    Optional<Rectangle> optionalTargetBounds = GMFHelper.getAbsoluteBounds(edge.getTarget());
                    if (optionalTargetBounds.isPresent()) {
                        targetBounds = optionalTargetBounds.get();
                    }
                }
                if (targetBounds != null) {
                    PrecisionPoint targetAnchorReference = edge.getTargetAnchor() instanceof IdentityAnchor ? BaseSlidableAnchor.parseTerminalString((String)((IdentityAnchor)edge.getTargetAnchor()).getId()) : new PrecisionPoint(0.5, 0.5);
                    this.targetRefPoint = new PrecisionPoint((double)targetBounds.x + (double)targetBounds.width * targetAnchorReference.preciseX(), (double)targetBounds.y + (double)targetBounds.height * targetAnchorReference.preciseY());
                }
            } else {
                this.targetRefPoint = connection.getTargetAnchor().getReferencePoint();
                connection.translateToRelative((Translatable)this.targetRefPoint);
            }
            this.connectionPointList = connection.getPoints().getCopy();
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        assert (this.getEdgeAdaptor() != null) : Messages.TreeLayoutSetConnectionAnchorsCommand_nullChildInSetConnectionAnchorsCommand;
        Edge edge = (Edge)this.getEdgeAdaptor().getAdapter(Edge.class);
        assert (edge != null) : Messages.TreeLayoutSetConnectionAnchorsCommand_nullEdgeInSetConnectionAnchorsCommand;
        IdentityAnchor oldSourceAnchor = null;
        if (edge.getSourceAnchor() instanceof IdentityAnchor) {
            oldSourceAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
            oldSourceAnchor.setId(((IdentityAnchor)edge.getSourceAnchor()).getId());
        }
        IdentityAnchor oldTargetAnchor = null;
        if (edge.getTargetAnchor() instanceof IdentityAnchor) {
            oldTargetAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
            oldTargetAnchor.setId(((IdentityAnchor)edge.getTargetAnchor()).getId());
        }
        boolean newSourceAnchor = false;
        if (this.getNewSourceTerminal() != null) {
            if (this.getNewSourceTerminal().length() == 0) {
                edge.setSourceAnchor(null);
            } else if (oldSourceAnchor == null) {
                IdentityAnchor sourceAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
                sourceAnchor.setId(this.getNewSourceTerminal());
                edge.setSourceAnchor((Anchor)sourceAnchor);
                newSourceAnchor = true;
            } else {
                IdentityAnchor a = (IdentityAnchor)edge.getSourceAnchor();
                if (a == null) {
                    a = NotationFactory.eINSTANCE.createIdentityAnchor();
                }
                a.setId(this.getNewSourceTerminal());
                edge.setSourceAnchor((Anchor)a);
                newSourceAnchor = true;
            }
        }
        boolean newTargetAnchor = false;
        if (this.getNewTargetTerminal() != null) {
            if (this.getNewTargetTerminal().length() == 0) {
                edge.setTargetAnchor(null);
            } else if (oldTargetAnchor == null) {
                IdentityAnchor targetAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
                targetAnchor.setId(this.getNewTargetTerminal());
                edge.setTargetAnchor((Anchor)targetAnchor);
                newTargetAnchor = true;
            } else {
                IdentityAnchor targetAnchor = (IdentityAnchor)edge.getTargetAnchor();
                targetAnchor.setId(this.getNewTargetTerminal());
                newTargetAnchor = true;
            }
        }
        this.setComplementaryData(newSourceAnchor, newTargetAnchor);
        if (newSourceAnchor || newTargetAnchor) {
            GMFNotationUtilities.setGMFBendpoints(edge, this.connectionPointList, this.sourceRefPoint, this.targetRefPoint);
            GMFNotationUtilities.setBrothersAnchorAndBendpointsAccordingToEdge(edge);
        }
        return CommandResult.newOKCommandResult();
    }
}

