/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.compress;

import java.util.ArrayList;
import org.eclipse.swtchart.internal.compress.Compress;

public class CompressScatterSeries
extends Compress {
    private boolean isLineVisible;
    private boolean[][] occupied;

    @Override
    protected void addNecessaryPlots(ArrayList<Double> xList, ArrayList<Double> yList, ArrayList<Integer> indexList) {
        if (this.isLineVisible) {
            int i = 0;
            while (i < this.xSeries.length && i < this.ySeries.length) {
                if (!this.isInSameGridAsPrevious(this.xSeries[i], this.ySeries[i])) {
                    this.addToList(xList, yList, indexList, this.xSeries[i], this.ySeries[i], i);
                }
                ++i;
            }
        } else {
            int width = (int)this.config.getWidthInPixel();
            int height = (int)this.config.getHeightInPixel();
            if (width <= 0 || height <= 0) {
                return;
            }
            this.occupied = new boolean[width][height];
            int i = 0;
            while (i < this.xSeries.length && i < this.ySeries.length) {
                if (this.xSeries[i] >= this.xLower && this.xSeries[i] <= this.xUpper && this.ySeries[i] >= this.yLower && this.ySeries[i] <= this.yUpper && !this.isOccupied(this.xSeries[i], this.ySeries[i])) {
                    this.addToList(xList, yList, indexList, this.xSeries[i], this.ySeries[i], i);
                }
                ++i;
            }
        }
    }

    private boolean isOccupied(double x, double y) {
        int yGridIndex;
        int xGridIndex;
        double upper;
        double lower;
        if (this.config.isXLogScale()) {
            lower = Math.log10(this.config.getXLowerValue());
            upper = Math.log10(this.config.getXUpperValue());
            xGridIndex = (int)((Math.log10(x) - lower) / (upper - lower) * (double)this.config.getWidthInPixel());
        } else {
            xGridIndex = (int)((x - this.config.getXLowerValue()) / (this.config.getXUpperValue() - this.config.getXLowerValue()) * (double)this.config.getWidthInPixel());
        }
        if (this.config.isYLogScale()) {
            lower = Math.log10(this.config.getYLowerValue());
            upper = Math.log10(this.config.getYUpperValue());
            yGridIndex = (int)((Math.log10(y) - lower) / (upper - lower) * (double)this.config.getHeightInPixel());
        } else {
            yGridIndex = (int)((y - this.config.getYLowerValue()) / (this.config.getYUpperValue() - this.config.getYLowerValue()) * (double)this.config.getHeightInPixel());
        }
        boolean isOccupied = this.occupied[xGridIndex][yGridIndex];
        this.occupied[xGridIndex][yGridIndex] = true;
        return isOccupied;
    }

    public void setLineVisible(boolean visible) {
        this.isLineVisible = visible;
    }
}

