/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.registry;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.tm4e.languageconfiguration.internal.registry.AbstractLanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.osgi.service.prefs.BackingStoreException;

class WorkingCopyLanguageConfigurationRegistryManager
extends AbstractLanguageConfigurationRegistryManager
implements ILanguageConfigurationRegistryManager.EditSession {
    private final LanguageConfigurationRegistryManager manager;
    private final Set<ILanguageConfigurationDefinition> added = new HashSet<ILanguageConfigurationDefinition>();
    private final Set<ILanguageConfigurationDefinition> removed = new HashSet<ILanguageConfigurationDefinition>();
    private boolean isDirty = false;

    WorkingCopyLanguageConfigurationRegistryManager(LanguageConfigurationRegistryManager manager) {
        this.manager = manager;
        this.reset();
    }

    @Override
    public void reset() {
        this.pluginDefinitions.clear();
        this.pluginDefinitions.putAll(this.manager.pluginDefinitions);
        this.userDefinitions.clear();
        this.userDefinitions.putAll(this.manager.userDefinitions);
        this.added.clear();
        this.removed.clear();
        this.isDirty = false;
    }

    @Override
    public void registerLanguageConfigurationDefinition(ILanguageConfigurationDefinition definition) {
        super.registerLanguageConfigurationDefinition(definition);
        this.removed.remove(definition);
        this.added.add(definition);
        this.isDirty = true;
    }

    @Override
    public void unregisterLanguageConfigurationDefinition(ILanguageConfigurationDefinition definition) {
        super.unregisterLanguageConfigurationDefinition(definition);
        this.added.remove(definition);
        this.removed.add(definition);
        this.isDirty = true;
    }

    @Override
    public void save() throws BackingStoreException {
        if (!this.isDirty) {
            return;
        }
        this.removed.forEach(this.manager::unregisterLanguageConfigurationDefinition);
        this.added.forEach(this.manager::registerLanguageConfigurationDefinition);
        this.manager.save();
        this.reset();
    }
}

