/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.gdbtrace.core.trace;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.GDBTraceControl_7_2;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointDMData;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.gdbtrace.core.GdbTraceCorePlugin;
import org.eclipse.tracecompass.internal.gdbtrace.core.event.GdbTraceEvent;
import org.eclipse.tracecompass.internal.gdbtrace.core.event.GdbTraceEventContent;
import org.eclipse.tracecompass.internal.gdbtrace.core.trace.GdbTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class DsfGdbAdaptor {
    private static final Object SESSION_LOCK = new Object();
    private static final String INTERRUPTION_EXCEPTION = "Interruption exception";
    private static final String GDB_EXCEPTION = "GDB exception";
    private static final String REQUEST_REJECTED_EXCEPTION = "Request rejected exception";
    private static final String TIMEOUT = "Timeout";
    private GdbTrace fGdbTrace;
    private int fNumberOfFrames = 0;
    private boolean fIsTimeoutEnabled;
    private int fTimeout;
    private ILaunch fLaunch;
    private boolean isTerminating;
    private DsfSession fDsfSession = null;
    private String fSessionId;
    private String tracedExecutable = "";
    private String gdb72Executable = "";
    private String fTraceFilePath = "";
    private String fTraceFile = "";
    private String sourceLocator = "";
    private Map<Integer, MIBreakpointDMData> fTpInfo = new HashMap<Integer, MIBreakpointDMData>();
    private TmfEventType tmfEventType = new TmfEventType("GDB Tracepoint", TmfEventField.makeRoot((String[])new String[]{"Content"}));

    public DsfGdbAdaptor(GdbTrace trace, String gdbExec, String traceFile, String tracedExecutable) {
        new DsfGdbPlatformEventListener();
        this.fGdbTrace = trace;
        this.gdb72Executable = gdbExec;
        this.fTraceFilePath = traceFile;
        this.fTraceFile = traceFile.substring(traceFile.lastIndexOf(47) + 1);
        this.tracedExecutable = tracedExecutable;
        try {
            this.launchDGBPostMortemTrace();
        }
        catch (CoreException e) {
            GdbTraceCorePlugin.logError(e.getMessage(), e);
        }
    }

    private void launchDGBPostMortemTrace() throws CoreException {
        this.fIsTimeoutEnabled = Platform.getPreferencesService().getBoolean("org.eclipse.cdt.dsf.gdb", "org.eclipse.cdt.dsf.gdb.commandTimeout", false, null);
        if (this.fIsTimeoutEnabled) {
            this.fTimeout = Platform.getPreferencesService().getInt("org.eclipse.cdt.dsf.gdb", "org.eclipse.cdt.dsf.gdb.commandTimeoutValue", 10000, null);
        }
        ILaunchConfigurationType configType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.cdt.launch.postmortemLaunchType");
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.fTraceFile);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.gdb72Executable);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.POST_MORTEM_TYPE", "TRACE_FILE");
        wc.setAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 0);
        wc.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", this.fTraceFilePath);
        wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "core");
        wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.tracedExecutable);
        wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        if (!this.sourceLocator.isEmpty()) {
            wc.setAttribute("org.eclipse.debug.core.source_locator_memento", this.sourceLocator);
        }
        this.fLaunch = wc.doSave().launch("debug", null);
        this.isTerminating = false;
        if (this.fLaunch instanceof GdbLaunch) {
            this.fSessionId = ((GdbLaunch)this.fLaunch).getSession().getId();
        }
        this.fDsfSession = ((GdbLaunch)this.fLaunch).getSession();
        this.fDsfSession.addServiceEventListener((Object)this, null);
        this.fNumberOfFrames = this.findNumFrames();
    }

    public void dispose() {
        if (this.fLaunch != null && this.fLaunch.canTerminate() && !this.isTerminating) {
            this.isTerminating = true;
            try {
                this.fLaunch.terminate();
            }
            catch (DebugException e) {
                GdbTraceCorePlugin.logError(e.getMessage(), e);
            }
            this.fLaunch = null;
        }
    }

    public int getNumberOfFrames() {
        if (this.fNumberOfFrames == 0) {
            this.fNumberOfFrames = this.findNumFrames();
        }
        return this.fNumberOfFrames;
    }

    public synchronized GdbTraceEvent selectAndReadFrame(long rank) {
        GdbTraceEvent event;
        long ts;
        if (this.fTpInfo.isEmpty()) {
            this.getTracepointInfo();
        }
        if (this.selectDataFrame(rank, false) && (ts = (event = this.getTraceFrameData(rank)).getTimestamp().getValue()) == rank) {
            return event;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private void getTracepointInfo() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private synchronized int findNumFrames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean selectDataFrame(long rank, boolean update) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private GdbTraceEvent getTraceFrameData(long rank) {
        if (DsfSession.getSession((String)this.fSessionId) == null) {
            return null;
        }
        final DsfExecutor executor = DsfSession.getSession((String)this.fSessionId).getExecutor();
        final DsfServicesTracker tracker = new DsfServicesTracker(GdbTraceCorePlugin.getBundleContext(), this.fSessionId);
        Query<IGDBTraceControl.ITraceRecordDMData> getFrameDataQuery = new Query<IGDBTraceControl.ITraceRecordDMData>(){

            public void execute(final DataRequestMonitor<IGDBTraceControl.ITraceRecordDMData> rm) {
                final IGDBTraceControl traceControl = (IGDBTraceControl)tracker.getService(IGDBTraceControl.class);
                ICommandControlService commandControl = (ICommandControlService)tracker.getService(ICommandControlService.class);
                if (commandControl == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Could not find necessary services", null));
                    rm.done();
                    return;
                }
                IGDBTraceControl.ITraceTargetDMContext dmc = (IGDBTraceControl.ITraceTargetDMContext)commandControl.getContext();
                if (traceControl != null) {
                    traceControl.getCurrentTraceRecordContext(dmc, (DataRequestMonitor)new DataRequestMonitor<IGDBTraceControl.ITraceRecordDMContext>((Executor)executor, rm){

                        protected void handleSuccess() {
                            traceControl.getTraceRecordData((IGDBTraceControl.ITraceRecordDMContext)this.getData(), rm);
                        }
                    });
                } else {
                    rm.done();
                }
            }
        };
        try {
            GdbTraceEvent ev;
            MIBreakpointDMData bp;
            executor.execute((Runnable)getFrameDataQuery);
            IGDBTraceControl.ITraceRecordDMData data = this.fIsTimeoutEnabled ? (IGDBTraceControl.ITraceRecordDMData)getFrameDataQuery.get((long)this.fTimeout, TimeUnit.MILLISECONDS) : (IGDBTraceControl.ITraceRecordDMData)getFrameDataQuery.get();
            if (data == null) {
                return null;
            }
            String ts = data.getTimestamp();
            if (ts == null) {
                ts = "0";
            }
            Object tmfEventRef = (bp = this.fTpInfo.get(Integer.valueOf(data.getTracepointNumber()))) != null ? bp.getFileName() + ":" + bp.getLineNumber() + " :: " + bp.getFunctionName() : this.tracedExecutable;
            GdbTraceEventContent evContent = new GdbTraceEventContent(data.getContent(), Integer.parseInt(data.getTracepointNumber()), Integer.parseInt(data.getRecordId()));
            GdbTraceEvent gdbTraceEvent = ev = new GdbTraceEvent(this.fGdbTrace, TmfTimestamp.fromSeconds((long)Integer.parseInt(data.getRecordId())), "Tracepoint: " + data.getTracepointNumber() + ", Frame: " + data.getRecordId(), (ITmfEventType)this.tmfEventType, evContent, (String)tmfEventRef);
            return gdbTraceEvent;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            GdbTraceEvent gdbTraceEvent = this.createExceptionEvent(rank, INTERRUPTION_EXCEPTION);
            return gdbTraceEvent;
        }
        catch (ExecutionException e) {
            GdbTraceEvent gdbTraceEvent = this.createExceptionEvent(rank, GDB_EXCEPTION);
            return gdbTraceEvent;
        }
        catch (RejectedExecutionException e) {
            GdbTraceEvent gdbTraceEvent = this.createExceptionEvent(rank, REQUEST_REJECTED_EXCEPTION);
            return gdbTraceEvent;
        }
        catch (TimeoutException e) {
            GdbTraceEvent gdbTraceEvent = this.createExceptionEvent(rank, TIMEOUT);
            return gdbTraceEvent;
        }
        finally {
            tracker.dispose();
        }
    }

    private GdbTraceEvent createExceptionEvent(long rank, String message) {
        Object tmfEventSrc;
        Object tmfEventRef;
        MIBreakpointDMData bp = this.fTpInfo.get((int)rank);
        if (bp != null) {
            tmfEventRef = bp.getFileName() + ":" + bp.getLineNumber() + " :: " + bp.getFunctionName();
            tmfEventSrc = bp.getFileName() + " :: " + bp.getFunctionName() + ", line: " + bp.getLineNumber();
        } else {
            tmfEventRef = this.tracedExecutable;
            tmfEventSrc = "Tracepoint: n/a";
        }
        GdbTraceEventContent evContent = new GdbTraceEventContent("ERROR: " + message, 0, 0);
        GdbTraceEvent ev = new GdbTraceEvent(this.fGdbTrace, TmfTimestamp.fromSeconds((long)rank), (String)tmfEventSrc, (ITmfEventType)this.tmfEventType, evContent, (String)tmfEventRef);
        return ev;
    }

    public String getSessionId() {
        return this.fSessionId;
    }

    @DsfServiceEventHandler
    public void handleDSFRecordSelectedEvents(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent event) {
        GDBTraceControl_7_2.TraceRecordSelectedChangedEvent traceEvent;
        IGDBTraceControl.ITraceRecordDMContext context;
        String reference;
        if (event instanceof GDBTraceControl_7_2.TraceRecordSelectedChangedEvent && (reference = (context = (IGDBTraceControl.ITraceRecordDMContext)(traceEvent = (GDBTraceControl_7_2.TraceRecordSelectedChangedEvent)event).getDMContext()).getRecordId()) != null) {
            int recordId = Integer.parseInt(reference);
            DsfGdbAdaptor.selectGdbTraceEditor(context.getSessionId(), recordId);
        }
    }

    private static void closeGdbTraceEditor(String sessionId) {
        Display.getDefault().asyncExec(() -> {
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = wbWindow.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage wbPage = iWorkbenchPageArray[n4];
                    IEditorReference[] iEditorReferenceArray = wbPage.getEditorReferences();
                    int n5 = iEditorReferenceArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ITmfTrace trace;
                        IEditorReference editorReference = iEditorReferenceArray[n6];
                        IEditorPart editor = editorReference.getEditor(false);
                        if (editor instanceof ITmfTraceEditor && (trace = ((ITmfTraceEditor)editor).getTrace()) instanceof GdbTrace && Objects.equals(((GdbTrace)trace).getDsfSessionId(), sessionId)) {
                            wbPage.closeEditor(editor, false);
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        });
    }

    private static void selectGdbTraceEditor(String sessionId, int recordId) {
        Display.getDefault().asyncExec(() -> {
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n2 = iWorkbenchWindowArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n3];
                IWorkbenchPage[] iWorkbenchPageArray = wbWindow.getPages();
                int n4 = iWorkbenchPageArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    IWorkbenchPage wbPage = iWorkbenchPageArray[n5];
                    IEditorReference[] iEditorReferenceArray = wbPage.getEditorReferences();
                    int n6 = iEditorReferenceArray.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        IEditorReference editorReference = iEditorReferenceArray[n7];
                        IEditorPart editor = editorReference.getEditor(false);
                        if (editor instanceof ITmfTraceEditor) {
                            ITmfTrace trace = ((ITmfTraceEditor)editor).getTrace();
                            if (trace instanceof GdbTrace) {
                                if (Objects.equals(((GdbTrace)trace).getDsfSessionId(), sessionId)) {
                                    wbPage.bringToTop((IWorkbenchPart)editor);
                                    if (recordId != -1) {
                                        DsfGdbAdaptor.gotoRank(editor, recordId);
                                    }
                                    return;
                                }
                            } else if (trace instanceof TmfExperiment) {
                                TmfExperiment experiment = (TmfExperiment)trace;
                                List expTraces = experiment.getTraces();
                                int nbTraces = expTraces.size();
                                int i = 0;
                                while (i < nbTraces) {
                                    GdbTrace gdbTrace;
                                    if (trace instanceof GdbTrace && Objects.equals((gdbTrace = (GdbTrace)((Object)((Object)expTraces.get(i)))).getDsfSessionId(), sessionId)) {
                                        wbPage.bringToTop((IWorkbenchPart)editor);
                                        if (recordId != -1) {
                                            int rank = recordId * nbTraces + i;
                                            DsfGdbAdaptor.gotoRank(editor, rank);
                                        }
                                        return;
                                    }
                                    ++i;
                                }
                            }
                        }
                        ++n7;
                    }
                    ++n5;
                }
                ++n3;
            }
        });
    }

    private static void gotoRank(IEditorPart editor, int rank) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editorInput).getFile();
            try {
                IMarker marker = file.createMarker("org.eclipse.core.resources.marker");
                marker.setAttribute("location", (Object)rank);
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                marker.delete();
            }
            catch (CoreException e) {
                GdbTraceCorePlugin.logError(e.getMessage(), e);
            }
        }
    }

    private static /* synthetic */ void lambda$0() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = wbWindow.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Viewer viewer;
                IWorkbenchPage wbPage = iWorkbenchPageArray[n4];
                IViewPart vp = wbPage.findView("org.eclipse.debug.ui.DebugView");
                if (vp instanceof AbstractDebugView && (viewer = ((AbstractDebugView)vp).getViewer()) instanceof ITreeModelViewer) {
                    ((ITreeModelViewer)viewer).setSelection((ISelection)StructuredSelection.EMPTY, false, true);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private class DsfGdbPlatformEventListener
    implements ILaunchesListener2,
    IDebugContextListener {
        private String fCurrentSessionId = "";

        public DsfGdbPlatformEventListener() {
            Display.getDefault().syncExec(() -> {
                DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                DebugUITools.getDebugContextManager().getContextService(win).addDebugContextListener((IDebugContextListener)this);
            });
        }

        public synchronized void launchesRemoved(ILaunch[] launches) {
        }

        public synchronized void launchesAdded(ILaunch[] launches) {
        }

        public synchronized void launchesChanged(ILaunch[] launches) {
        }

        public synchronized void launchesTerminated(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                String sessionId = ((GdbLaunch)launch).getSession().getId();
                DsfGdbAdaptor.closeGdbTraceEditor(sessionId);
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void debugContextChanged(DebugContextEvent event) {
            ISelection selection = event.getContext();
            if (selection instanceof IStructuredSelection) {
                List eventContextList = ((IStructuredSelection)selection).toList();
                for (Object eventContext : eventContextList) {
                    String sessionId;
                    Object contextObject;
                    IDMContext context;
                    if (!(eventContext instanceof IAdaptable) || (context = (IDMContext)(contextObject = ((IAdaptable)eventContext).getAdapter(IDMContext.class))) == null) continue;
                    Object object = SESSION_LOCK;
                    synchronized (object) {
                        sessionId = context.getSessionId();
                        if (Objects.equals(sessionId, this.fCurrentSessionId)) {
                            return;
                        }
                        this.fCurrentSessionId = sessionId;
                    }
                    DsfExecutor executor = DsfSession.getSession((String)sessionId).getExecutor();
                    final DsfServicesTracker tracker = new DsfServicesTracker(GdbTraceCorePlugin.getBundleContext(), sessionId);
                    Query<IGDBTraceControl.ITraceRecordDMContext> getCurrentRecordQuery = new Query<IGDBTraceControl.ITraceRecordDMContext>(){

                        public void execute(DataRequestMonitor<IGDBTraceControl.ITraceRecordDMContext> queryRm) {
                            IGDBTraceControl traceControl = (IGDBTraceControl)tracker.getService(IGDBTraceControl.class);
                            ICommandControlService commandControl = (ICommandControlService)tracker.getService(ICommandControlService.class);
                            if (traceControl != null && commandControl != null) {
                                IGDBTraceControl.ITraceTargetDMContext traceContext = (IGDBTraceControl.ITraceTargetDMContext)commandControl.getContext();
                                traceControl.getCurrentTraceRecordContext(traceContext, queryRm);
                            } else {
                                queryRm.done();
                            }
                        }
                    };
                    try {
                        executor.execute((Runnable)getCurrentRecordQuery);
                        IGDBTraceControl.ITraceRecordDMContext record = DsfGdbAdaptor.this.fIsTimeoutEnabled ? (IGDBTraceControl.ITraceRecordDMContext)getCurrentRecordQuery.get((long)DsfGdbAdaptor.this.fTimeout, TimeUnit.MILLISECONDS) : (IGDBTraceControl.ITraceRecordDMContext)getCurrentRecordQuery.get();
                        if (record == null || record.getRecordId() == null) continue;
                        int recordId = Integer.parseInt(record.getRecordId());
                        DsfGdbAdaptor.selectGdbTraceEditor(sessionId, recordId);
                        break;
                    }
                    catch (InterruptedException e) {
                        GdbTraceCorePlugin.logError(DsfGdbAdaptor.INTERRUPTION_EXCEPTION, e);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        GdbTraceCorePlugin.logError(DsfGdbAdaptor.GDB_EXCEPTION, e);
                    }
                    catch (RejectedExecutionException e) {
                        GdbTraceCorePlugin.logError(DsfGdbAdaptor.REQUEST_REJECTED_EXCEPTION, e);
                    }
                    catch (TimeoutException e) {
                        GdbTraceCorePlugin.logError(DsfGdbAdaptor.TIMEOUT, e);
                    }
                    finally {
                        tracker.dispose();
                    }
                }
            }
        }
    }
}

