/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.preferences.SettingsTransfer;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ChooseWorkspaceWithSettingsDialog
extends ChooseWorkspaceDialog {
    private static final String WORKBENCH_SETTINGS = "WORKBENCH_SETTINGS";
    private static final String ENABLED_TRANSFERS = "ENABLED_TRANSFERS";
    private static final String ATT_CLASS = "class";
    private static final String ATT_NAME = "name";
    private static final String ATT_ID = "id";
    private static final String ATT_HELP_CONTEXT = "helpContext";
    private final Collection<IConfigurationElement> selectedSettings = new HashSet<IConfigurationElement>();

    public ChooseWorkspaceWithSettingsDialog(Shell parentShell, ChooseWorkspaceData launchData, boolean suppressAskAgain, boolean centerOnMonitor) {
        super(parentShell, launchData, suppressAskAgain, centerOnMonitor);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control top = super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.ide.switch_workspace_dialog_context");
        this.createSettingsControls((Composite)top);
        ChooseWorkspaceWithSettingsDialog.applyDialogFont((Control)parent);
        return top;
    }

    private void createSettingsControls(Composite workArea) {
        FormToolkit toolkit = new FormToolkit(workArea.getDisplay());
        workArea.addDisposeListener(e -> toolkit.dispose());
        final ScrolledForm form = toolkit.createScrolledForm(workArea);
        form.getBody().setBackground(workArea.getBackground());
        form.getBody().setLayout((Layout)new GridLayout());
        form.setLayoutData((Object)new GridData(4, 4, true, true));
        ExpandableComposite copySettingsExpandable = toolkit.createExpandableComposite(form.getBody(), 2);
        copySettingsExpandable.setText(IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_SettingsGroupName);
        copySettingsExpandable.setBackground(workArea.getBackground());
        copySettingsExpandable.setLayout((Layout)new GridLayout());
        copySettingsExpandable.setLayoutData((Object)new GridData(4, 4, true, false));
        copySettingsExpandable.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
                Point size = ChooseWorkspaceWithSettingsDialog.this.getInitialSize();
                Shell shell = ChooseWorkspaceWithSettingsDialog.this.getShell();
                shell.setBounds(ChooseWorkspaceWithSettingsDialog.this.getConstrainedShellBounds(new Rectangle(shell.getLocation().x, shell.getLocation().y, size.x, size.y)));
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        Composite sectionClient = toolkit.createComposite((Composite)copySettingsExpandable);
        sectionClient.setBackground(workArea.getBackground());
        if (this.createButtons(toolkit, sectionClient)) {
            copySettingsExpandable.setExpanded(true);
        }
        copySettingsExpandable.setClient((Control)sectionClient);
    }

    private boolean createButtons(FormToolkit toolkit, Composite sectionClient) {
        String[] enabledSettings = this.getEnabledSettings(PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(ChooseWorkspaceWithSettingsDialog.class)).getDialogSettings().getSection(WORKBENCH_SETTINGS));
        RowLayout layout = new RowLayout(512);
        layout.marginLeft = 14;
        layout.spacing = 6;
        sectionClient.setLayout((Layout)layout);
        IConfigurationElement[] iConfigurationElementArray = SettingsTransfer.getSettingsTransfers();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IConfigurationElement settingsTransfer = iConfigurationElementArray[n2];
            final Button button = toolkit.createButton(sectionClient, settingsTransfer.getAttribute(ATT_NAME), 32);
            final ControlDecoration deco = new ControlDecoration((Control)button, 131200);
            Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
            deco.setDescriptionText(IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_copySettingsDecoLabel);
            deco.setImage(image);
            this.toggleDecoForSettingsImportButtons(button, deco);
            this.getCombo().addModifyListener(e -> this.toggleDecoForSettingsImportButtons(button, deco));
            String helpId = settingsTransfer.getAttribute(ATT_HELP_CONTEXT);
            if (helpId != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)button, helpId);
            }
            if (enabledSettings != null && enabledSettings.length > 0) {
                String id = settingsTransfer.getAttribute(ATT_ID);
                String[] stringArray = enabledSettings;
                int n3 = enabledSettings.length;
                int n4 = 0;
                while (n4 < n3) {
                    String enabledSetting = stringArray[n4];
                    if (enabledSetting.equals(id)) {
                        button.setSelection(true);
                        this.selectedSettings.add(settingsTransfer);
                        break;
                    }
                    ++n4;
                }
            }
            button.setBackground(sectionClient.getBackground());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        ChooseWorkspaceWithSettingsDialog.this.selectedSettings.add(settingsTransfer);
                    } else {
                        ChooseWorkspaceWithSettingsDialog.this.selectedSettings.remove(settingsTransfer);
                    }
                    ChooseWorkspaceWithSettingsDialog.this.toggleDecoForSettingsImportButtons(button, deco);
                }
            });
            ++n2;
        }
        return enabledSettings != null && enabledSettings.length > 0;
    }

    private void toggleDecoForSettingsImportButtons(Button button, ControlDecoration deco) {
        if (!button.getSelection()) {
            deco.hide();
            return;
        }
        if (Files.exists(Paths.get(this.getWorkspaceLocation(), new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            deco.show();
        } else {
            deco.hide();
        }
    }

    private String[] getEnabledSettings(IDialogSettings section) {
        if (section == null) {
            return null;
        }
        return section.getArray(ENABLED_TRANSFERS);
    }

    @Override
    protected void okPressed() {
        Iterator<IConfigurationElement> settingsIterator = this.selectedSettings.iterator();
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_ProblemsTransferTitle, null);
        IPath path = IPath.fromOSString((String)this.getWorkspaceLocation());
        String[] selectionIDs = new String[this.selectedSettings.size()];
        int index = 0;
        while (settingsIterator.hasNext()) {
            IConfigurationElement elem = settingsIterator.next();
            result.add(this.transferSettings(elem, path));
            selectionIDs[index] = elem.getAttribute(ATT_ID);
        }
        if (result.getSeverity() != 0) {
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_TransferFailedMessage, (String)IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_SaveSettingsFailed, (IStatus)result);
            return;
        }
        this.saveSettings(selectionIDs);
        super.okPressed();
    }

    private void saveSettings(String[] selectionIDs) {
        IDialogSettings dialogSettings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(ChooseWorkspaceWithSettingsDialog.class)).getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection(WORKBENCH_SETTINGS);
        if (settings == null) {
            settings = dialogSettings.addNewSection(WORKBENCH_SETTINGS);
        }
        settings.put(ENABLED_TRANSFERS, selectionIDs);
    }

    private IStatus transferSettings(final IConfigurationElement element, final IPath path) {
        final IStatus[] exceptions = new IStatus[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                try {
                    SettingsTransfer transfer = (SettingsTransfer)WorkbenchPlugin.createExtension((IConfigurationElement)element, (String)ChooseWorkspaceWithSettingsDialog.ATT_CLASS);
                    transfer.transferSettings(path);
                }
                catch (CoreException exception) {
                    exceptions[0] = exception.getStatus();
                }
            }

            public void handleException(Throwable exception) {
                exceptions[0] = StatusUtil.newStatus(4, NLS.bind((String)IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_ClassCreationFailed, (Object)element.getAttribute(ChooseWorkspaceWithSettingsDialog.ATT_CLASS)), exception);
            }
        });
        if (exceptions[0] != null) {
            return exceptions[0];
        }
        return Status.OK_STATUS;
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }
}

