/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.snapping;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.core.gef.policy.snapping.IFeedbackProxy;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPoint;

public class SameSizeSnapPoint
extends SnapPoint {
    private final List<? extends IAbstractComponentInfo> m_allComponents;
    private IAbstractComponentInfo m_sameSizedComponent;

    public SameSizeSnapPoint(IVisualDataProvider visualDataProvider, List<? extends IAbstractComponentInfo> components, int side) {
        super(visualDataProvider, side, side == 1 || side == 8 ? 0 : 1);
        this.m_allComponents = components;
        this.m_snapDistance = 5;
    }

    @Override
    public boolean snap(List<? extends IAbstractComponentInfo> beingSnappedList, Rectangle beingSnappedBounds, int moveDirection, int resizeDirection) {
        if (resizeDirection == 0 || beingSnappedList.size() != 1) {
            return false;
        }
        Transposer t = new Transposer();
        t.setEnabled(!this.isHorizontal());
        Rectangle transposedBounds = t.t(beingSnappedBounds);
        this.m_sameSizedComponent = null;
        IAbstractComponentInfo beingSnapped = beingSnappedList.get(0);
        if (this.isValidResizeDirection(resizeDirection)) {
            for (IAbstractComponentInfo iAbstractComponentInfo : this.m_allComponents) {
                Rectangle modelBounds;
                Dimension size;
                if (iAbstractComponentInfo == beingSnapped || !this.doSnapping(transposedBounds, size = (modelBounds = t.t(PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, iAbstractComponentInfo))).getSize())) continue;
                this.m_sameSizedComponent = iAbstractComponentInfo;
                beingSnappedBounds.setBounds(t.t(transposedBounds));
                return true;
            }
            Dimension dimension = this.m_visualDataProvider.getComponentPreferredSize(beingSnapped);
            if (dimension == null) {
                return false;
            }
            if (this.doSnapping(transposedBounds, t.t(dimension))) {
                beingSnappedBounds.setBounds(t.t(transposedBounds));
                return true;
            }
        }
        return false;
    }

    private boolean doSnapping(Rectangle transposedBounds, Dimension size) {
        int beingSnappedPoint = this.getSnapDirection() == 0 ? transposedBounds.x : transposedBounds.right();
        this.m_snapPoint = this.m_side == 1 || this.m_side == 8 ? transposedBounds.right() - size.width : transposedBounds.x + size.width;
        this.m_snapInterval = new Interval(this.m_snapPoint - this.m_snapDistance, this.m_snapDistance * 2);
        if (this.m_snapInterval.contains(beingSnappedPoint)) {
            if (this.getSnapDirection() == 0) {
                transposedBounds.width += transposedBounds.x - this.m_snapPoint;
                transposedBounds.x = this.m_snapPoint;
            } else {
                transposedBounds.width = this.m_snapPoint - transposedBounds.x;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void calculateSnapPoint(List<? extends IAbstractComponentInfo> beingSnappedList) {
    }

    @Override
    public void addFeedback(Rectangle snappedBounds, IFeedbackProxy feedbackProxy, List<IFigure> feedbacks) {
        if (this.m_sameSizedComponent != null) {
            Rectangle bounds = PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, this.m_sameSizedComponent);
            feedbacks.add(feedbackProxy.addOutlineFeedback(bounds));
            this.addMiddleLineFeedback(bounds, feedbackProxy, feedbacks);
        }
        this.addMiddleLineFeedback(snappedBounds, feedbackProxy, feedbacks);
    }

    private void addMiddleLineFeedback(Rectangle bounds, IFeedbackProxy feedbackProxy, List<IFigure> feedbacks) {
        IFigure figure = this.isHorizontal() ? feedbackProxy.addHorizontalMiddleLineFeedback(bounds.y + bounds.height / 2, bounds.x, bounds.width) : feedbackProxy.addVerticalMiddleLineFeedback(bounds.x + bounds.width / 2, bounds.y, bounds.height);
        feedbacks.add(figure);
    }
}

