/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.table;

import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.PixelConverter;

public final class HtmlTooltipHelper {
    public static Control createTooltipControl(Composite parent, String header, String details) {
        return HtmlTooltipHelper.createTooltipControl(parent, header, details, 0);
    }

    public static Control createTooltipControl(Composite parent, String header, String details, int heightLimit) {
        Control control;
        try {
            Object html = "<table cellspacing=2 cellpadding=0 border=0 margins=0 id=_wbp_tooltip_body>";
            if (header != null) {
                html = (String)html + "<tr align=center><td><b>" + header + "</b></td></tr>";
            }
            html = (String)html + "<tr><td align=justify>" + details + "</td></tr>";
            html = (String)html + "</table>";
            control = HtmlTooltipHelper.createTooltipControl_Browser(parent, (String)html, heightLimit);
        }
        catch (Throwable e) {
            control = HtmlTooltipHelper.createTooltipControl_Label(parent, details);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Control tooltipControl = (Control)event.widget;
                HtmlTooltipHelper.hideTooltip(tooltipControl);
            }
        };
        control.addListener(7, listener);
        return control;
    }

    private static Control createTooltipControl_Browser(Composite parent, String html, final int heightLimitChars) {
        String styles;
        try {
            styles = IOUtils2.readString(PropertyTable.class.getResourceAsStream("Tooltip.css"));
        }
        catch (Throwable e) {
            styles = "";
        }
        String bodyAttributes = MessageFormat.format("text=''{0}'' bgcolor=''{1}''", HtmlTooltipHelper.getColorWebString(ColorConstants.tooltipForeground), HtmlTooltipHelper.getColorWebString(ColorConstants.tooltipBackground));
        String closeElement = EnvironmentUtils.IS_LINUX ? "    <a href='' style='position:absolute;right:1em;' id=_wbp_close>Close</a>" : "";
        String wrappedHtml = StringUtils.join((Object[])new String[]{"<html>", "  <style CHARSET='ISO-8859-1' TYPE='text/css'>", styles, "  </style>", "  <body " + bodyAttributes + ">", closeElement, html, "  </body>", "</html>"}, (String)"\n");
        final Browser browser = new Browser(parent, 0);
        browser.setText(wrappedHtml);
        int textLength = HtmlTooltipHelper.getTextLength(html);
        int hintH = 50;
        if (textLength < 100) {
            hintH = 40;
        }
        int hintV = textLength / hintH + 3;
        hintV = Math.min(hintV, 8);
        GridDataFactory.create((Control)browser).hintC(hintH, hintV);
        browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                browser.removeProgressListener((ProgressListener)this);
                HtmlTooltipHelper.tweakBrowserSize(browser, heightLimitChars);
                browser.getShell().setVisible(true);
                browser.addLocationListener(LocationListener.changedAdapter(HtmlTooltipHelper::access$0));
            }
        });
        return browser;
    }

    private static void openUrl(LocationEvent event) {
        event.doit = false;
        HtmlTooltipHelper.hideTooltip((Control)((Browser)event.widget));
        if (!"about:blank".equals(event.location)) {
            try {
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                IWebBrowser browserSupport = support.createBrowser("wbp.browser");
                browserSupport.openURL(new URL(event.location));
            }
            catch (Throwable e) {
                DesignerPlugin.log(e);
            }
        }
    }

    private static void tweakBrowserSize(Browser browser, int heightLimitChars) {
        GridDataFactory.create((Control)browser).grab().fill();
        if (heightLimitChars != 0) {
            PixelConverter pixelConverter = new PixelConverter((Control)browser);
            int maxHeight = pixelConverter.convertHeightInCharsToPixels(heightLimitChars);
            HtmlTooltipHelper.expandShellToShowFullPage_Height(browser, maxHeight);
        }
        if (heightLimitChars == 0) {
            HtmlTooltipHelper.expandShellToShowFullPage_Height(browser, Integer.MAX_VALUE);
        }
    }

    private static void expandShellToShowFullPage_Height(Browser browser, int maxHeight) {
        try {
            Shell shell = browser.getShell();
            HtmlTooltipHelper.getContentOffsetHeight(browser);
            int contentHeight = HtmlTooltipHelper.getContentScrollHeight(browser);
            int useHeight = Math.min(contentHeight + (EnvironmentUtils.IS_LINUX ? 2 : 10), maxHeight);
            shell.setSize(shell.getSize().x, useHeight);
            int offsetHeight = HtmlTooltipHelper.getBodyOffsetHeight(browser);
            int scrollHeight = HtmlTooltipHelper.getBodyScrollHeight(browser);
            int delta = scrollHeight - offsetHeight;
            if (delta != 0 && delta < 10) {
                Point size = shell.getSize();
                shell.setSize(size.x, size.y + delta + 1);
            }
            int offsetWidth = HtmlTooltipHelper.getContentOffsetWidth(browser);
            Point size = shell.getSize();
            shell.setSize(offsetWidth + (EnvironmentUtils.IS_MAC ? 6 : 10), size.y);
            if (EnvironmentUtils.IS_LINUX && shell.getSize().y < 30) {
                HtmlTooltipHelper.hideCloseElement(browser);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int getContentOffsetWidth(Browser browser) throws Exception {
        return HtmlTooltipHelper.evaluateScriptInt(browser, "return document.getElementById('_wbp_tooltip_body').offsetWidth;");
    }

    private static int getContentOffsetHeight(Browser browser) throws Exception {
        return HtmlTooltipHelper.evaluateScriptInt(browser, "return document.getElementById('_wbp_tooltip_body').offsetHeight;");
    }

    private static int getContentScrollHeight(Browser browser) throws Exception {
        return HtmlTooltipHelper.evaluateScriptInt(browser, "return document.getElementById('_wbp_tooltip_body').scrollHeight;");
    }

    private static int getBodyOffsetHeight(Browser browser) throws Exception {
        return HtmlTooltipHelper.evaluateScriptInt(browser, "return document.body.offsetHeight;");
    }

    private static int getBodyScrollHeight(Browser browser) throws Exception {
        return HtmlTooltipHelper.evaluateScriptInt(browser, "return document.body.scrollHeight;");
    }

    private static int evaluateScriptInt(Browser browser, String script) throws Exception {
        Object o = ReflectionUtils.invokeMethod(browser, "evaluate(java.lang.String)", script);
        return ((Number)o).intValue();
    }

    private static void hideCloseElement(Browser browser) throws Exception {
        String script = "document.getElementById('_wbp_close').style.display = 'none'";
        ReflectionUtils.invokeMethod(browser, "evaluate(java.lang.String)", script);
    }

    private static int getTextLength(String html) {
        StringReader htmlStringReader = new StringReader(html);
        try {
            ClassLoader classLoader = PropertyTable.class.getClassLoader();
            Class<?> readerClass = classLoader.loadClass("org.eclipse.jface.internal.text.html.HTML2TextReader");
            Object reader = readerClass.getConstructors()[0].newInstance(htmlStringReader, null);
            String text = (String)ReflectionUtils.invokeMethod(reader, "getString()", new Object[0]);
            return text.length();
        }
        catch (Throwable e) {
            return html.length();
        }
    }

    private static String getColorWebString(Color color) {
        String colorString = "#" + Integer.toHexString(color.getRed());
        colorString = colorString + Integer.toHexString(color.getGreen());
        colorString = colorString + Integer.toHexString(color.getBlue());
        return colorString;
    }

    private static Control createTooltipControl_Label(Composite parent, String html) {
        final Label label = new Label(parent, 64);
        label.setText(html);
        int requiredWidth = label.computeSize((int)-1, (int)-1).x;
        GridDataFactory.create((Control)label).hintHC(50).hintHMin(requiredWidth);
        label.setForeground(parent.getForeground());
        label.setBackground(parent.getBackground());
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = label.getShell();
                shell.setVisible(true);
            }
        });
        return label;
    }

    private static void hideTooltip(Control tooltip) {
        tooltip.getShell().dispose();
    }

    static /* synthetic */ void access$0(LocationEvent locationEvent) {
        HtmlTooltipHelper.openUrl(locationEvent);
    }
}

