/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.ui.internal.CategoryDetailsPanel;
import org.eclipse.wst.common.project.facet.ui.internal.FacetDetailsPanel;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPanel;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;

public final class DetailsPanel
extends Composite {
    public static final String HEADER_FONT = DetailsPanel.class.getName() + ".HEADER_FONT";
    private final FacetsSelectionPanel facetsSelectionPanel;
    private Composite content = null;

    static {
        String defaultFontName = JFaceResources.getDefaultFont().getFontData()[0].getName();
        FontData[] fontData = JFaceResources.getFontRegistry().getBold(defaultFontName).getFontData();
        JFaceResources.getFontRegistry().put(HEADER_FONT, fontData);
    }

    public DetailsPanel(Composite parent, final FacetsSelectionPanel facetsSelectionPanel) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(1), 5, 8));
        this.facetsSelectionPanel = facetsSelectionPanel;
        this.facetsSelectionPanel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DetailsPanel.this.refresh();
            }
        });
        final IFacetedProjectListener facetedProjectListener = new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                DetailsPanel.this.refresh();
            }
        };
        this.facetsSelectionPanel.getFacetedProjectWorkingCopy().addListener(facetedProjectListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.FIXED_FACETS_CHANGED});
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                facetsSelectionPanel.getFacetedProjectWorkingCopy().removeListener(facetedProjectListener);
            }
        });
        this.refresh();
    }

    private void refresh() {
        IStructuredSelection sel;
        if (this.content != null) {
            this.content.dispose();
        }
        if ((sel = (IStructuredSelection)this.facetsSelectionPanel.getSelection()) == null || sel.isEmpty()) {
            this.content = new Composite((Composite)this, 0);
            this.content.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(1), 0, 0));
            Text noSelectionTextField = new Text(this.content, 72);
            noSelectionTextField.setLayoutData((Object)GridLayoutUtil.gdhfill());
            noSelectionTextField.setText(Resources.noSelectionLabel);
        } else {
            Object selection = sel.getFirstElement();
            if (selection instanceof IProjectFacetVersion) {
                IProjectFacetVersion fv = (IProjectFacetVersion)selection;
                this.content = new FacetDetailsPanel(this, this.facetsSelectionPanel, fv);
            } else if (selection instanceof ICategory) {
                ICategory cat = (ICategory)selection;
                this.content = new CategoryDetailsPanel(this, this.facetsSelectionPanel, cat);
            }
        }
        this.content.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.layout();
    }

    private static final class Resources
    extends NLS {
        public static String noSelectionLabel;

        static {
            Resources.initializeMessages((String)DetailsPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

