/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import org.eclipse.zest.layouts.dataStructures.DisplayIndependentDimension;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.interfaces.EntityLayout;

public class AlgorithmHelper {
    public static int MIN_NODE_SIZE = 8;
    public static double PADDING_PERCENT = 0.8;

    public static void fitWithinBounds(EntityLayout[] entities, DisplayIndependentRectangle destinationBounds, boolean resize) {
        DisplayIndependentRectangle startingBounds = AlgorithmHelper.getLayoutBounds(entities, false);
        double sizeScale = Math.min(destinationBounds.width / startingBounds.width, destinationBounds.height / startingBounds.height);
        if (entities.length == 1) {
            AlgorithmHelper.fitSingleEntity(entities[0], destinationBounds, resize);
            return;
        }
        EntityLayout[] entityLayoutArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            EntityLayout entity = entityLayoutArray[n2];
            DisplayIndependentDimension size = entity.getSize();
            if (entity.isMovable()) {
                DisplayIndependentPoint location = entity.getLocation();
                double percentX = (location.x - startingBounds.x) / startingBounds.width;
                double percentY = (location.y - startingBounds.y) / startingBounds.height;
                if (resize && entity.isResizable()) {
                    size.width *= sizeScale;
                    size.height *= sizeScale;
                    entity.setSize(size.width, size.height);
                }
                location.x = destinationBounds.x + percentX * (destinationBounds.width - size.width);
                location.y = destinationBounds.y + percentY * (destinationBounds.height - size.height);
                entity.setLocation(location.x, location.y);
            } else if (resize && entity.isResizable()) {
                entity.setSize(size.width * sizeScale, size.height * sizeScale);
            }
            ++n2;
        }
    }

    private static void fitSingleEntity(EntityLayout entity, DisplayIndependentRectangle destinationBounds, boolean resize) {
        if (entity.isMovable()) {
            entity.setLocation(destinationBounds.x + destinationBounds.width / 2.0, destinationBounds.y + destinationBounds.height / 2.0);
        }
        if (resize && entity.isResizable()) {
            double width = destinationBounds.width;
            double height = destinationBounds.height;
            double preferredAspectRatio = entity.getPreferredAspectRatio();
            if (preferredAspectRatio > 0.0) {
                DisplayIndependentDimension fixedSize = AlgorithmHelper.fixAspectRatio(width, height, preferredAspectRatio);
                entity.setSize(fixedSize.width, fixedSize.height);
            } else {
                entity.setSize(width, height);
            }
        }
    }

    public static void maximizeSizes(EntityLayout[] entities) {
        if (entities.length > 1) {
            double nodeSize;
            DisplayIndependentDimension minDistance = AlgorithmHelper.getMinimumDistance(entities);
            double width = nodeSize = Math.max(minDistance.width, minDistance.height) * PADDING_PERCENT;
            double height = nodeSize;
            EntityLayout[] entityLayoutArray = entities;
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                EntityLayout entity = entityLayoutArray[n2];
                if (entity.isResizable()) {
                    double preferredRatio = entity.getPreferredAspectRatio();
                    if (preferredRatio > 0.0) {
                        DisplayIndependentDimension fixedSize = AlgorithmHelper.fixAspectRatio(width, height, preferredRatio);
                        entity.setSize(fixedSize.width, fixedSize.height);
                    } else {
                        entity.setSize(width, height);
                    }
                }
                ++n2;
            }
        }
    }

    private static DisplayIndependentDimension fixAspectRatio(double width, double height, double preferredRatio) {
        double actualRatio = width / height;
        if (actualRatio > preferredRatio && (width = height * preferredRatio) < (double)MIN_NODE_SIZE) {
            width = MIN_NODE_SIZE;
            height = width / preferredRatio;
        }
        if (actualRatio < preferredRatio && (height = width / preferredRatio) < (double)MIN_NODE_SIZE) {
            height = MIN_NODE_SIZE;
            width = height * preferredRatio;
        }
        return new DisplayIndependentDimension(width, height);
    }

    public static DisplayIndependentRectangle getLayoutBounds(EntityLayout[] entities, boolean includeNodeSize) {
        double rightSide = Double.NEGATIVE_INFINITY;
        double bottomSide = Double.NEGATIVE_INFINITY;
        double leftSide = Double.POSITIVE_INFINITY;
        double topSide = Double.POSITIVE_INFINITY;
        EntityLayout[] entityLayoutArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            EntityLayout entity = entityLayoutArray[n2];
            DisplayIndependentPoint location = entity.getLocation();
            DisplayIndependentDimension size = entity.getSize();
            if (includeNodeSize) {
                leftSide = Math.min(location.x - size.width / 2.0, leftSide);
                topSide = Math.min(location.y - size.height / 2.0, topSide);
                rightSide = Math.max(location.x + size.width / 2.0, rightSide);
                bottomSide = Math.max(location.y + size.height / 2.0, bottomSide);
            } else {
                leftSide = Math.min(location.x, leftSide);
                topSide = Math.min(location.y, topSide);
                rightSide = Math.max(location.x, rightSide);
                bottomSide = Math.max(location.y, bottomSide);
            }
            ++n2;
        }
        return new DisplayIndependentRectangle(leftSide, topSide, rightSide - leftSide, bottomSide - topSide);
    }

    public static DisplayIndependentDimension getMinimumDistance(EntityLayout[] entities) {
        DisplayIndependentDimension horAndVertdistance = new DisplayIndependentDimension(Double.MAX_VALUE, Double.MAX_VALUE);
        double minDistance = Double.MAX_VALUE;
        int i = 0;
        while (i < entities.length) {
            DisplayIndependentPoint location1 = entities[i].getLocation();
            int j = i + 1;
            while (j < entities.length) {
                DisplayIndependentPoint location2 = entities[j].getLocation();
                double distanceX = location1.x - location2.x;
                double distanceY = location1.y - location2.y;
                double distance = distanceX * distanceX + distanceY * distanceY;
                if (distance < minDistance) {
                    minDistance = distance;
                    horAndVertdistance.width = Math.abs(distanceX);
                    horAndVertdistance.height = Math.abs(distanceY);
                }
                ++j;
            }
            ++i;
        }
        return horAndVertdistance;
    }
}

