/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.assertj.promise;

import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.osgi.test.common.exceptions.Exceptions;
import org.osgi.util.promise.Promise;

public abstract class AbstractPromiseAssert<SELF extends AbstractPromiseAssert<SELF, ACTUAL, RESULT>, ACTUAL extends Promise<? extends RESULT>, RESULT>
extends AbstractAssert<SELF, ACTUAL> {
    protected AbstractPromiseAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    void assertDone() {
        if (!((Promise)this.actual).isDone()) {
            throw this.failure("%nExpecting%n  <%s>%nto be done.", new Object[]{this.actual});
        }
    }

    public SELF isDone() {
        ((AbstractPromiseAssert)this.isNotNull()).assertDone();
        return (SELF)((Object)((AbstractPromiseAssert)this.myself));
    }

    void assertNotDone() {
        if (((Promise)this.actual).isDone()) {
            throw this.failure("%nExpecting%n  <%s>%nto not be done.", new Object[]{this.actual});
        }
    }

    public SELF isNotDone() {
        ((AbstractPromiseAssert)this.isNotNull()).assertNotDone();
        return (SELF)((Object)((AbstractPromiseAssert)this.myself));
    }

    public SELF resolvesWithin(long timeout, TimeUnit unit) {
        this.isNotNull();
        if (!((Promise)this.actual).isDone()) {
            CountDownLatch latch = new CountDownLatch(1);
            ((Promise)this.actual).onResolve(latch::countDown);
            try {
                if (!latch.await(timeout, unit)) {
                    throw this.failure("%nExpecting%n  <%s>%nto have resolved.", new Object[]{this.actual});
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Assertions.fail((String)"unexpected exception", (Throwable)e);
            }
            this.assertDone();
        }
        return (SELF)((Object)((AbstractPromiseAssert)this.myself));
    }

    public SELF resolvesWithin(Duration timeout) {
        return this.resolvesWithin(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public SELF doesNotResolveWithin(long timeout, TimeUnit unit) {
        this.isNotDone();
        CountDownLatch latch = new CountDownLatch(1);
        ((Promise)this.actual).onResolve(latch::countDown);
        try {
            if (latch.await(timeout, unit)) {
                throw this.failure("%nExpecting%n  <%s>%nto not have resolved.", new Object[]{this.actual});
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Assertions.fail((String)"unexpected exception", (Throwable)e);
        }
        this.assertNotDone();
        return (SELF)((Object)((AbstractPromiseAssert)this.myself));
    }

    public SELF doesNotResolveWithin(Duration timeout) {
        return this.doesNotResolveWithin(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    Throwable getFailure(ACTUAL promise) {
        try {
            return promise.getFailure();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Assertions.fail((String)"unexpected exception", (Throwable)e);
            return null;
        }
    }

    void assertFailed() {
        Throwable fail = this.getFailure((Promise)this.actual);
        if (fail == null) {
            throw this.failure("%nExpecting%n  <%s>%nto have failed.", new Object[]{this.actual});
        }
    }

    public SELF hasFailed() {
        ((AbstractPromiseAssert)((Object)this.isDone())).assertFailed();
        return (SELF)((Object)((AbstractPromiseAssert)this.myself));
    }

    public AbstractThrowableAssert<?, ? extends Throwable> hasFailedWithThrowableThat() {
        return (AbstractThrowableAssert)this.hasFailed().extracting(this::getFailure, (AssertFactory)InstanceOfAssertFactories.THROWABLE);
    }

    void assertNotFailed() {
        Throwable fail;
        if (((Promise)this.actual).isDone() && (fail = this.getFailure((Promise)this.actual)) != null) {
            throw this.failure("%nExpecting%n  <%s>%nto have not failed but failed with:%n%s", new Object[]{this.actual, Exceptions.toString((Throwable)fail)});
        }
    }

    public SELF hasNotFailed() {
        ((AbstractPromiseAssert)this.isNotNull()).assertNotFailed();
        return (SELF)((Object)((AbstractPromiseAssert)this.myself));
    }

    public SELF isSuccessful() {
        ((AbstractPromiseAssert)((Object)this.isDone())).assertNotFailed();
        return (SELF)((Object)((AbstractPromiseAssert)this.myself));
    }

    RESULT getValue(ACTUAL promise) {
        try {
            return (RESULT)promise.getValue();
        }
        catch (InvocationTargetException e) {
            throw this.failure("%nExpecting%n  <%s>%nto have not failed but failed with %s", new Object[]{promise, Exceptions.toString((Throwable)e.getCause())});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError("unexpected exception", e);
        }
    }

    public AbstractObjectAssert<?, RESULT> hasValueThat() {
        return (AbstractObjectAssert)this.isSuccessful().extracting(this::getValue, Assertions::assertThatObject);
    }

    public <ASSERT extends AbstractAssert<?, ?>> ASSERT hasValueThat(InstanceOfAssertFactory<? super RESULT, ASSERT> assertFactory) {
        return (ASSERT)this.isSuccessful().extracting(this::getValue, assertFactory);
    }

    public SELF hasValue(RESULT expected) {
        this.hasValueThat().isEqualTo(expected);
        return (SELF)((Object)((AbstractPromiseAssert)this.myself));
    }

    public SELF hasSameValue(RESULT expected) {
        this.hasValueThat().isSameAs(expected);
        return (SELF)((Object)((AbstractPromiseAssert)this.myself));
    }

    public SELF hasValueMatching(Predicate<? super RESULT> predicate, String predicateDescription) {
        this.hasValueThat().matches(predicate, predicateDescription);
        return (SELF)((Object)((AbstractPromiseAssert)this.myself));
    }

    public SELF hasValueMatching(Predicate<? super RESULT> predicate) {
        return this.hasValueMatching(predicate, "given");
    }
}

