/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.bitmaps;

import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Bitmap {
    final int[] types;
    final int KNOWN_MASK;
    final int UNKNOWN_MASK;
    final IntFunction<String> mappingFunction;

    public Bitmap(int[] types, IntFunction<String> mappingFunction) {
        this.types = types;
        this.mappingFunction = mappingFunction;
        this.KNOWN_MASK = IntStream.of(types).reduce((x, y) -> x | y).getAsInt();
        this.UNKNOWN_MASK = ~this.KNOWN_MASK;
    }

    public Bitmap(Map<Integer, String> mapping) {
        this(mapping.keySet().stream().mapToInt(Integer::intValue).sorted().toArray(), mapping::get);
    }

    public int getKnownMask() {
        return this.KNOWN_MASK;
    }

    public int getUnknownMask() {
        return this.KNOWN_MASK;
    }

    public static boolean hasSingleBit(int type) {
        return (type & type - 1) == 0;
    }

    public String toString(int type) {
        if (!Bitmap.hasSingleBit(type)) {
            throw new IllegalArgumentException("Multiple bits set in type (" + type + ") - do you mean to use maskToString()?");
        }
        String retval = this.mappingFunction.apply(type);
        return retval == null ? "UNKNOWN" : retval;
    }

    public String maskToString(int mask) {
        Stream<String> bits = IntStream.of(this.types).filter(x -> (x & mask) != 0).mapToObj(this::toString);
        if ((mask & this.UNKNOWN_MASK) != 0) {
            bits = Stream.concat(bits, Stream.of("UNKNOWN"));
        }
        return mask + ":" + bits.collect(Collectors.joining(" | "));
    }

    public static boolean typeMatchesMask(int type, int mask) {
        return (type & mask) != 0;
    }
}

