/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.exceptions;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.osgi.test.common.exceptions.Exceptions;

@FunctionalInterface
public interface PredicateWithException<T> {
    public boolean test(T var1) throws Exception;

    default public Predicate<T> orElseThrow() {
        return t -> {
            try {
                return this.test(t);
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        };
    }

    default public Predicate<T> orElse(boolean orElse) {
        return t -> {
            try {
                return this.test(t);
            }
            catch (Exception e) {
                return orElse;
            }
        };
    }

    default public Predicate<T> orElseGet(BooleanSupplier orElseGet) {
        Objects.requireNonNull(orElseGet);
        return t -> {
            try {
                return this.test(t);
            }
            catch (Exception e) {
                return orElseGet.getAsBoolean();
            }
        };
    }

    public static <T> Predicate<T> asPredicate(PredicateWithException<T> unchecked) {
        return unchecked.orElseThrow();
    }

    public static <T> Predicate<T> asPredicateOrElse(PredicateWithException<T> unchecked, boolean orElse) {
        return unchecked.orElse(orElse);
    }

    public static <T> Predicate<T> asPredicateOrElseGet(PredicateWithException<T> unchecked, BooleanSupplier orElseGet) {
        return unchecked.orElseGet(orElseGet);
    }
}

