/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal;

import java.util.Hashtable;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;

public class GdbDebugOptions
implements DebugOptionsListener {
    private static final String DEBUG_FLAG = "org.eclipse.cdt.dsf.gdb/debug";
    private static final String DEBUG_TIMEOUTS_FLAG = "org.eclipse.cdt.dsf.gdb/debug/timeouts";
    public static boolean DEBUG = false;
    public static boolean DEBUG_COMMAND_TIMEOUTS = false;
    private static DebugTrace fgDebugTrace;

    public GdbDebugOptions(BundleContext context) {
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", GdbPlugin.getUniqueIdentifier());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
    }

    public void optionsChanged(DebugOptions options) {
        fgDebugTrace = options.newDebugTrace(GdbPlugin.getUniqueIdentifier());
        DEBUG = options.getBooleanOption(DEBUG_FLAG, false);
        DEBUG_COMMAND_TIMEOUTS = options.getBooleanOption(DEBUG_TIMEOUTS_FLAG, false);
    }

    public static void trace(String option, String message, Throwable throwable) {
        GdbDebugOptions.trace(option, message, 100, throwable);
    }

    public static void trace(String option, String message, int lineMax, Throwable throwable) {
        if (lineMax < 0) {
            lineMax = Integer.MAX_VALUE;
        } else if (lineMax < 100) {
            lineMax = 100;
        }
        String systemPrintableMessage = message;
        while (systemPrintableMessage.length() > lineMax) {
            String partial = systemPrintableMessage.substring(0, lineMax);
            systemPrintableMessage = systemPrintableMessage.substring(lineMax);
            System.out.println(partial + "\\");
        }
        System.out.print(systemPrintableMessage);
        if (fgDebugTrace != null) {
            fgDebugTrace.trace(option, message, throwable);
        }
    }

    public static void trace(String message, int lineMax) {
        GdbDebugOptions.trace(null, message, lineMax, null);
    }

    public static void trace(String message) {
        GdbDebugOptions.trace(null, message, null);
    }
}

