/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThread;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIThreadInfoInfo
extends MIInfo {
    private String fCurrentThread = null;
    private MIThread[] fThreadList = null;

    public MIThreadInfoInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public String getCurrentThread() {
        return this.fCurrentThread;
    }

    public MIThread[] getThreadList() {
        return this.fThreadList;
    }

    protected void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue value;
                String var = results[i].getVariable();
                if (var.equals("threads")) {
                    MIValue val = results[i].getMIValue();
                    if (val instanceof MIList) {
                        this.fThreadList = this.parseThreadsImpl((MIList)val);
                    }
                } else if (var.equals("current-thread-id") && (value = results[i].getMIValue()) instanceof MIConst) {
                    this.fCurrentThread = ((MIConst)value).getCString().trim();
                }
                ++i;
            }
        }
        if (this.fThreadList == null) {
            this.fThreadList = new MIThread[0];
        }
    }

    protected MIThread[] parseThreadsImpl(MIList list) {
        return MIThreadInfoInfo.parseThreads(list);
    }

    static MIThread[] parseThreads(MIList list) {
        MIValue[] values = list.getMIValues();
        MIThread[] threadList = new MIThread[values.length];
        int i = 0;
        while (i < values.length) {
            threadList[i] = MIThread.parse((MITuple)values[i]);
            ++i;
        }
        Arrays.sort(threadList, new Comparator<MIThread>(){

            @Override
            public int compare(MIThread o1, MIThread o2) {
                try {
                    return Integer.parseInt(o1.getThreadId()) - Integer.parseInt(o2.getThreadId());
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        });
        return threadList;
    }
}

