/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.sirius.internal.tools.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.AbstractDecoratorManager;
import org.eclipse.emf.compare.diagram.ide.ui.sirius.internal.tools.image.EMFCompareDiagramImageGenerator;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageExporter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.common.tools.api.util.FileUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.tools.api.part.DiagramEditPartService;

public class EMFCompareCopyToImageUtil
extends DiagramEditPartService {
    private DiagramEditPart leftDiagramEditPart;
    private DiagramEditPart rightDiagramEditPart;
    private Collection<AbstractDecoratorManager.AbstractDecorator> decorators;

    public EMFCompareCopyToImageUtil(DiagramEditPart leftDEP, DiagramEditPart rightDEP, Collection<AbstractDecoratorManager.AbstractDecorator> abstractDecorators) {
        this.leftDiagramEditPart = leftDEP;
        this.rightDiagramEditPart = rightDEP;
        this.decorators = abstractDecorators;
    }

    public DiagramEditPart getLeftDiagramEditPart() {
        return this.leftDiagramEditPart;
    }

    public DiagramEditPart getRightDiagramEditPart() {
        return this.rightDiagramEditPart;
    }

    public Collection<AbstractDecoratorManager.AbstractDecorator> getDecorators() {
        return this.decorators;
    }

    protected DiagramGenerator getDiagramGenerator(DiagramEditPart diagramEP, ImageFileFormat format) {
        return new EMFCompareDiagramImageGenerator(diagramEP, this.decorators, this.getSide(diagramEP));
    }

    protected IMergeViewer.MergeViewerSide getSide(DiagramEditPart diagramEP) {
        if (diagramEP.equals(this.leftDiagramEditPart)) {
            return IMergeViewer.MergeViewerSide.LEFT;
        }
        return IMergeViewer.MergeViewerSide.RIGHT;
    }

    public void copyAllToImage(IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        IPath leftPath = this.getValidPath(destination, this.leftDiagramEditPart, format);
        this.copyToImage(this.leftDiagramEditPart, leftPath, format, monitor);
        IPath rightPath = this.getValidPath(destination, this.rightDiagramEditPart, format);
        this.copyToImage(this.rightDiagramEditPart, rightPath, format, monitor);
        try {
            this.appendImages(destination, leftPath, rightPath, format, monitor);
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
        }
    }

    protected void appendImages(IPath destination, IPath leftPath, IPath rightPath, ImageFileFormat format, IProgressMonitor monitor) throws CoreException, IOException {
        IPath fileName = this.getValidPath(destination, null, format);
        String exportFormat = "PNG";
        BufferedImage leftImage = ImageIO.read(leftPath.toFile());
        BufferedImage rightImage = ImageIO.read(rightPath.toFile());
        if (leftImage instanceof BufferedImage && rightImage instanceof BufferedImage) {
            Image finalImage = this.joinImage(leftImage, rightImage);
            monitor.worked(1);
            ImageExporter.exportToFile((IPath)fileName, (BufferedImage)((BufferedImage)finalImage), (String)exportFormat, (IProgressMonitor)monitor, (float)format.getQuality());
        }
        ArrayList<IPath> filesToDelete = new ArrayList<IPath>();
        filesToDelete.add(rightPath);
        filesToDelete.add(leftPath);
        this.deleteFiles(filesToDelete);
    }

    protected void deleteFiles(List<IPath> filesToDelete) {
        for (IPath path : filesToDelete) {
            path.toFile().delete();
        }
    }

    protected Image joinImage(BufferedImage leftImage, BufferedImage rightImage) {
        int separator = (leftImage.getWidth() + rightImage.getWidth()) / 100;
        int wid = leftImage.getWidth() + rightImage.getWidth() + separator;
        int height = Math.max(leftImage.getHeight(), rightImage.getHeight());
        BufferedImage newImage = new BufferedImage(wid, height, leftImage.getType());
        Graphics2D g2 = newImage.createGraphics();
        Color oldColor = g2.getColor();
        g2.setPaint(Color.WHITE);
        g2.fillRect(0, 0, wid + separator, height);
        g2.setPaint(Color.BLACK);
        g2.fillRect(leftImage.getWidth(), 0, separator, height);
        g2.setColor(oldColor);
        g2.drawImage((Image)leftImage, 0, 0, null);
        g2.drawImage((Image)rightImage, leftImage.getWidth() + separator, 0, null);
        g2.dispose();
        return newImage;
    }

    protected IPath getValidPath(IPath destination, DiagramEditPart diagramEP, ImageFileFormat format) {
        IPath filePath;
        String filename = null;
        String extension = format.getName().toLowerCase();
        if (diagramEP != null) {
            Diagram diagram = (Diagram)diagramEP.getModel();
            DDiagram ddiagram = (DDiagram)diagram.getElement();
            filename = ddiagram.getDescription().getName();
            if (diagramEP == this.getLeftDiagramEditPart()) {
                filename = "left_" + filename;
            } else if (diagramEP == this.getRightDiagramEditPart()) {
                filename = "right_" + filename;
            }
        } else {
            filename = "Comparison_Image";
        }
        StringBuffer file = new StringBuffer(filename).append('.').append(extension);
        String filenameWithExtension = this.validFilename(file.toString());
        if (destination.append(filenameWithExtension).toFile().exists()) {
            int version = 1;
            do {
                String newFileName = this.validFilename(new StringBuffer(filename).append('_').append(String.valueOf(version)).append('.').append(extension).toString());
                filePath = destination.append(newFileName);
                ++version;
            } while (filePath.toFile().exists());
        } else {
            filePath = destination.append(filenameWithExtension);
        }
        return filePath;
    }

    protected String validFilename(String filename) {
        FileUtil util = new FileUtil(filename);
        if (util.isValid()) {
            return filename;
        }
        return util.getValidFilename();
    }
}

