/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.SelfType;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionHelper;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.LibraryIterationOrOperation;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;

public class TemplateParameterSubstitutionVisitor
extends AbstractExtendingVisitor<Object, Map<Integer, Type>>
implements TemplateParameterSubstitutions {
    private final @NonNull EnvironmentFactoryInternal environmentFactory;
    private final @Nullable Type selfType;
    private @Nullable TypedElement excludedTarget = null;
    private Element actual;

    public static @NonNull TemplateParameterSubstitutions createBindings(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Type formalType, @NonNull Type actualType) {
        TemplateParameterSubstitutionVisitor visitor = TemplateParameterSubstitutionVisitor.createVisitor(actualType, environmentFactory, null, null);
        visitor.analyzeType(formalType, actualType);
        return visitor;
    }

    public static @NonNull TemplateParameterSubstitutions createBindings(@NonNull EnvironmentFactoryInternal environmentFactory, @Nullable Type sourceType, @Nullable Type sourceTypeValue, @NonNull Operation candidateOperation) {
        TemplateParameterSubstitutionVisitor visitor = TemplateParameterSubstitutionVisitor.createVisitor(candidateOperation, environmentFactory, sourceType, null);
        visitor.analyzeType(candidateOperation.getOwningClass(), sourceType);
        Operation eObject = candidateOperation;
        while (eObject != null) {
            List<TemplateParameter> templateParameters;
            int iSize;
            TemplateSignature templateSignature;
            if (eObject instanceof TemplateableElement && (templateSignature = ((TemplateableElement)eObject).getOwnedSignature()) != null && (iSize = (templateParameters = templateSignature.getOwnedParameters()).size()) > 0) {
                return visitor;
            }
            eObject = eObject.eContainer();
        }
        return TemplateParameterSubstitutions.EMPTY;
    }

    protected static @NonNull TemplateParameterSubstitutionVisitor createVisitor(@NonNull EObject eObject, @NonNull EnvironmentFactoryInternal environmentFactory, @Nullable Type selfType, @Nullable Type selfTypeValue) {
        Resource resource = eObject.eResource();
        if (environmentFactory instanceof EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension) {
            return ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)environmentFactory).createTemplateParameterSubstitutionVisitor(selfType, null);
        }
        if (resource instanceof ASResource) {
            return ((ASResource)resource).getASResourceFactory().createTemplateParameterSubstitutionVisitor(environmentFactory, selfType, null);
        }
        return new TemplateParameterSubstitutionVisitor(environmentFactory, selfType, null);
    }

    public static @NonNull Type specializeType(@NonNull Type type, @NonNull CallExp callExp, @NonNull EnvironmentFactoryInternal environmentFactory, @Nullable Type selfType, @Nullable Type selfTypeValue) {
        TemplateParameterSubstitutionVisitor visitor = TemplateParameterSubstitutionVisitor.createVisitor(callExp, environmentFactory, selfType, null);
        visitor.exclude(callExp);
        visitor.visit(callExp);
        return visitor.specializeType(type);
    }

    public TemplateParameterSubstitutionVisitor(@NonNull EnvironmentFactoryInternal environmentFactory, @Nullable Type selfType, @Nullable Type selfTypeValue) {
        super(new HashMap());
        this.environmentFactory = environmentFactory;
        this.selfType = selfType;
    }

    protected void analyzeFeature(@Nullable Feature formalFeature, @Nullable TypedElement actualElement) {
        if (formalFeature != null && actualElement != null) {
            Class formalType = formalFeature.getOwningClass();
            Type actualType = actualElement.getType();
            this.analyzeType(formalType, actualType);
        }
    }

    protected void analyzeType(@Nullable Type newFormal, @Nullable Element newActual) {
        if (newFormal != null && newActual != null) {
            Element oldActual = this.actual;
            try {
                this.actual = newActual;
                newFormal.accept(this);
            }
            finally {
                this.actual = oldActual;
            }
        }
    }

    protected void analyzeTypedElement(@Nullable TypedElement newFormal, @Nullable TypedElement newActual) {
        if (newFormal != null && newActual != null && newActual != this.excludedTarget) {
            Element oldActual = this.actual;
            try {
                this.actual = newActual;
                newFormal.accept(this);
            }
            finally {
                this.actual = oldActual;
            }
        }
    }

    protected void analyzeTypedElements(@NonNull List<? extends TypedElement> formalElements, @Nullable List<? extends TypedElement> actualElements) {
        if (actualElements != null) {
            int iMax = Math.min(formalElements.size(), actualElements.size());
            int i = 0;
            while (i < iMax) {
                TypedElement formalElement = formalElements.get(i);
                TypedElement actualElement = actualElements.get(i);
                this.analyzeTypedElement(formalElement, actualElement);
                ++i;
            }
        }
    }

    protected void analyzeTypes(@NonNull List<? extends Type> formalElements, @NonNull List<? extends Type> actualElements) {
        int iMax = Math.min(formalElements.size(), actualElements.size());
        int i = 0;
        while (i < iMax) {
            this.analyzeType(formalElements.get(i), actualElements.get(i));
            ++i;
        }
    }

    private void exclude(@NonNull TypedElement typedElement) {
        assert (this.excludedTarget == null);
        this.excludedTarget = typedElement;
    }

    @Override
    public @Nullable Type get(@Nullable TemplateParameter templateParameter) {
        if (templateParameter == null) {
            return null;
        }
        return (Type)((Map)this.context).get(templateParameter.getTemplateParameterId().getIndex());
    }

    @Deprecated
    protected @Nullable TemplateParameterSubstitutionHelper getHelper(@NonNull Operation operation) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected @NonNull TupleType getSpecializedTupleType(@NonNull TupleType type) {
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        TupleType specializedTupleType = type;
        HashMap<String, Type> resolutions = null;
        List<Property> parts = specializedTupleType.getOwnedProperties();
        for (Property part : parts) {
            Type propertyType;
            Type resolvedPropertyType;
            if (part == null || (resolvedPropertyType = this.specializeType(propertyType = PivotUtilInternal.getType(part))) == propertyType) continue;
            if (resolutions == null) {
                resolutions = new HashMap<String, Type>();
            }
            resolutions.put(NameUtil.getSafeName(part), resolvedPropertyType);
        }
        if (resolutions != null) {
            void var7_8;
            ArrayList<@NonNull TuplePartId> partIds = new ArrayList<TuplePartId>(parts.size());
            boolean bl = false;
            while (var7_8 < parts.size()) {
                @NonNull Property part = parts.get((int)var7_8);
                String partName = NameUtil.getSafeName(part);
                Type resolvedPropertyType = (Type)resolutions.get(partName);
                TypeId partTypeId = resolvedPropertyType != null ? resolvedPropertyType.getTypeId() : part.getTypeId();
                TuplePartId tuplePartId = IdManager.getTuplePartId((int)var7_8, partName, partTypeId);
                partIds.add(tuplePartId);
                ++var7_8;
            }
            TupleTypeId tupleTypeId = IdManager.getTupleTypeId(ClassUtil.nonNullModel(type.getName()), partIds);
            specializedTupleType = metamodelManager.getCompleteModel().getTupleManager().getTupleType(metamodelManager.getEnvironmentFactory().getIdResolver(), tupleTypeId);
            return specializedTupleType;
        }
        HashMap<@NonNull String, @NonNull Type> partMap = new HashMap<String, Type>();
        for (TypedElement typedElement : type.getOwnedProperties()) {
            Type type1 = typedElement.getType();
            if (type1 == null) continue;
            Type type2 = metamodelManager.getPrimaryType(type1);
            Type type3 = this.specializeType(type2);
            partMap.put(PivotUtil.getName(typedElement), type3);
        }
        return metamodelManager.getCompleteModel().getTupleManager().getTupleType(NameUtil.getSafeName(type), partMap);
    }

    @Override
    public boolean isEmpty() {
        return ((Map)this.context).isEmpty();
    }

    public void put(int templateParameterIndex, @Nullable Type actualType) {
        ((Map)this.context).put(templateParameterIndex, actualType);
    }

    @Override
    public @NonNull Type put(@NonNull TemplateParameter formalTemplateParameter, @NonNull Type actualType) {
        TemplateParameterId elementId = formalTemplateParameter.getTemplateParameterId();
        int index = elementId.getIndex();
        Type oldType = (Type)((Map)this.context).get(index);
        if (oldType != null) {
            IdResolver idResolver = this.environmentFactory.getIdResolver();
            Type commonType = oldType.getCommonType(idResolver, actualType);
            Type bestType = this.environmentFactory.getMetamodelManager().getPrimaryType(commonType);
            if (bestType != oldType) {
                ((Map)this.context).put(index, bestType);
            }
            return bestType;
        }
        ((Map)this.context).put(index, actualType);
        return actualType;
    }

    public @NonNull Type specializeType(@NonNull Type type) {
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        TemplateParameter asTemplateParameter = type.isTemplateParameter();
        if (asTemplateParameter != null) {
            int index = asTemplateParameter.getTemplateParameterId().getIndex();
            Type actualType = (Type)((Map)this.context).get(index);
            return actualType != null ? actualType : type;
        }
        if (type instanceof SelfType) {
            return ClassUtil.nonNullState(this.selfType != null ? this.selfType : type);
        }
        if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            Type elementType = ClassUtil.nonNullModel(collectionType.getElementType());
            Type specializedElementType = this.specializeType(elementType);
            CollectionType unspecializedCollectionType = PivotUtil.getUnspecializedTemplateableElement(collectionType);
            return metamodelManager.getCompleteEnvironment().getCollectionType(unspecializedCollectionType, specializedElementType, collectionType.isIsNullFree(), collectionType.getLowerValue(), collectionType.getUpperValue());
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            Type keyType = ClassUtil.nonNullModel(mapType.getKeyType());
            Type valueType = ClassUtil.nonNullModel(mapType.getValueType());
            Type specializedKeyType = this.specializeType(keyType);
            Type specializedValueType = this.specializeType(valueType);
            MapType unspecializedMapType = PivotUtil.getUnspecializedTemplateableElement(mapType);
            return metamodelManager.getCompleteEnvironment().getMapType(unspecializedMapType, specializedKeyType, mapType.isKeysAreNullFree(), specializedValueType, mapType.isValuesAreNullFree());
        }
        if (type instanceof TupleType) {
            return this.getSpecializedTupleType((TupleType)type);
        }
        if (type instanceof LambdaType) {
            LambdaType lambdaType = (LambdaType)type;
            String typeName = ClassUtil.nonNullModel(lambdaType.getName());
            Type specializedContextType = this.specializeType(ClassUtil.nonNullModel(lambdaType.getContextType()));
            ArrayList<@NonNull Type> specializedParameterTypes = new ArrayList<Type>();
            for (Type parameterType : lambdaType.getParameterType()) {
                if (parameterType == null) continue;
                specializedParameterTypes.add(this.specializeType(parameterType));
            }
            Type specializedResultType = this.specializeType(ClassUtil.nonNullModel(lambdaType.getResultType()));
            return metamodelManager.getCompleteModel().getLambdaType(typeName, specializedContextType, specializedParameterTypes, specializedResultType);
        }
        Class partiallySpecializedType = (Class)type;
        Class unspecializedType = PivotUtil.getUnspecializedTemplateableElement(partiallySpecializedType);
        List ownedTemplateBindings = partiallySpecializedType.getOwnedBindings();
        if (ownedTemplateBindings.size() > 0) {
            ArrayList<@NonNull Type> templateArguments = new ArrayList<Type>();
            for (TemplateBinding ownedTemplateBinding : ownedTemplateBindings) {
                for (TemplateParameterSubstitution ownedTemplateParameterSubstitution : ownedTemplateBinding.getOwnedSubstitutions()) {
                    Type actualType = ownedTemplateParameterSubstitution.getActual();
                    if (actualType != null) {
                        actualType = this.specializeType(actualType);
                    } else {
                        TemplateParameter formalParameter = ownedTemplateParameterSubstitution.getFormal();
                        if (formalParameter != null) {
                            actualType = PivotUtil.basicGetLowerBound(formalParameter);
                        }
                    }
                    if (actualType == null) {
                        actualType = metamodelManager.getStandardLibrary().getOclAnyType();
                    }
                    templateArguments.add(actualType);
                }
            }
            return metamodelManager.getLibraryType(unspecializedType, templateArguments);
        }
        TemplateSignature ownedTemplateSignature = partiallySpecializedType.getOwnedSignature();
        if (ownedTemplateSignature != null) {
            ArrayList<@NonNull Type> templateArguments = new ArrayList<Type>();
            for (TemplateParameter ownedTemplateParameter : ownedTemplateSignature.getOwnedParameters()) {
                Type actualType = this.specializeType(ownedTemplateParameter);
                templateArguments.add(actualType);
            }
            return metamodelManager.getLibraryType(unspecializedType, templateArguments);
        }
        return type;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{");
        boolean isFirst = true;
        ArrayList keys = new ArrayList(((Map)this.context).keySet());
        Collections.sort(keys);
        for (Integer index : keys) {
            if (!isFirst) {
                s.append("\n");
            }
            s.append(index + " => " + ((Map)this.context).get(index));
            isFirst = false;
        }
        s.append("}");
        return s.toString();
    }

    @Override
    public String visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException("Unsupported " + this.getClass().getSimpleName() + " " + visitable.getClass().getSimpleName());
    }

    @Override
    public @Nullable Object visitClass(@NonNull Class object) {
        for (TemplateBinding templateBinding : object.getOwnedBindings()) {
            for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getOwnedSubstitutions()) {
                this.safeVisit(templateParameterSubstitution.getActual());
            }
        }
        return null;
    }

    @Override
    public @Nullable Object visitCollectionType(@NonNull CollectionType object) {
        if (this.actual instanceof CollectionType) {
            Type formalElementType = object.getElementType();
            Type actualElementType = ((CollectionType)this.actual).getElementType();
            this.analyzeType(formalElementType, actualElementType);
        }
        return null;
    }

    @Override
    public @Nullable Object visitIterateExp(@NonNull IterateExp object) {
        Iteration referredIteration = object.getReferredIteration();
        this.analyzeTypedElement(referredIteration, object);
        this.analyzeFeature(referredIteration, object.getOwnedSource());
        this.analyzeTypedElements(referredIteration.getOwnedIterators(), object.getOwnedIterators());
        this.analyzeTypedElements(referredIteration.getOwnedAccumulators(), Collections.singletonList(object.getOwnedResult()));
        this.analyzeTypedElements(referredIteration.getOwnedParameters(), Collections.singletonList(object.getOwnedBody()));
        return null;
    }

    @Override
    public @Nullable Object visitIteratorExp(@NonNull IteratorExp object) {
        Iteration referredIteration = object.getReferredIteration();
        this.analyzeTypedElement(referredIteration, object);
        this.analyzeFeature(referredIteration, object.getOwnedSource());
        this.analyzeTypedElements(referredIteration.getOwnedIterators(), object.getOwnedIterators());
        List<Parameter> formalElements = referredIteration.getOwnedParameters();
        if (formalElements.size() > 0) {
            OCLExpression actualElement = object.getOwnedBody();
            Type actualType = actualElement.getType();
            LibraryIterationOrOperation implementation = (LibraryIterationOrOperation)referredIteration.getImplementation();
            if (implementation != null) {
                actualType = implementation.resolveBodyType(this.environmentFactory, object, actualType);
            }
            this.analyzeType(formalElements.get(0).getType(), actualType);
        }
        return null;
    }

    @Override
    public @Nullable Object visitLambdaType(@NonNull LambdaType object) {
        if (this.actual instanceof LambdaType) {
            LambdaType actualLambdaType = (LambdaType)this.actual;
            this.analyzeType(object.getContextType(), actualLambdaType.getContextType());
            this.analyzeType(object.getResultType(), actualLambdaType.getResultType());
            this.analyzeTypes(object.getParameterType(), actualLambdaType.getParameterType());
        } else {
            this.analyzeType(object.getResultType(), this.actual);
        }
        return null;
    }

    @Override
    public @Nullable Object visitMapType(@NonNull MapType object) {
        if (this.actual instanceof MapType) {
            Type formalKeyType = object.getKeyType();
            Type formalValueType = object.getValueType();
            MapType mapType = (MapType)this.actual;
            Type actualKeyType = mapType.getKeyType();
            Type actualValueType = mapType.getValueType();
            this.analyzeType(formalKeyType, actualKeyType);
            this.analyzeType(formalValueType, actualValueType);
        }
        return null;
    }

    @Override
    public @Nullable Object visitOperationCallExp(@NonNull OperationCallExp object) {
        Operation referredOperation = object.getReferredOperation();
        this.analyzeTypedElement(referredOperation, object);
        OCLExpression source = object.getOwnedSource();
        if (source != null) {
            this.analyzeType(referredOperation.getOwningClass(), source.getType());
        }
        this.analyzeTypedElements(referredOperation.getOwnedParameters(), object.getOwnedArguments());
        LibraryIterationOrOperation implementation = (LibraryIterationOrOperation)referredOperation.getImplementation();
        if (implementation != null) {
            implementation.resolveUnmodeledTemplateParameterSubstitutions(this, object);
        }
        return null;
    }

    @Override
    public @Nullable Object visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp object) {
        Property referredProperty;
        Property referredOppositeProperty = object.getReferredProperty();
        if (referredOppositeProperty != null && (referredProperty = referredOppositeProperty.getOpposite()) != null) {
            this.analyzeFeature(referredProperty, object.getOwnedSource());
            this.analyzeTypedElement(referredProperty, object);
        }
        return null;
    }

    @Override
    public @Nullable Object visitParameter(@NonNull Parameter object) {
        if (object.isIsTypeof() && this.actual instanceof OCLExpression) {
            this.analyzeType(object.getType(), ((OCLExpression)this.actual).getTypeValue());
        } else {
            super.visitParameter(object);
        }
        return null;
    }

    @Override
    public @Nullable Object visitPrimitiveType(@NonNull PrimitiveType object) {
        return null;
    }

    @Override
    public @Nullable Object visitPropertyCallExp(@NonNull PropertyCallExp object) {
        Property referredProperty = object.getReferredProperty();
        if (referredProperty != null) {
            OCLExpression source = object.getOwnedSource();
            if (source != null) {
                Type sourceType = source.getType();
                this.analyzeType(referredProperty.getOwningClass(), sourceType);
            }
            this.analyzeTypedElement(referredProperty, object);
        }
        return null;
    }

    @Override
    public @Nullable Object visitSelfType(@NonNull SelfType object) {
        this.analyzeType(this.selfType, this.actual);
        return null;
    }

    @Override
    public @Nullable Object visitTemplateParameter(@NonNull TemplateParameter object) {
        if (this.actual instanceof Type) {
            this.put(object, (Type)this.actual);
        }
        return null;
    }

    @Override
    public @Nullable Object visitTupleType(@NonNull TupleType object) {
        if (this.actual instanceof TupleType) {
            this.analyzeTypedElements(object.getOwnedProperties(), ((TupleType)this.actual).getOwnedProperties());
        }
        return null;
    }

    @Override
    public @Nullable Object visitTypedElement(@NonNull TypedElement object) {
        if (this.actual instanceof TypedElement) {
            this.analyzeType(object.getType(), ((TypedElement)this.actual).getType());
        }
        return null;
    }
}

