/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public final class BooleanObjectPropertyEditor
extends PropertyEditor {
    private static final Image m_nullImage = CoreImages.getSharedImage(CoreImages.PROPERTIES_BOOLEAN_NULL);
    private static final Image m_trueImage = CoreImages.getSharedImage(CoreImages.PROPERTIES_TRUE);
    private static final Image m_falseImage = CoreImages.getSharedImage(CoreImages.PROPERTIES_FALSE);
    public static final PropertyEditor INSTANCE = new BooleanObjectPropertyEditor();

    private BooleanObjectPropertyEditor() {
    }

    @Override
    public void paint(Property property, Graphics graphics, int x, int y, int width, int height) throws Exception {
        Object value = property.getValue();
        if (value instanceof Boolean) {
            boolean booleanValue = (Boolean)value;
            Image image = booleanValue ? m_trueImage : m_falseImage;
            String text = Boolean.toString(booleanValue);
            this.paint(graphics, x, y, width, height, text, image);
        }
        if (value == null) {
            Image image = m_nullImage;
            String text = "null";
            this.paint(graphics, x, y, width, height, text, image);
        }
    }

    private void paint(Graphics graphics, int x, int y, int width, int height, String text, Image image) {
        DrawUtils.drawImageCV(graphics, image, x, y, height);
        int imageWidth = image.getBounds().width + 2;
        DrawUtils.drawStringCV(graphics, text, x += imageWidth, y, width -= imageWidth, height);
    }

    @Override
    public boolean activate(PropertyTable propertyTable, Property property, Point location) throws Exception {
        if (location == null || location.x < BooleanObjectPropertyEditor.m_trueImage.getBounds().width + 2) {
            this.invertValue(property);
        }
        return false;
    }

    @Override
    public void doubleClick(Property property, Point location) throws Exception {
        this.invertValue(property);
    }

    private void invertValue(Property property) throws Exception {
        Object value = property.getValue();
        if (value == null) {
            property.setValue(true);
            return;
        }
        if (value instanceof Boolean) {
            boolean booleanValue = (Boolean)value;
            property.setValue(!booleanValue);
            return;
        }
        property.setValue(true);
    }
}

