/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.swt.gef.GefMessages;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.actions.DimensionHeaderAction;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.actions.SetAlignmentAction;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.actions.SetGrabAction;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDimensionInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridRowInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class RowHeaderEditPart<C extends IControlInfo>
extends DimensionHeaderEditPart<C> {
    public RowHeaderEditPart(IGridLayoutInfo<C> layout, GridRowInfo<C> row, IFigure containerFigure) {
        super(layout, row, containerFigure);
    }

    protected IFigure createFigure() {
        Figure newFigure = new Figure(){

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                Rectangle r = this.getClientArea();
                graphics.setForegroundColor(ColorConstants.buttonDarker);
                graphics.drawLine(r.x, r.y, r.right(), r.y);
                graphics.drawLine(r.x, r.bottom() - 1, r.right(), r.bottom() - 1);
                String title = "" + (1 + RowHeaderEditPart.this.m_dimension.getIndex());
                Dimension textExtents = TextUtilities.INSTANCE.getTextExtents(title, graphics.getFont());
                if (r.height < 3 + textExtents.height + 3) {
                    return;
                }
                int titleTop = r.y + (r.height - textExtents.height) / 2;
                int titleBottom = titleTop + textExtents.height;
                int x = r.x + (r.width - textExtents.width) / 2;
                graphics.setForegroundColor(ColorConstants.black);
                graphics.drawText(title, x, titleTop);
                try {
                    Integer alignmentValue = RowHeaderEditPart.this.m_dimension.getAlignment();
                    if (alignmentValue != null && titleTop - r.y > 13) {
                        int alignment = alignmentValue;
                        Image image = alignment == 128 ? (Image)RowHeaderEditPart.this.getViewer().getResourceManager().get((DeviceResourceDescriptor)CoreImages.ALIGNMENT_V_SMALL_TOP) : (alignment == 0x1000000 ? (Image)RowHeaderEditPart.this.getViewer().getResourceManager().get((DeviceResourceDescriptor)CoreImages.ALIGNMENT_V_SMALL_CENTER) : (alignment == 1024 ? (Image)RowHeaderEditPart.this.getViewer().getResourceManager().get((DeviceResourceDescriptor)CoreImages.ALIGNMENT_V_SMALL_BOTTOM) : (Image)RowHeaderEditPart.this.getViewer().getResourceManager().get((DeviceResourceDescriptor)CoreImages.ALIGNMENT_V_SMALL_FILL)));
                        int y = r.y + 2;
                        this.drawCentered(graphics, image, y);
                    }
                    if (RowHeaderEditPart.this.m_dimension.getGrab() && titleBottom + 3 + 7 + 3 < r.bottom()) {
                        Image image = (Image)RowHeaderEditPart.this.getViewer().getResourceManager().get((DeviceResourceDescriptor)CoreImages.ALIGNMENT_V_SMALL_GROW);
                        this.drawCentered(graphics, image, r.bottom() - 3 - image.getBounds().height);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }

            private void drawCentered(Graphics graphics, Image image, int y) {
                int x = (this.getBounds().width - image.getBounds().width) / 2;
                graphics.drawImage(image, x, y);
            }
        };
        newFigure.setFont(DEFAULT_FONT);
        newFigure.setOpaque(true);
        return newFigure;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        int index = this.m_dimension.getIndex();
        IGridInfo gridInfo = this.m_layout.getGridInfo();
        Interval interval = gridInfo.getRowIntervals()[index];
        Rectangle bounds = new Rectangle(0, interval.begin(), ((GraphicalEditPart)this.getParent()).getFigure().getSize().width, interval.length() + 1);
        bounds.performTranslate(0, this.getOffset().y);
        this.getFigure().setBounds(bounds);
    }

    public void buildContextMenu(IMenuManager manager) {
        manager.add(new SetGrabAction(this, GefMessages.RowHeaderEditPart_grabExcessSpace, CoreImages.ALIGNMENT_V_MENU_GROW));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetAlignmentAction(this, GefMessages.RowHeaderEditPart_top, CoreImages.ALIGNMENT_V_MENU_TOP, 128));
        manager.add(new SetAlignmentAction(this, GefMessages.RowHeaderEditPart_center, CoreImages.ALIGNMENT_V_MENU_CENTER, 0x1000000));
        manager.add(new SetAlignmentAction(this, GefMessages.RowHeaderEditPart_bottom, CoreImages.ALIGNMENT_V_MENU_BOTTOM, 1024));
        manager.add(new SetAlignmentAction(this, GefMessages.RowHeaderEditPart_fill, CoreImages.ALIGNMENT_V_MENU_FILL, 4));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new DimensionHeaderAction<C>(this, GefMessages.RowHeaderEditPart_delete, CoreImages.ALIGNMENT_V_MENU_DELETE){

            @Override
            protected void run(GridDimensionInfo<C> dimension) throws Exception {
                RowHeaderEditPart.this.m_layout.command_deleteRow(dimension.getIndex(), true);
            }
        });
    }
}

