/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.model;

import java.net.URI;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.model.IScript;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugElement;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;

public class Script
extends JavaScriptDebugElement
implements IScript,
Comparable,
ITerminate {
    private ScriptReference script = null;

    public Script(JavaScriptDebugTarget target, ScriptReference script) {
        super(target);
        this.script = script;
    }

    @Override
    public String source() {
        return this.script.source();
    }

    @Override
    public URI sourceURI() {
        return this.script.sourceURI();
    }

    public int compareTo(Object o) {
        if (o instanceof Script) {
            Script s2 = (Script)o;
            return this.sourceURI().toString().compareTo(s2.sourceURI().toString());
        }
        return 0;
    }

    public static String resolveName(URI sourceuri) {
        String name = URIUtil.lastSegment((URI)sourceuri);
        if (name == null) {
            name = new Path(sourceuri.getSchemeSpecificPart()).lastSegment();
        }
        if (name != null && !name.toLowerCase().endsWith("js")) {
            StringBuffer newname = new StringBuffer(name).append('.').append("js");
            name = newname.toString();
        }
        return name;
    }

    public boolean canTerminate() {
        return this.getJavaScriptDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getJavaScriptDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getJavaScriptDebugTarget().terminate();
    }
}

