/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.xtext.ui.editor.contentassist.ISmartContextInformation;

public class SmartInformationAwareContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private IContentAssistProcessor fProcessor;
    private IContextInformation fContextInformation;
    private ITextViewer fViewer;

    public SmartInformationAwareContextInformationValidator(IContentAssistProcessor processor) {
        this.fProcessor = processor;
    }

    public void install(IContextInformation contextInformation, ITextViewer viewer, int offset) {
        this.fContextInformation = contextInformation;
        this.fViewer = viewer;
    }

    public boolean isContextInformationValid(int offset) {
        if (this.fContextInformation instanceof ISmartContextInformation) {
            return ((ISmartContextInformation)this.fContextInformation).isContextInformationValid(this.fViewer, offset);
        }
        IContextInformation[] infos = this.fProcessor.computeContextInformation(this.fViewer, offset);
        if (infos != null && infos.length > 0) {
            int i = 0;
            while (i < infos.length) {
                if (this.fContextInformation.equals((Object)infos[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean updatePresentation(int offset, TextPresentation presentation) {
        if (this.fContextInformation instanceof ISmartContextInformation) {
            return ((ISmartContextInformation)this.fContextInformation).updatePresentation(this.fViewer, offset, presentation);
        }
        return false;
    }
}

