/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.actions;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr.ExpressionElement;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr.ExpressionsByOperatorsPage;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;

public class DeleteExpressionAction
extends Action {
    TableViewer tableViewer;
    WizardPage wp;

    public DeleteExpressionAction(TableViewer tableViewer, WizardPage wp) {
        super(Messages._UI_ACTION_DELETE_EXPRESSION);
        this.tableViewer = tableViewer;
        this.wp = wp;
    }

    public void run() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection es = (IStructuredSelection)selection;
        Iterator elements = es.iterator();
        this.tableViewer.cancelEditing();
        ExpressionElement expressionElement = null;
        while (elements.hasNext()) {
            Object item = elements.next();
            if (!(item instanceof ExpressionElement)) continue;
            expressionElement = (ExpressionElement)item;
            expressionElement.deleteExpression();
        }
        if (expressionElement != null) {
            QueryValueExpression expr = null;
            Vector elementsVector = expressionElement.getElementsVector();
            if (elementsVector != null && !elementsVector.isEmpty()) {
                ExpressionElement e = (ExpressionElement)elementsVector.get(0);
                expr = e.getExpression();
            }
            if (expr == null) {
                expr = ExpressionHelper.createExpression();
            }
            if (this.wp instanceof ExpressionsByOperatorsPage) {
                ((ExpressionsByOperatorsPage)this.wp).setExpression(expr);
                ((ExpressionsByOperatorsPage)this.wp).updateFinishButton();
            }
            this.tableViewer.setInput((Object)expr);
        }
    }
}

