/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.internal.features.context.impl.base.DoubleClickContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.parts.AnchorContainerDelegate;
import org.eclipse.graphiti.ui.internal.parts.CompositeConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.IAnchorContainerDelegate;
import org.eclipse.graphiti.ui.internal.parts.IConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.graphiti.ui.platform.GraphitiConnectionEditPart;

public abstract class ConnectionEditPart
extends GraphitiConnectionEditPart
implements IConnectionEditPart,
NodeEditPart {
    private final IAnchorContainerDelegate delegate;
    private EditPart contextParent;

    public ConnectionEditPart(IConfigurationProviderInternal configurationProvider, Connection connection, EditPart contextParent) {
        this.setModel(connection);
        this.delegate = new AnchorContainerDelegate(configurationProvider, (PictogramElement)connection, (EditPart)this);
        this.contextParent = contextParent;
    }

    public void activate() {
        super.activate();
        this.delegate.activate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", this.getConfigurationProvider().getEditPolicyFactory().createConnectionHighlightEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createConnectionDeleteEditPolicy(this.getConfigurationProvider()));
        this.installEditPolicy("GraphicalNodeEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createConnectionEditPolicy());
        this.installEditPolicy("Selection Feedback", this.getConfigurationProvider().getEditPolicyFactory().createShapeHighlightEditPolicy());
    }

    protected IFigure createFigure() {
        IFigure ret = this.delegate.createFigure();
        return ret;
    }

    public void deactivate() {
        this.delegate.deactivate();
        super.deactivate();
    }

    @Override
    public IConfigurationProviderInternal getConfigurationProvider() {
        return this.delegate.getConfigurationProvider();
    }

    protected Connection getConnection() {
        Connection ret = null;
        if (this.getPictogramElement() instanceof Connection) {
            ret = (Connection)this.getPictogramElement();
        }
        return ret;
    }

    @Override
    public PictogramElement getPictogramElement() {
        return this.delegate.getPictogramElement();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.delegate.refreshFigureForEditPart();
    }

    @Override
    public List<PictogramElement> getModelChildren() {
        return new ArrayList<PictogramElement>();
    }

    @Override
    public List<Connection> getModelSourceConnections() {
        return new ArrayList<Connection>();
    }

    @Override
    public List<Connection> getModelTargetConnections() {
        return new ArrayList<Connection>();
    }

    public EditPart getTargetEditPart(Request request) {
        if (this.contextParent instanceof CompositeConnectionEditPart) {
            if (request instanceof SelectionRequest) {
                ((CompositeConnectionEditPart)this.contextParent).setOriginallySelectedChild(this);
            }
            return this.contextParent;
        }
        return super.getTargetEditPart(request);
    }

    public Object getAdapter(Class key) {
        Object ret = this.delegate.getAdapter(key);
        if (ret == null) {
            ret = super.getAdapter(key);
        }
        return ret;
    }

    public IFeatureProvider getFeatureProvider() {
        IFeatureProvider ret = null;
        if (this.delegate != null) {
            ret = this.delegate.getFeatureProvider();
        }
        return ret;
    }

    @Override
    public IPictogramElementDelegate getPictogramElementDelegate() {
        return this.delegate;
    }

    @Override
    public void forceVisualRefresh() {
        this.getPictogramElementDelegate().setForceRefresh(true);
        this.refreshVisuals();
        this.getPictogramElementDelegate().setForceRefresh(false);
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    public ConnectionAnchor getSourceConnectionAnchor(org.eclipse.gef.ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(org.eclipse.gef.ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest r = (CreateConnectionRequest)request;
            return new XYAnchor(r.getLocation());
        }
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    public void performRequest(Request request) {
        Connection shape = (Connection)this.getModel();
        if (request.getType().equals("open")) {
            IToolBehaviorProvider currentToolBehaviorProvider;
            ICustomFeature doubleClickFeature;
            DoubleClickContext dcc = new DoubleClickContext(this.getPictogramElement(), (PictogramElement)shape, shape.getGraphicsAlgorithm());
            DiagramBehavior diagramBehavior = this.getConfigurationProvider().getDiagramBehavior();
            if (request instanceof LocationRequest) {
                Point location = ((LocationRequest)request).getLocation();
                location = diagramBehavior.calculateRealMouseLocation(location);
                dcc.setLocation(location.x, location.y);
            }
            if ((doubleClickFeature = (currentToolBehaviorProvider = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider()).getDoubleClickFeature((IDoubleClickContext)dcc)) != null && doubleClickFeature.canExecute((IContext)dcc)) {
                GenericFeatureCommandWithContext commandWithContext = new GenericFeatureCommandWithContext((IFeature)doubleClickFeature, (IContext)dcc);
                CommandStack commandStack = diagramBehavior.getEditDomain().getCommandStack();
                commandStack.execute((Command)new GefCommandWrapper((ICommand)commandWithContext, diagramBehavior.getEditingDomain()));
            }
        }
        super.performRequest(request);
    }

    @Override
    public void refreshDecorators() {
        this.delegate.refreshDecorators();
    }
}

